/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css2.user;

import org.w3c.css.parser.CssSelectors;
import org.w3c.css.parser.CssStyle;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.properties.css2.user.Css2Style;
import org.w3c.css.properties.css2.user.OutlineColorATSC;
import org.w3c.css.properties.css2.user.OutlineStyleATSC;
import org.w3c.css.properties.css2.user.OutlineWidthATSC;
import org.w3c.css.properties.css2.user.UserProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssOperator;
import org.w3c.css.values.CssValue;

public class OutlineATSC
extends UserProperty
implements CssOperator {
    OutlineColorATSC color;
    OutlineWidthATSC width;
    OutlineStyleATSC style;
    boolean same;

    public OutlineATSC() {
    }

    public OutlineATSC(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 3) {
            throw new InvalidParamException("unrecognize", ac);
        }
        CssValue val = expression.getValue();
        char op = ' ';
        boolean find = true;
        int max_values = 3;
        ac.getFrame().addWarning("atsc", val.toString());
        if (val.equals(inherit)) {
            if (expression.getCount() > 1) {
                throw new InvalidParamException("unrecognize", ac);
            }
            this.same = true;
            this.color = new OutlineColorATSC(ac, expression);
            this.width = new OutlineWidthATSC();
            this.width.value = inherit;
            this.style = new OutlineStyleATSC();
            this.style.value = OutlineStyleATSC.BORDERSTYLE.length - 1;
            return;
        }
        while (find && max_values-- > 0) {
            find = false;
            val = expression.getValue();
            op = expression.getOperator();
            if (val != null && val.equals(inherit)) {
                throw new InvalidParamException("unrecognize", ac);
            }
            if (val == null) break;
            if (op != ' ') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            if (this.style == null) {
                try {
                    this.style = new OutlineStyleATSC(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.color == null) {
                try {
                    this.color = new OutlineColorATSC(ac, expression);
                    find = true;
                }
                catch (InvalidParamException e) {
                    // empty catch block
                }
            }
            if (!find && this.width == null) {
                this.width = new OutlineWidthATSC(ac, expression);
                find = true;
            }
            if (val == null || find) continue;
            throw new InvalidParamException("unrecognize", ac);
        }
        if (max_values >= 2) {
            throw new InvalidParamException("few-value", this.getPropertyName(), ac);
        }
    }

    public OutlineATSC(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    @Override
    public Object get() {
        return this.color;
    }

    @Override
    public String getPropertyName() {
        return "outline";
    }

    @Override
    public String toString() {
        if (this.same) {
            return this.color.toString();
        }
        String ret = "";
        if (this.color != null) {
            ret = ret + " " + this.color;
        }
        if (this.width != null) {
            ret = ret + " " + this.width;
        }
        if (this.style != null) {
            ret = ret + " " + this.style;
        }
        return ret.substring(1);
    }

    @Override
    public void setImportant() {
        super.setImportant();
        if (this.color != null) {
            this.color.setImportant();
        }
        if (this.width != null) {
            this.width.setImportant();
        }
        if (this.style != null) {
            this.style.setImportant();
        }
    }

    @Override
    public boolean getImportant() {
        return !(this.width != null && !this.width.getImportant() || this.color != null && !this.color.getImportant() || this.style != null && !this.style.getImportant());
    }

    @Override
    public void addToStyle(ApplContext ac, CssStyle style0) {
        ((Css2Style)style0).outline.same = this.same;
        if (this.color != null) {
            this.color.addToStyle(ac, style0);
        }
        if (this.width != null) {
            this.width.addToStyle(ac, style0);
        }
        if (this.style != null) {
            this.style.addToStyle(ac, style0);
        }
    }

    @Override
    public void setInfo(int line, String source) {
        super.setInfo(line, source);
        if (this.color != null) {
            this.color.setInfo(line, source);
        }
        if (this.width != null) {
            this.width.setInfo(line, source);
        }
        if (this.style != null) {
            this.style.setInfo(line, source);
        }
    }

    @Override
    public boolean equals(CssProperty property) {
        return false;
    }

    @Override
    public void setSelectors(CssSelectors selector) {
        super.setSelectors(selector);
        if (this.color != null) {
            this.color.setSelectors(selector);
        }
        if (this.width != null) {
            this.width.setSelectors(selector);
        }
        if (this.style != null) {
            this.style.setSelectors(selector);
        }
    }

    @Override
    public CssProperty getPropertyInStyle(CssStyle style, boolean resolve) {
        if (resolve) {
            return ((Css2Style)style).getOutlineATSC();
        }
        return ((Css2Style)style).outlineATSC;
    }
}

