/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.packager.ui;

import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.tizen.common.util.ViewUtil;
import org.tizen.web.packager.ui.Activator;
import org.tizen.web.packager.ui.Messages;

public class QuestionDialog
implements Runnable {
    private boolean wantToContinue = false;
    private String togglePreferenceKey;
    private String message;
    private String title;

    public QuestionDialog(String title, String message, String togglePreferenceKey) {
        this.title = title;
        this.message = message;
        this.togglePreferenceKey = togglePreferenceKey;
    }

    @Override
    public void run() {
        IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        boolean dontShowDialog = ps.getBoolean(this.togglePreferenceKey);
        if (dontShowDialog) {
            this.wantToContinue = true;
            return;
        }
        IWorkbenchWindow window = ViewUtil.getWorkbenchWindow();
        if (window == null) {
            this.wantToContinue = true;
            return;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.open((int)3, (Shell)window.getShell(), (String)this.title, (String)this.message, (String)Messages.DIALOG_TOGGLE_ALWAYS_PACKAGE_WITHOUT_ASKING, (boolean)false, (IPreferenceStore)ps, (String)this.togglePreferenceKey, (int)0);
        ps.setValue(this.togglePreferenceKey, dialog.getToggleState());
        if (dialog.getReturnCode() == 2) {
            this.wantToContinue = true;
        }
    }

    public boolean wantToContinue() {
        return this.wantToContinue;
    }
}

