#ifndef _EFL_TEXT_TYPES_EOT_H_
#define _EFL_TEXT_TYPES_EOT_H_

#ifndef _EFL_TEXT_TYPES_EOT_TYPES
#define _EFL_TEXT_TYPES_EOT_TYPES

/** Bidirectionaltext type
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_TEXT_BIDIRECTIONAL_TYPE_NATURAL = 0, /**< Natural text type, same as
                                            * neutral */
  EFL_TEXT_BIDIRECTIONAL_TYPE_NEUTRAL = 0, /**< Neutral text type, same as
                                            * natural */
  EFL_TEXT_BIDIRECTIONAL_TYPE_LTR, /**< Left to right text type */
  EFL_TEXT_BIDIRECTIONAL_TYPE_RTL, /**< Right to left text type */
  EFL_TEXT_BIDIRECTIONAL_TYPE_INHERIT, /**< Inherit text type */
  EFL_TEXT_BIDIRECTIONAL_TYPE_ANY_RTL /**< @internal EVAS_BIDI_DIRECTION_ANY_RTL
                                       * is not made for public. It should be
                                       * opened to public when it is accepted
                                       * to EFL upstream. */
} Efl_Text_Bidirectional_Type;

/**
 * @brief This structure includes all the information about content changes.
 *
 * It's meant to be used to implement undo/redo.
 *
 * @ingroup Efl_Ui
 */
typedef struct _Efl_Ui_Text_Change_Info
{
  const char *content; /**< The content added/removed */
  size_t position; /**< The position where it was added/removed */
  size_t length; /**< The length of content in characters (not bytes, actual
                  * unicode characters) */
  Eina_Bool insert; /**< @c true if the content was inserted, @c false if
                     * removei */
  Eina_Bool merge; /**< @c true if can be merged with the previous one. Used for
                    * example with insertion when something is already selected
                    */
} Efl_Ui_Text_Change_Info;


#endif

#endif
