#ifndef _EFL_EXE_EO_H_
#define _EFL_EXE_EO_H_

#ifndef _EFL_EXE_EO_CLASS_TYPE
#define _EFL_EXE_EO_CLASS_TYPE

typedef Eo Efl_Exe;

#endif

#ifndef _EFL_EXE_EO_TYPES
#define _EFL_EXE_EO_TYPES

/** No description supplied.
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_EXE_SIGNAL_INT = 0,
  EFL_EXE_SIGNAL_QUIT,
  EFL_EXE_SIGNAL_TERM,
  EFL_EXE_SIGNAL_KILL,
  EFL_EXE_SIGNAL_CONT,
  EFL_EXE_SIGNAL_STOP,
  EFL_EXE_SIGNAL_HUP,
  EFL_EXE_SIGNAL_USR1,
  EFL_EXE_SIGNAL_USR2
} Efl_Exe_Signal;

/** No description supplied.
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_EXE_FLAGS_NONE = 0,
  EFL_EXE_FLAGS_GROUP_LEADER = 1,
  EFL_EXE_FLAGS_EXIT_WITH_PARENT = 2,
  EFL_EXE_FLAGS_HIDE_IO = 4
} Efl_Exe_Flags;


#endif
/** No description supplied.
 *
 * @ingroup Efl_Exe
 */
#define EFL_EXE_CLASS efl_exe_class_get()

EWAPI const Efl_Class *efl_exe_class_get(void);

EOAPI void efl_exe_signal(Eo *obj, Efl_Exe_Signal sig);

EOAPI void efl_exe_flags_set(Eo *obj, Efl_Exe_Flags flags);

EOAPI Efl_Exe_Flags efl_exe_flags_get(const Eo *obj);

/**
 * @brief The final exit signal of this task.
 *
 * @param[in] obj The object.
 *
 * @return The exit signal, or -1 if no exit signal happened
 *
 * @ingroup Efl_Exe
 */
EOAPI int efl_exe_exit_signal_get(const Eo *obj);

#endif
