#ifndef _EFL_INPUT_DEVICE_EO_LEGACY_H_
#define _EFL_INPUT_DEVICE_EO_LEGACY_H_

#ifndef _EFL_INPUT_DEVICE_EO_CLASS_TYPE
#define _EFL_INPUT_DEVICE_EO_CLASS_TYPE

typedef Eo Efl_Input_Device;

#endif

#ifndef _EFL_INPUT_DEVICE_EO_TYPES
#define _EFL_INPUT_DEVICE_EO_TYPES

/**
 * @brief General type of input device.
 *
 * Legacy support since 1.8 as @c Evas_Device_Class.
 *
 * @ingroup Efl_Input
 */
typedef enum
{
  EFL_INPUT_DEVICE_TYPE_NONE = 0, /**< Not a device. */
  EFL_INPUT_DEVICE_TYPE_SEAT, /**< The user/seat (the user themselves). */
  EFL_INPUT_DEVICE_TYPE_KEYBOARD, /**< A regular keyboard, numberpad or attached
                                   * buttons. */
  EFL_INPUT_DEVICE_TYPE_MOUSE, /**< A mouse, trackball or touchpad relative
                                * motion device. */
  EFL_INPUT_DEVICE_TYPE_TOUCH, /**< A touchscreen with fingers or stylus. */
  EFL_INPUT_DEVICE_TYPE_PEN, /**< A special pen device. */
  EFL_INPUT_DEVICE_TYPE_WAND, /**< A laser pointer, wii-style or "Minority
                               * Report" pointing device. */
  EFL_INPUT_DEVICE_TYPE_GAMEPAD /**< A gamepad controller or joystick. */
} Efl_Input_Device_Type;

/**
 * @brief General type of input device.
 *
 * Legacy support since 1.8 as @c Evas_Device_Subclass.
 *
 * @ingroup Efl_Input_Device
 */
typedef enum
{
  EFL_INPUT_DEVICE_SUBTYPE_NONE = 0, /**< Not a device. */
  EFL_INPUT_DEVICE_SUBTYPE_FINGER, /**< The normal flat of your finger. */
  EFL_INPUT_DEVICE_SUBTYPE_FINGERNAIL, /**< A fingernai. */
  EFL_INPUT_DEVICE_SUBTYPE_KNUCKLE, /**< A Knuckle. */
  EFL_INPUT_DEVICE_SUBTYPE_PALM, /**< The palm of a users hand. */
  EFL_INPUT_DEVICE_SUBTYPE_HAND_SIZE, /**< The side of your hand. */
  EFL_INPUT_DEVICE_SUBTYPE_HAND_FLAT, /**< The flat of your hand. */
  EFL_INPUT_DEVICE_SUBTYPE_PEN_TIP, /**< The tip of a pen. */
  EFL_INPUT_DEVICE_SUBTYPE_TRACKPAD, /**< A trackpad style mouse. */
  EFL_INPUT_DEVICE_SUBTYPE_TRACKPOINT, /**< A trackpoint style mouse. */
  EFL_INPUT_DEVICE_SUBTYPE_TRACKBALL, /**< A trackball style mouse. */
  EFL_INPUT_DEVICE_SUBTYPE_REMOCON, /**< A remote controller. */
  EFL_INPUT_DEVICE_SUBTYPE_VIRTUAL_KEYBOARD /**< A virtual keyboard. */
} Efl_Input_Device_Subtype;


#endif










#endif
