#ifndef _EFL_ORIENTATION_EO_H_
#define _EFL_ORIENTATION_EO_H_

#ifndef _EFL_ORIENTATION_EO_CLASS_TYPE
#define _EFL_ORIENTATION_EO_CLASS_TYPE

typedef Eo Efl_Orientation;

#endif

#ifndef _EFL_ORIENTATION_EO_TYPES
#define _EFL_ORIENTATION_EO_TYPES

/**
 * @brief An orientation type, to rotate visual objects.
 *
 * Not to be confused with @ref Efl_Ui_Dir which is meant for widgets, rather
 * than images and canvases. This enum is used to rotate images, videos and the
 * like.
 *
 * See also @ref Efl_Orientation.
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_ORIENT_NONE = 0, /**< Default, same as up */
  EFL_ORIENT_UP = 0, /**< Orient up, do not rotate. */
  EFL_ORIENT_RIGHT = 90, /**< Orient right, rotate 90 degrees counter
                          * clock-wise. */
  EFL_ORIENT_DOWN = 180, /**< Orient down, rotate 180 degrees. */
  EFL_ORIENT_LEFT = 270 /**< Orient left, rotate 90 degrees clock-wise. */
} Efl_Orient;

/**
 * @brief A flip type, to flip visual objects.
 *
 * See also @ref Efl_Orientation.
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_FLIP_NONE = 0, /**< No flip */
  EFL_FLIP_HORIZONTAL = 1, /**< Flip image horizontally */
  EFL_FLIP_VERTICAL = 2 /**< Flip image vertically */
} Efl_Flip;


#endif
/** Efl orientation interface
 *
 * @ingroup Efl_Orientation
 */
#define EFL_ORIENTATION_INTERFACE efl_orientation_interface_get()

EWAPI const Efl_Class *efl_orientation_interface_get(void);

/**
 * @brief Control the orientation of a given object.
 *
 * This can be used to set the rotation on an image or a window, for instance.
 *
 * @param[in] obj The object.
 * @param[in] dir The rotation angle (CCW), see @ref Efl_Orient.
 *
 * @ingroup Efl_Orientation
 */
EOAPI void efl_orientation_set(Eo *obj, Efl_Orient dir);

/**
 * @brief Control the orientation of a given object.
 *
 * This can be used to set the rotation on an image or a window, for instance.
 *
 * @param[in] obj The object.
 *
 * @return The rotation angle (CCW), see @ref Efl_Orient.
 *
 * @ingroup Efl_Orientation
 */
EOAPI Efl_Orient efl_orientation_get(const Eo *obj);

/**
 * @brief Control the flip of the given image
 *
 * Use this function to change how your image is to be flipped: vertically or
 * horizontally or transpose or traverse.
 *
 * @param[in] obj The object.
 * @param[in] flip Flip method
 *
 * @ingroup Efl_Orientation
 */
EOAPI void efl_orientation_flip_set(Eo *obj, Efl_Flip flip);

/**
 * @brief Control the flip of the given image
 *
 * Use this function to change how your image is to be flipped: vertically or
 * horizontally or transpose or traverse.
 *
 * @param[in] obj The object.
 *
 * @return Flip method
 *
 * @ingroup Efl_Orientation
 */
EOAPI Efl_Flip efl_orientation_flip_get(const Eo *obj);

#endif
