/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager;

import java.io.File;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.List;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import org.tizen.iotsetupmanager.FlashProfile;

public class FlashProfileEditDialog
extends Dialog<FlashProfile> {
    private ButtonType okButton = new ButtonType("OK", ButtonBar.ButtonData.OK_DONE);
    private ButtonType cancelButton = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);

    public FlashProfileEditDialog(FlashProfile profile) {
        FlashProfile editedProfile = profile.clone();
        int padding = 10;
        this.setTitle("Edit Profile");
        this.setHeaderText(null);
        GridPane mainGrid = new GridPane();
        mainGrid.setHgap(10.0);
        mainGrid.setVgap(10.0);
        GridPane profileGrid = new GridPane();
        profileGrid.setHgap(10.0);
        profileGrid.setVgap(10.0);
        profileGrid.getColumnConstraints().add((Object)new ColumnConstraints(90.0));
        profileGrid.getColumnConstraints().add((Object)new ColumnConstraints(125.0));
        profileGrid.getColumnConstraints().add((Object)new ColumnConstraints(217.0));
        GridPane imageGrid = new GridPane();
        imageGrid.setHgap(10.0);
        imageGrid.setVgap(10.0);
        imageGrid.getColumnConstraints().add((Object)new ColumnConstraints(90.0));
        imageGrid.getColumnConstraints().add((Object)new ColumnConstraints(125.0));
        imageGrid.getColumnConstraints().add((Object)new ColumnConstraints(217.0));
        GridPane networkGrid = new GridPane();
        networkGrid.setHgap(10.0);
        networkGrid.setVgap(10.0);
        networkGrid.getColumnConstraints().add((Object)new ColumnConstraints(90.0));
        networkGrid.getColumnConstraints().add((Object)new ColumnConstraints(125.0));
        networkGrid.getColumnConstraints().add((Object)new ColumnConstraints(217.0));
        Label profileNameLabel = new Label("Profile name");
        TextField profileNameEdit = new TextField(editedProfile.name);
        profileGrid.add((Node)profileNameLabel, 1, 0);
        GridPane.setHalignment((Node)profileNameLabel, (HPos)HPos.RIGHT);
        profileGrid.add((Node)profileNameEdit, 2, 0);
        Label targetLabel = new Label("Target");
        ComboBox selectTargetCombo = new ComboBox();
        List<String> targets = FlashProfile.getReadableDeviceTypes();
        for (String target : targets) {
            selectTargetCombo.getItems().add((Object)target);
        }
        selectTargetCombo.getSelectionModel().select((Object)FlashProfile.getReadableDeviceType(editedProfile.deviceType));
        profileGrid.add((Node)targetLabel, 1, 1);
        GridPane.setHalignment((Node)targetLabel, (HPos)HPos.RIGHT);
        profileGrid.add((Node)selectTargetCombo, 2, 1);
        Label bootImageLabel = new Label("Boot image");
        final TextField bootImagePath = new TextField(editedProfile.bootPath);
        Button bootImageBrowse = new Button("Browse");
        bootImageBrowse.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                File file;
                File userFile;
                FileChooser fileChooser = new FileChooser();
                fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Image Files", new String[]{"*.tar.gz"}), new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
                fileChooser.setTitle("Open Boot Image File");
                if (bootImagePath != null && bootImagePath.getText() != null && !bootImagePath.getText().isEmpty() && (userFile = new File(bootImagePath.getText())) != null && userFile.getParentFile() != null && userFile.getParentFile().exists()) {
                    fileChooser.setInitialDirectory(userFile.getParentFile());
                }
                if ((file = fileChooser.showOpenDialog((Window)new Stage())) != null && bootImagePath != null) {
                    bootImagePath.setText(file.getPath());
                }
            }
        });
        imageGrid.add((Node)bootImageLabel, 1, 0);
        GridPane.setHalignment((Node)bootImageLabel, (HPos)HPos.RIGHT);
        imageGrid.add((Node)bootImagePath, 2, 0);
        imageGrid.add((Node)bootImageBrowse, 3, 0);
        Label platformImageLabel = new Label("Platform image");
        final TextField platformImagePath = new TextField(editedProfile.platformPath);
        Button platformImageBrowse = new Button("Browse");
        platformImageBrowse.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                File userFile;
                FileChooser fileChooser = new FileChooser();
                fileChooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("Image Files", new String[]{"*.tar.gz"}), new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"})});
                fileChooser.setTitle("Open Platform Image File");
                if (platformImagePath != null && platformImagePath.getText() != null && !platformImagePath.getText().isEmpty() && (userFile = new File(platformImagePath.getText())) != null && userFile.getParentFile() != null && userFile.getParentFile().exists()) {
                    fileChooser.setInitialDirectory(userFile.getParentFile());
                }
                File file = fileChooser.showOpenDialog((Window)new Stage());
                if (platformImagePath != null && file != null) {
                    platformImagePath.setText(file.getPath());
                }
            }
        });
        imageGrid.add((Node)platformImageLabel, 1, 1);
        GridPane.setHalignment((Node)platformImageLabel, (HPos)HPos.RIGHT);
        imageGrid.add((Node)platformImagePath, 2, 1);
        imageGrid.add((Node)platformImageBrowse, 3, 1);
        Label rpmLabel = new Label("RPM bundles");
        final TextField rpmPath = new TextField(editedProfile.rpmPath);
        Button rpmBrowse = new Button("Browse");
        rpmBrowse.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                File userFile;
                DirectoryChooser directoryChooser = new DirectoryChooser();
                directoryChooser.setTitle("Select RPM Folder");
                if (rpmPath != null && rpmPath.getText() != null && !rpmPath.getText().isEmpty() && (userFile = new File(rpmPath.getText())) != null && userFile.getParentFile() != null && userFile.getParentFile().exists()) {
                    directoryChooser.setInitialDirectory(userFile.getParentFile());
                }
                File selectedDirectory = directoryChooser.showDialog(null);
                if (rpmPath != null && selectedDirectory != null) {
                    rpmPath.setText(selectedDirectory.getAbsolutePath());
                }
            }
        });
        imageGrid.add((Node)rpmLabel, 1, 2);
        GridPane.setHalignment((Node)rpmLabel, (HPos)HPos.RIGHT);
        imageGrid.add((Node)rpmPath, 2, 2);
        imageGrid.add((Node)rpmBrowse, 3, 2);
        VBox binariesHintLabel = new VBox(new Node[]{new Label("WARNING for RPMs"), new Label("In Windows RPM installation is supported only for iot-headed 32 bit platform images")});
        imageGrid.add((Node)binariesHintLabel, 2, 3, 2, 1);
        CheckBox wifiCheckBox = new CheckBox("Wifi: ");
        if (editedProfile.networkData != null && editedProfile.networkData.wifi != null) {
            wifiCheckBox.setSelected(editedProfile.networkData.wifi.enabled.booleanValue());
        } else {
            wifiCheckBox.setSelected(false);
        }
        networkGrid.add((Node)wifiCheckBox, 0, 0);
        Label ssidLabel = new Label("SSID");
        TextField ssidText = new TextField("SSID");
        if (editedProfile.networkData.wifi != null) {
            ssidText.setText(editedProfile.networkData.wifi.ssid);
        }
        networkGrid.add((Node)ssidLabel, 1, 0);
        GridPane.setHalignment((Node)ssidLabel, (HPos)HPos.RIGHT);
        networkGrid.add((Node)ssidText, 2, 0);
        Label pwLabel = new Label("PW");
        TextField pwText = new TextField("password");
        if (editedProfile.networkData.wifi != null) {
            pwText.setText(editedProfile.networkData.wifi.password);
        }
        networkGrid.add((Node)pwLabel, 1, 1);
        GridPane.setHalignment((Node)pwLabel, (HPos)HPos.RIGHT);
        networkGrid.add((Node)pwText, 2, 1);
        CheckBox ehternetCheckBox = new CheckBox("Ethernet: ");
        if (editedProfile.networkData != null && editedProfile.networkData.ethernet != null) {
            ehternetCheckBox.setSelected(editedProfile.networkData.ethernet.enabled);
        } else {
            ehternetCheckBox.setSelected(false);
        }
        networkGrid.add((Node)ehternetCheckBox, 0, 2);
        Label ipLabel = new Label("IP");
        TextField ipText = new TextField("IP");
        if (editedProfile.networkData.ethernet != null) {
            ipText.setText(editedProfile.networkData.ethernet.ipAddress.getHostAddress());
        }
        networkGrid.add((Node)ipLabel, 1, 2);
        GridPane.setHalignment((Node)ipLabel, (HPos)HPos.RIGHT);
        networkGrid.add((Node)ipText, 2, 2);
        Label gatewayLabel = new Label("Gateway");
        TextField gatewayText = new TextField("gateway");
        if (editedProfile.networkData.ethernet != null) {
            gatewayText.setText(editedProfile.networkData.ethernet.defaultGateway.getHostAddress());
        }
        networkGrid.add((Node)gatewayLabel, 1, 3);
        GridPane.setHalignment((Node)gatewayLabel, (HPos)HPos.RIGHT);
        networkGrid.add((Node)gatewayText, 2, 3);
        Label subnetLabel = new Label("Subnet");
        TextField subnetText = new TextField("Subnet");
        if (editedProfile.networkData.ethernet != null) {
            subnetText.setText(editedProfile.networkData.ethernet.netmask.getHostAddress());
        }
        networkGrid.add((Node)subnetLabel, 1, 4);
        GridPane.setHalignment((Node)subnetLabel, (HPos)HPos.RIGHT);
        networkGrid.add((Node)subnetText, 2, 4);
        Label primaryDnsLabel = new Label("Primary DNS Server");
        TextField primaryDnsText = new TextField("Primary DNS");
        if (primaryDnsText != null && editedProfile.networkData.ethernet != null) {
            primaryDnsText.setText(editedProfile.networkData.ethernet.primaryDnsServer.getHostAddress());
        }
        networkGrid.add((Node)primaryDnsLabel, 1, 5);
        GridPane.setHalignment((Node)primaryDnsLabel, (HPos)HPos.RIGHT);
        networkGrid.add((Node)primaryDnsText, 2, 5);
        VBox editProfileBox = new VBox(10.0, new Node[]{profileGrid});
        editProfileBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        VBox editImageBox = new VBox(10.0, new Node[]{imageGrid});
        editImageBox.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.GRAY, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
        editImageBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        VBox editNetworkBox = new VBox(10.0, new Node[]{networkGrid});
        editNetworkBox.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.GRAY, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
        editNetworkBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        mainGrid.add((Node)editProfileBox, 0, 0);
        mainGrid.add((Node)editImageBox, 0, 1);
        mainGrid.add((Node)editNetworkBox, 0, 2);
        VBox mainBox = new VBox(10.0, new Node[]{mainGrid});
        mainBox.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        DialogPane dialogPane = this.getDialogPane();
        dialogPane.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("application.css").toExternalForm());
        dialogPane.getStyleClass().add((Object)"editProfileDialog");
        dialogPane.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{this.cancelButton, this.okButton});
        this.getDialogPane().setContent((Node)mainBox);
        this.setResultConverter(button -> {
            if (button.getButtonData().isCancelButton()) {
                return FlashProfile.createEmpty();
            }
            try {
                if (editedProfile.networkData.ethernet != null) {
                    editedProfile.name = profileNameEdit.getText();
                    editedProfile.deviceType = FlashProfile.getDeviceTypeFromString((String)selectTargetCombo.getSelectionModel().getSelectedItem());
                    editedProfile.bootPath = bootImagePath.getText();
                    editedProfile.platformPath = platformImagePath.getText();
                    editedProfile.rpmPath = rpmPath.getText();
                    editedProfile.networkData.wifi.enabled = wifiCheckBox.isSelected();
                    editedProfile.networkData.wifi.ssid = ssidText.getText();
                    editedProfile.networkData.wifi.password = pwText.getText();
                    editedProfile.networkData.ethernet.enabled = ehternetCheckBox.isSelected();
                    editedProfile.networkData.ethernet.ipAddress = (Inet4Address)Inet4Address.getByName(ipText.getText());
                    editedProfile.networkData.ethernet.defaultGateway = (Inet4Address)Inet4Address.getByName(gatewayText.getText());
                    editedProfile.networkData.ethernet.netmask = (Inet4Address)Inet4Address.getByName(subnetText.getText());
                    editedProfile.networkData.ethernet.primaryDnsServer = (Inet4Address)Inet4Address.getByName(primaryDnsText.getText());
                }
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
            }
            if (!editedProfile.valid()) {
                System.out.println("Invalid profile after editing: can not return it back");
                return profile;
            }
            System.out.println("Returning new profile!!!");
            return editedProfile;
        });
    }
}

