/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager;

import java.util.List;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.SystemUtils;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.Reporter;
import org.tizen.iotsetupmanager.TargetDeviceInfo;
import org.tizen.iotsetupmanager.linux.FlashScriptBuilderRPi3Linux;
import org.tizen.iotsetupmanager.windows.FlashScriptBuilderRPi3Windows;

public abstract class FlashScriptBuilder {
    protected final FlashProfile flashProfile;
    protected final TargetDeviceInfo targetDevice;
    protected Reporter reporter;

    protected FlashScriptBuilder(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        this.flashProfile = flashProfile;
        this.targetDevice = targetDevice;
        this.reporter = reporter;
        if (flashProfile == null) {
            throw new IllegalArgumentException("Flash request is null");
        }
        if (targetDevice == null) {
            throw new IllegalArgumentException("Target device is null");
        }
    }

    public static FlashScriptBuilder construct(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        if (flashProfile == null) {
            throw new IllegalArgumentException("Flash request is null");
        }
        if (reporter == null) {
            throw new IllegalArgumentException("Reporter is null");
        }
        switch (flashProfile.deviceType) {
            case RPI3_HEADLESS: 
            case RPI3_HEADED: 
            case RPI4_HEADLESS: 
            case RPI4_HEADED: {
                return FlashScriptBuilder.getRPi3DefaultFlashScriptBuilder(flashProfile, targetDevice, reporter);
            }
            case NONE: {
                throw new UnsupportedOperationException("The device type NONE is not supported yet");
            }
            case UNKNOWN: {
                throw new UnsupportedOperationException("The device type UNKNOWN is not supported yet");
            }
        }
        throw new IllegalArgumentException("Unsupported device type");
    }

    private static FlashScriptBuilder getRPi3DefaultFlashScriptBuilder(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        if (SystemUtils.IS_OS_LINUX) {
            return new FlashScriptBuilderRPi3Linux(flashProfile, targetDevice, reporter);
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return new FlashScriptBuilderRPi3Windows(flashProfile, targetDevice, reporter);
        }
        throw new UnsupportedOperationException("Flash Script Builder for this case is not implemented");
    }

    public List<Callable<Boolean>> generate() {
        switch (this.flashProfile.flashType) {
            case FRESH_INSTALL: {
                return this.generateFreshFlash();
            }
        }
        throw new UnsupportedOperationException("The flash type is not recognized yet");
    }

    public abstract List<Callable<Boolean>> generateFreshFlash();
}

