/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager;

import java.io.Closeable;
import java.text.DecimalFormat;
import java.util.List;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.log4j.Logger;
import org.tizen.iotsetupmanager.DiskInfo;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.IDiskEventHandler;
import org.tizen.iotsetupmanager.IProgress;
import org.tizen.iotsetupmanager.IoTSetupWizard;
import org.tizen.iotsetupmanager.ProcessManagerLinux;
import org.tizen.iotsetupmanager.ResourceUtils;

public class FlashView
implements IProgress,
IDiskEventHandler {
    IoTSetupWizard wizard;
    List<DiskInfo> diskList;
    ComboBox<String> selectDriveCombo;
    Label selectedDriveSize;
    Label progressLabel;
    ProgressBar flashProgress;
    Button burnButton;
    static final Logger logger = Logger.getLogger(FlashView.class);

    public FlashView(IoTSetupWizard wizard) {
        this.wizard = wizard;
    }

    public Node construct(Scene scene, int padding) {
        Label selectDriveLabel = new Label("Select Drive");
        this.selectDriveCombo = new ComboBox();
        this.selectedDriveSize = new Label("");
        GridPane flashControl = new GridPane();
        flashControl.setHgap(10.0);
        flashControl.setVgap(10.0);
        this.burnButton = new Button("Burn");
        this.burnButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                logger.debug((Object)"Burn pressed");
                if (FlashView.this.checkFlashParametersReady()) {
                    DiskInfo selectedDiskInfo = null;
                    String selectedDiskPath = (String)FlashView.this.selectDriveCombo.getSelectionModel().getSelectedItem();
                    for (DiskInfo di : FlashView.this.diskList) {
                        if (di.getPath().compareTo(selectedDiskPath) != 0) continue;
                        selectedDiskInfo = di;
                        break;
                    }
                    FlashView.this.wizard.flashStart(selectedDiskInfo);
                }
            }
        });
        this.burnButton.setDisable(true);
        this.flashProgress = new ProgressBar(0.0);
        this.flashProgress.prefWidthProperty().set(200.0);
        this.progressLabel = new Label("");
        flashControl.add((Node)selectDriveLabel, 0, 0);
        flashControl.add(this.selectDriveCombo, 1, 0);
        flashControl.add((Node)this.selectedDriveSize, 2, 0);
        flashControl.add((Node)this.flashProgress, 3, 0);
        flashControl.add((Node)this.burnButton, 4, 0);
        flashControl.add((Node)this.progressLabel, 0, 1, 5, 1);
        GridPane.setHalignment((Node)selectDriveLabel, (HPos)HPos.RIGHT);
        GridPane.setHalignment((Node)this.progressLabel, (HPos)HPos.RIGHT);
        VBox flashSDBox = new VBox((double)padding, new Node[]{flashControl});
        flashSDBox.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.GRAY, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
        flashSDBox.setPadding(new Insets((double)padding, (double)padding, (double)padding, (double)padding));
        if (this.wizard != null && this.wizard.getDiskManager() != null) {
            System.out.println("Subsckribe Disk Event on Flash View");
            this.wizard.getDiskManager().subscribeDiskEvent(this);
            this.setDiskInfo();
        }
        return flashSDBox;
    }

    @Override
    public void diskEventDetected() {
        Platform.runLater(() -> this.setDiskInfo());
    }

    private void setDiskInfo() {
        block22: {
            try (BurnButtonUpdater bbu = new BurnButtonUpdater();){
                if (this.wizard == null || this.wizard.getDiskManager() == null) {
                    return;
                }
                this.selectDriveCombo.getItems().clear();
                this.selectedDriveSize.setText("");
                this.progressLabel.setText("SD card is not found");
                this.diskList = this.wizard.getDiskManager().getRemovableDisks();
                if (this.diskList == null) {
                    return;
                }
                for (DiskInfo di : this.diskList) {
                    if (di == null || StringUtils.isBlank((CharSequence)di.getPath())) continue;
                    this.selectDriveCombo.getItems().add((Object)di.getPath());
                }
                this.selectDriveCombo.getSelectionModel().selectFirst();
                String selectedSDDrive = (String)this.selectDriveCombo.getSelectionModel().getSelectedItem();
                if (StringUtils.isBlank((CharSequence)selectedSDDrive)) break block22;
                for (DiskInfo di : this.diskList) {
                    if (di == null || StringUtils.isBlank((CharSequence)di.getPath()) || !selectedSDDrive.equals(di.getPath())) continue;
                    DecimalFormat formatter = new DecimalFormat("#0.0");
                    String sizeGB = formatter.format(di.getSize());
                    this.selectedDriveSize.setText(sizeGB + " GB");
                    this.progressLabel.setText("SD card is available");
                    break;
                }
            }
        }
    }

    private void updateBurnButtonEnabled() {
        if (StringUtils.isBlank((CharSequence)((CharSequence)this.selectDriveCombo.getSelectionModel().getSelectedItem()))) {
            this.burnButton.setDisable(true);
        } else {
            this.burnButton.setDisable(false);
        }
    }

    @Override
    public void update(int completed, int total) {
        if (this.flashProgress != null) {
            Platform.runLater(() -> this.flashProgress.setProgress((double)completed / (double)total));
        }
    }

    @Override
    public void updateStatus(String status) {
        if (this.progressLabel != null) {
            Platform.runLater(() -> this.progressLabel.setText(status));
        }
    }

    private boolean checkFlashParametersReady() {
        if (this.wizard == null) {
            return false;
        }
        String error = "";
        if (this.wizard.flasher.isRunning()) {
            error = "Flashing is already in progress\nWait for completion";
        } else {
            if (this.wizard.getActiveProfile() == null || !this.wizard.getActiveProfile().valid()) {
                error = "Select flashing profile\n";
            }
            if (StringUtils.isBlank((CharSequence)((CharSequence)this.selectDriveCombo.getSelectionModel().getSelectedItem()))) {
                error = error + "Select SD card to flash\n";
            }
            FlashProfile profile = this.wizard.getActiveProfile();
            if (!(profile.flashType != FlashProfile.FlashType.KERNEL_ONLY && profile.flashType != FlashProfile.FlashType.FRESH_INSTALL || profile.bootImageFileExists())) {
                error = error + "Boot image file is not found\n";
            }
            if (!(profile.flashType != FlashProfile.FlashType.PLATFORM_ONLY && profile.flashType != FlashProfile.FlashType.FRESH_INSTALL || profile.platformImageFileExists())) {
                error = error + "Platform image file is not found\n";
            }
            if (!StringUtils.isBlank((CharSequence)profile.rpmPath) && !profile.rpmDirExists()) {
                error = error + "RPM directory does not exist. Please set RPM path as empty to skip copying of RPMs\n";
            }
            DiskInfo selectedDiskInfo = null;
            String selectedDiskPath = (String)this.selectDriveCombo.getSelectionModel().getSelectedItem();
            for (DiskInfo di : this.diskList) {
                if (di.getPath().compareTo(selectedDiskPath) != 0) continue;
                selectedDiskInfo = di;
                break;
            }
            if (selectedDiskInfo != null && (double)selectedDiskInfo.getSize().floatValue() < 4.0) {
                error = error + "Please use an SD Card larger than 4GB";
            }
        }
        if (StringUtils.isBlank((CharSequence)error)) {
            return true;
        }
        Alert alert = new Alert(Alert.AlertType.ERROR);
        alert.setTitle("Error");
        alert.setHeaderText("Can't start flashing!.");
        alert.setContentText(error);
        alert.showAndWait();
        return false;
    }

    public void stop() {
        System.out.println("Stopping the Flsh view");
        if (this.wizard == null) {
            return;
        }
        if (this.wizard.getDiskManager() != null) {
            this.wizard.getDiskManager().unsubscribeDiskEvent();
            this.wizard.flashStop(true);
            if (SystemUtils.IS_OS_LINUX && ResourceUtils.automount) {
                ProcessManagerLinux pm = new ProcessManagerLinux();
                System.out.println("Resetting value of automount-open to true");
                pm.runCommand(false, "gsettings", "set", "org.gnome.desktop.media-handling", "automount-open", "true");
            }
        }
    }

    class BurnButtonUpdater
    implements Closeable {
        BurnButtonUpdater() {
        }

        @Override
        public void close() {
            FlashView.this.updateBurnButtonEnabled();
        }
    }
}

