/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.IDiskManager;
import org.tizen.iotsetupmanager.IFlasher;
import org.tizen.iotsetupmanager.IProgress;
import org.tizen.iotsetupmanager.SDFlasher;
import org.tizen.iotsetupmanager.TargetDeviceInfo;
import org.tizen.iotsetupmanager.linux.DiskManagerLinux;
import org.tizen.iotsetupmanager.windows.DiskManagerWindows;

public class IoTSetupWizard
implements IProgress {
    List<FlashProfile> profiles = new ArrayList<FlashProfile>();
    String activeProfileName = "";
    IFlasher flasher;
    IDiskManager diskManager;
    IProgress guiProgress;

    public IoTSetupWizard() {
        this.setFlasher(new SDFlasher());
        this.setDiskManager(this.createDefaultDiskManager());
    }

    public void dispose() {
        if (this.flasher != null) {
            this.flashStop(false);
        }
    }

    public void setFlasher(IFlasher fl) {
        this.flasher = fl;
        if (this.flasher != null) {
            this.flasher.setProgressCallback(this);
        }
    }

    public boolean isFlashing() {
        if (this.flasher != null) {
            return this.flasher.isRunning();
        }
        return false;
    }

    public void setGuiProgress(IProgress p) {
        this.guiProgress = p;
    }

    public void flashStart(TargetDeviceInfo targetDevice) {
        System.out.println("\n\n======================\nStart Flashing: target is " + targetDevice + "\n============\n\n");
        this.flasher.start(this.getActiveProfile(), targetDevice);
    }

    public void flashStop(boolean force) {
        if (this.flasher == null) {
            throw new IllegalArgumentException("Flasher is null");
        }
        System.out.println("Stopping the flasher");
        try {
            this.flasher.stop(force);
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
    }

    public List<FlashProfile> getProfiles() {
        return this.profiles;
    }

    public void setProfiles(List<FlashProfile> profiles) {
        this.profiles = profiles;
    }

    public static String getHomeDirectory() {
        String home = "";
        if (StringUtils.isBlank((CharSequence)home)) {
            home = System.getProperty("user.home");
        }
        if (SystemUtils.IS_OS_LINUX) {
            return home + "/iot-setup-manager/";
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return home + "\\iot-setup-manager\\";
        }
        return home + "/iot-setup-manager/";
    }

    public static String getFlashingProfileDir() {
        if (SystemUtils.IS_OS_LINUX) {
            return IoTSetupWizard.getHomeDirectory() + "flashing_profiles/";
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return IoTSetupWizard.getHomeDirectory() + "flashing_profiles\\";
        }
        return IoTSetupWizard.getHomeDirectory() + "flashing_profiles/";
    }

    public static String getNetworkProfileDir() {
        if (SystemUtils.IS_OS_LINUX) {
            return IoTSetupWizard.getHomeDirectory() + "network_profiles/";
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return IoTSetupWizard.getHomeDirectory() + "network_profiles\\";
        }
        return IoTSetupWizard.getHomeDirectory() + "network_profiles/";
    }

    public void readProfiles() {
        try (EnsureProfileExists epe = new EnsureProfileExists();){
            this.profiles.clear();
            if (!Files.exists(Paths.get(IoTSetupWizard.getFlashingProfileDir(), new String[0]), new LinkOption[0])) {
                IoTSetupWizard.ensureCreateDirectory(IoTSetupWizard.getFlashingProfileDir());
                IoTSetupWizard.ensureCreateDirectory(IoTSetupWizard.getNetworkProfileDir());
                return;
            }
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(IoTSetupWizard.getFlashingProfileDir(), new String[0]), "*.json");){
                for (Path entry : stream) {
                    String profilePath = entry.toString();
                    System.out.println("Reading profile from file: " + profilePath);
                    FlashProfile profile = FlashProfile.read(profilePath);
                    if (profile == null || !profile.valid()) continue;
                    this.profiles.add(profile);
                }
            }
            catch (DirectoryIteratorException ex) {
                ex.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void ensureCreateDirectory(String dirPath) {
        Path pathToFlashingProfiles = Paths.get(dirPath, new String[0]);
        if (!Files.exists(pathToFlashingProfiles, new LinkOption[0])) {
            try {
                System.out.println("Creating directory: " + dirPath);
                Files.createDirectories(pathToFlashingProfiles, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void writeProfiles() {
        IoTSetupWizard.ensureCreateDirectory(IoTSetupWizard.getFlashingProfileDir());
        IoTSetupWizard.ensureCreateDirectory(IoTSetupWizard.getNetworkProfileDir());
        this.profiles.forEach(profile -> {
            System.out.println("Writing profile: " + profile.name + " [" + IoTSetupWizard.getFlashingProfileDir() + profile.name + ".config.json]");
            profile.write(IoTSetupWizard.getFlashingProfileDir() + profile.name + ".config.json");
            profile.networkData.write(IoTSetupWizard.getNetworkProfileDir() + profile.name + ".config.json");
        });
    }

    public void setActiveProfileName(String profileName) {
        this.activeProfileName = profileName;
    }

    public String getActiveProfileName() {
        return this.activeProfileName;
    }

    public FlashProfile getActiveProfile() {
        for (FlashProfile profile : this.profiles) {
            if (!profile.name.equals(this.activeProfileName)) continue;
            return profile;
        }
        System.out.println("BAD Error! We shouldn't get there");
        return FlashProfile.createDefault(FlashProfile.DeviceTYPE.RPI3_HEADLESS);
    }

    private void replaceOrAdd(FlashProfile input) {
        System.out.println("Replace or add called");
        if (this.profiles == null || input == null) {
            return;
        }
        for (int i = 0; i < this.profiles.size(); ++i) {
            FlashProfile profile = this.profiles.get(i);
            if (profile == null || profile.name == null || input.name == null || profile.name.compareTo(input.name) != 0) continue;
            System.out.println("Replacing profile: " + input.name);
            this.profiles.set(i, input);
            return;
        }
        System.out.println("Adding new profile with name: " + input.name);
        this.profiles.add(input);
    }

    public void addActiveProfile(FlashProfile profile) {
        this.replaceOrAdd(profile);
        this.setActiveProfileName(profile.name);
        System.out.println("Writing profile: " + profile.name + " [" + IoTSetupWizard.getFlashingProfileDir() + profile.name + ".config.json]");
        profile.write(IoTSetupWizard.getFlashingProfileDir() + profile.name + ".config.json");
        profile.networkData.write(IoTSetupWizard.getNetworkProfileDir() + profile.name + ".config.json");
    }

    public void updateActiveProfile(FlashProfile profile) {
        if (!profile.valid()) {
            return;
        }
        ListIterator<FlashProfile> iterator = this.profiles.listIterator();
        while (iterator.hasNext()) {
            FlashProfile next = iterator.next();
            if (!next.name.equals(this.activeProfileName)) continue;
            iterator.set(profile);
            if (!this.activeProfileName.equals(profile.name)) {
                File fileFlashingProfile = new File(IoTSetupWizard.getFlashingProfileDir() + this.activeProfileName + ".config.json");
                if (fileFlashingProfile.delete()) {
                    System.out.println(fileFlashingProfile.getName() + " is deleted!");
                } else {
                    System.out.println("Delete operation is failed.");
                }
                File fileNetworkProfile = new File(IoTSetupWizard.getNetworkProfileDir() + this.activeProfileName + ".config.json");
                if (fileNetworkProfile.delete()) {
                    System.out.println(fileNetworkProfile.getName() + " is deleted!");
                } else {
                    System.out.println("Delete operation is failed.");
                }
            }
            System.out.println("Writing profile: " + profile.name + " [" + IoTSetupWizard.getFlashingProfileDir() + profile.name + ".config.json]");
            profile.write(IoTSetupWizard.getFlashingProfileDir() + profile.name + ".config.json");
            profile.networkData.write(IoTSetupWizard.getNetworkProfileDir() + profile.name + ".config.json");
            this.setActiveProfileName(profile.name);
            return;
        }
    }

    public void removeProfile(FlashProfile profile) {
        System.out.println("Delete profile: " + profile.name + " [" + IoTSetupWizard.getFlashingProfileDir() + profile.name + ".config.json]");
        profile.delete(IoTSetupWizard.getFlashingProfileDir() + profile.name + ".config.json");
        profile.networkData.delete(IoTSetupWizard.getNetworkProfileDir() + profile.name + ".config.json");
        this.readProfiles();
    }

    @Override
    public void update(int completed, int total) {
        System.out.println("PROGRESS: " + completed + ", total: " + total);
        if (this.guiProgress != null) {
            this.guiProgress.update(completed, total);
        }
    }

    @Override
    public void updateStatus(String status) {
        System.out.println("PROGRESS: " + status);
        if (this.guiProgress != null) {
            this.guiProgress.updateStatus(status);
        }
    }

    public void setDiskManager(IDiskManager dm) {
        this.diskManager = dm;
    }

    public IDiskManager getDiskManager() {
        return this.diskManager;
    }

    private IDiskManager createDefaultDiskManager() {
        if (SystemUtils.IS_OS_LINUX) {
            return new DiskManagerLinux();
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return new DiskManagerWindows();
        }
        throw new UnsupportedOperationException("Disk Manager for this case is not implemented");
    }

    class EnsureProfileExists
    implements Closeable {
        EnsureProfileExists() {
        }

        @Override
        public void close() {
            if (IoTSetupWizard.this.profiles.isEmpty()) {
                IoTSetupWizard.this.profiles.add(FlashProfile.createDefault(FlashProfile.DeviceTYPE.RPI3_HEADLESS));
                IoTSetupWizard.this.writeProfiles();
            }
        }
    }
}

