/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager;

import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Inet4Address;
import org.tizen.iotsetupmanager.EthernetInfo;
import org.tizen.iotsetupmanager.WifiInfo;

public class NetworkInfo {
    public String version;
    public WifiInfo wifi = new WifiInfo();
    public EthernetInfo ethernet = new EthernetInfo();
    public Inet4Address httpProxyHost;
    public int httpProxyPort;

    public NetworkInfo clone() {
        NetworkInfo cloneInfo = new NetworkInfo();
        cloneInfo.version = this.version;
        cloneInfo.wifi = this.wifi.clone();
        cloneInfo.ethernet = this.ethernet.clone();
        cloneInfo.httpProxyHost = this.httpProxyHost;
        cloneInfo.httpProxyPort = this.httpProxyPort;
        return cloneInfo;
    }

    public void write(String path) {
        Gson gson = new Gson();
        try (FileWriter writer = new FileWriter(path);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String path) {
        FileOutputStream fs = null;
        BufferedWriter writer = null;
        try {
            fs = new FileOutputStream(path);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fs, "UTF-8"));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {
                System.err.println("delete >>> error during closing !!!");
                e.printStackTrace();
            }
        }
        File file = new File(path);
        if (file.exists()) {
            System.out.println("Delete file :" + path);
            if (file.delete()) {
                System.out.println("success to delete file..");
            } else {
                System.err.println("fail to delete file" + path);
            }
        }
    }

    public static NetworkInfo read(String path) {
        Gson gson = new Gson();
        NetworkInfo info = null;
        try (FileReader reader = new FileReader(path);){
            info = gson.fromJson((Reader)reader, NetworkInfo.class);
            System.out.println(info);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return info;
    }
}

