/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.linux.tasks;

import java.io.File;
import java.util.Collection;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.tizen.iotsetupmanager.AbstractFlashingTask;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.ProcessManagerLinux;
import org.tizen.iotsetupmanager.Reporter;
import org.tizen.iotsetupmanager.TargetDeviceInfo;

public class TaskInstallRPMCommon
extends AbstractFlashingTask {
    public TaskInstallRPMCommon(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        super(flashProfile, targetDevice, reporter);
    }

    @Override
    public Boolean call() throws Exception {
        this.reporter.startStep("Installing RPM...");
        if (StringUtils.isEmpty((CharSequence)this.flashProfile.rpmPath)) {
            this.reporter.finishStep("RPM dir empty. Skipping..");
            return true;
        }
        if (!this.flashProfile.rpmDirExists()) {
            this.reporter.finishStep("RPM dir does not exist. Skipping..");
            return true;
        }
        ProcessManagerLinux pm = new ProcessManagerLinux();
        pm.runCommandElevated((Boolean)false, "mkdir", "ism/rootfs");
        pm.runCommandElevated((Boolean)false, "mount", "-n", "ism/images/rootfs.img", "ism/rootfs");
        pm.runCommandElevated((Boolean)false, "cd", "ism/rootfs/");
        Collection files = FileUtils.listFiles(new File(this.flashProfile.rpmPath), new String[]{"rpm"}, true);
        String version = pm.runCommandElevated((Boolean)true, "cpio --version | head -1 | awk '{print $4}'");
        float version_float = Float.parseFloat(version);
        if ((double)version_float <= 2.12) {
            for (File file : files) {
                System.out.println(String.format("Extracting file: [%s]", file.getAbsolutePath()));
                pm.runCommandElevated((Boolean)false, new File("ism/rootfs/"), "sh", "-c", "\"" + String.join((CharSequence)" ", "rpm2cpio", "\\\"" + file.getAbsolutePath() + "\\\"", "|", "cpio", "-idmv", "--extract-over-symlinks") + "\"");
            }
        } else {
            for (File file : files) {
                System.out.println(String.format("Extracting file: [%s]", file.getAbsolutePath()));
                pm.runCommandElevated((Boolean)false, new File("ism/rootfs/"), "sh", "-c", "\"" + String.join((CharSequence)" ", "rpm2cpio", "\\\"" + file.getAbsolutePath() + "\\\"", "|", "cpio", "-idmv") + "\"");
            }
        }
        pm.runCommandElevated((Boolean)false, "sync");
        pm.runCommandElevated((Boolean)false, "sync");
        pm.runCommandElevated((Boolean)false, "sleep", "0.5");
        pm.runCommandElevated((Boolean)false, "umount", "-fd", "ism/rootfs");
        pm.runCommandElevated((Boolean)false, "rm", "-rf", "ism/rootfs");
        this.reporter.finishStep("RPM installed");
        return true;
    }
}

