/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.windows;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.FlashScriptBuilder;
import org.tizen.iotsetupmanager.Reporter;
import org.tizen.iotsetupmanager.TargetDeviceInfo;
import org.tizen.iotsetupmanager.windows.tasks.TaskCopyWifiConfigCommon;
import org.tizen.iotsetupmanager.windows.tasks.TaskExtractImageFilesCommon;
import org.tizen.iotsetupmanager.windows.tasks.TaskFinalizeFlashingCommon;
import org.tizen.iotsetupmanager.windows.tasks.TaskFuseImagesCommon;
import org.tizen.iotsetupmanager.windows.tasks.TaskInitializeEnvironmentWindows;
import org.tizen.iotsetupmanager.windows.tasks.TaskInstallRPMCommon;
import org.tizen.iotsetupmanager.windows.tasks.TaskMakePartitionsRPi3;

public class FlashScriptBuilderRPi3Windows
extends FlashScriptBuilder {
    public FlashScriptBuilderRPi3Windows(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        super(flashProfile, targetDevice, reporter);
    }

    @Override
    public List<Callable<Boolean>> generateFreshFlash() {
        if (this.flashProfile.flashType != FlashProfile.FlashType.FRESH_INSTALL) {
            throw new IllegalArgumentException("Flash request is of wrong type");
        }
        if (this.flashProfile.deviceType != FlashProfile.DeviceTYPE.RPI3_HEADLESS && this.flashProfile.deviceType != FlashProfile.DeviceTYPE.RPI3_HEADED && this.flashProfile.deviceType != FlashProfile.DeviceTYPE.RPI4_HEADLESS && this.flashProfile.deviceType != FlashProfile.DeviceTYPE.RPI4_HEADED) {
            throw new IllegalArgumentException("Device is of wrong type");
        }
        ArrayList<Callable<Boolean>> script = new ArrayList<Callable<Boolean>>();
        script.add(new TaskInitializeEnvironmentWindows(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskMakePartitionsRPi3(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskExtractImageFilesCommon(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskInstallRPMCommon(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskCopyWifiConfigCommon(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskFuseImagesCommon(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskFinalizeFlashingCommon(this.flashProfile, this.targetDevice, this.reporter));
        return script;
    }
}

