/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager;

import java.util.Optional;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.GridPane;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import org.apache.log4j.Logger;
import org.tizen.iotsetupmanager.FlashView;
import org.tizen.iotsetupmanager.IoTSetupWizard;
import org.tizen.iotsetupmanager.ProfileView;

public class Main
extends Application {
    private IoTSetupWizard wizard = new IoTSetupWizard();
    private ProfileView profileView = new ProfileView(this.wizard);
    private FlashView flashView = new FlashView(this.wizard);
    static final Logger logger = Logger.getLogger(Main.class);

    public void start(Stage primaryStage) {
        try {
            String title = "IoT Setup Manager v1.0.5";
            int padding = 10;
            primaryStage.setTitle("IoT Setup Manager v1.0.5");
            GridPane mainGrid = new GridPane();
            mainGrid.setPadding(new Insets(10.0, 10.0, 10.0, 10.0));
            mainGrid.setVgap(10.0);
            mainGrid.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
            Scene scene = new Scene((Parent)mainGrid, 550.0, 300.0);
            scene.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("application.css").toExternalForm());
            Node profileViewNode = this.profileView.construct(scene, 10);
            Node flashViewNode = this.flashView.construct(scene, 10);
            this.wizard.setGuiProgress(this.flashView);
            mainGrid.add(profileViewNode, 0, 1);
            mainGrid.add(flashViewNode, 0, 2);
            Platform.setImplicitExit((boolean)false);
            primaryStage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

                public void handle(WindowEvent event) {
                    if (Main.this.wizard.isFlashing()) {
                        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                        alert.setTitle("IoT Setup Manager v1.0.5");
                        alert.setHeaderText("The burning is in progress.");
                        alert.setContentText("Do you want to close the Wizard any way?");
                        ButtonType buttonForceStop = new ButtonType("Force stop");
                        ButtonType buttonCancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
                        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonForceStop, buttonCancel});
                        Optional result = alert.showAndWait();
                        ButtonType modalResult = (ButtonType)result.get();
                        if (modalResult == buttonCancel) {
                            System.out.println("The user denied termination of the Wizard");
                            event.consume();
                        } else {
                            System.out.println("The user required immediate termination of the Wizard");
                            Platform.exit();
                        }
                    } else {
                        Platform.exit();
                    }
                }
            });
            primaryStage.setResizable(false);
            primaryStage.setScene(scene);
            primaryStage.show();
            this.initWizard();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initWizard() {
        this.wizard.readProfiles();
        this.profileView.updateData();
    }

    public void stop() {
        if (this.flashView != null) {
            this.flashView.stop();
        }
    }

    public static void main(String[] args) {
        logger.debug((Object)"Starting application");
        Main.launch((String[])args);
    }
}

