/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.apache.commons.lang3.StringUtils;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.FlashProfileEditDialog;
import org.tizen.iotsetupmanager.IoTSetupWizard;

public class ProfileView {
    IoTSetupWizard wizard;
    ComboBox<String> selectProfileCombo;
    Label summaryTargetLabel;
    Label summaryCreatedLabel;
    Label summaryBootLabel;
    Label summaryPlatformLabel;
    Label summaryHWDriversLabel;
    Label summaryConfigFileLabel;
    Label summaryWorkingStorageLabel;

    public ProfileView(IoTSetupWizard w) {
        this.wizard = w;
    }

    public Node construct(Scene scene, int padding) {
        GridPane profileGrid = new GridPane();
        profileGrid.setHgap(10.0);
        profileGrid.setVgap(10.0);
        Button createProfileButton = new Button("Create");
        createProfileButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                FlashProfileEditDialog dialog = new FlashProfileEditDialog(FlashProfile.createDefault(FlashProfile.DeviceTYPE.RPI3_HEADLESS));
                dialog.showAndWait().ifPresent(result -> {
                    if (result.valid()) {
                        ProfileView.this.wizard.addActiveProfile((FlashProfile)result);
                        ProfileView.this.updateData();
                    }
                });
            }
        });
        Label selectProfileLabel = new Label("Select burning profile");
        this.selectProfileCombo = new ComboBox();
        this.selectProfileCombo.valueProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (ProfileView.this.wizard != null && !StringUtils.isBlank((CharSequence)newValue)) {
                    ProfileView.this.wizard.setActiveProfileName(newValue);
                    ProfileView.this.updateProfileSummary();
                }
            }
        });
        Button editProfileButton = new Button("Edit");
        editProfileButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                FlashProfileEditDialog dialog = new FlashProfileEditDialog(ProfileView.this.wizard.getActiveProfile());
                dialog.showAndWait().ifPresent(result -> {
                    if (result != null && result.valid()) {
                        ProfileView.this.wizard.updateActiveProfile((FlashProfile)result);
                        ProfileView.this.updateData();
                    }
                });
            }
        });
        Button deleteProfileButton = new Button("Delete");
        deleteProfileButton.prefWidthProperty().set(60.0);
        deleteProfileButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent e) {
                ProfileView.this.removeProfile(ProfileView.this.wizard.getActiveProfile());
            }
        });
        Label burningInfoLabel = new Label("Burning info:");
        this.summaryTargetLabel = new Label("");
        this.summaryCreatedLabel = new Label("");
        this.summaryBootLabel = new Label("");
        this.summaryPlatformLabel = new Label("");
        this.summaryHWDriversLabel = new Label("");
        this.summaryConfigFileLabel = new Label("");
        this.summaryWorkingStorageLabel = new Label("");
        VBox burningInfoBox = new VBox(new Node[]{burningInfoLabel, this.summaryTargetLabel, this.summaryCreatedLabel, this.summaryBootLabel, this.summaryPlatformLabel, this.summaryHWDriversLabel, this.summaryConfigFileLabel, this.summaryWorkingStorageLabel});
        profileGrid.add((Node)selectProfileLabel, 0, 0);
        profileGrid.add(this.selectProfileCombo, 1, 0);
        profileGrid.add((Node)createProfileButton, 2, 0);
        profileGrid.add((Node)editProfileButton, 3, 0);
        profileGrid.add((Node)deleteProfileButton, 5, 0);
        profileGrid.add((Node)burningInfoBox, 0, 1, 4, 1);
        GridPane.setHalignment((Node)selectProfileLabel, (HPos)HPos.RIGHT);
        VBox profileBox = new VBox((double)padding, new Node[]{profileGrid});
        profileBox.setBorder(new Border(new BorderStroke[]{new BorderStroke((Paint)Color.GRAY, BorderStrokeStyle.SOLID, CornerRadii.EMPTY, BorderWidths.DEFAULT)}));
        profileBox.setPadding(new Insets((double)padding, (double)padding, (double)padding, (double)padding));
        profileBox.prefWidthProperty().bind((ObservableValue)scene.widthProperty());
        return profileBox;
    }

    public void removeProfile(FlashProfile profile) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        alert.setTitle("Remove profile");
        alert.setHeaderText(profile.name + " delete ?");
        alert.setContentText("Do you want to remove profile?");
        ButtonType buttonConfirm = new ButtonType("Confirm");
        ButtonType buttonCancel = new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE);
        alert.getButtonTypes().setAll((Object[])new ButtonType[]{buttonConfirm, buttonCancel});
        Optional result = alert.showAndWait();
        ButtonType modalResult = (ButtonType)result.get();
        if (modalResult == buttonCancel) {
            System.out.println("The user denied to delete profile");
        } else {
            System.out.println("The user required deletion of profile");
            this.wizard.removeProfile(this.wizard.getActiveProfile());
            this.updateData();
            this.selectProfileCombo.getSelectionModel().selectFirst();
        }
    }

    public void resetData() {
        this.selectProfileCombo.getItems().clear();
        this.resetProfileSummary();
    }

    public void updateData() {
        this.resetData();
        if (this.wizard == null) {
            return;
        }
        this.wizard.getProfiles().forEach(profile -> this.selectProfileCombo.getItems().add((Object)profile.name));
        if (StringUtils.isBlank((CharSequence)this.wizard.getActiveProfileName())) {
            this.selectProfileCombo.getSelectionModel().selectFirst();
        } else {
            this.selectProfileCombo.getSelectionModel().select((Object)this.wizard.getActiveProfileName());
        }
        this.updateProfileSummary();
    }

    public void resetProfileSummary() {
        this.summaryTargetLabel.setText("Target: ...");
        this.summaryCreatedLabel.setText("Profile created: ...");
        this.summaryBootLabel.setText("Boot image: ...");
        this.summaryPlatformLabel.setText("Platform image: ...");
        this.summaryHWDriversLabel.setText("RPM bundles: ...");
        this.summaryConfigFileLabel.setText("Network configuration: ...");
        this.summaryWorkingStorageLabel.setText("Working storage: ...");
    }

    public void updateProfileSummary() {
        if (this.wizard == null) {
            return;
        }
        FlashProfile profile = this.wizard.getActiveProfile();
        if (profile == null) {
            return;
        }
        this.summaryTargetLabel.setText("Target: " + FlashProfile.getReadableDeviceType(profile.deviceType));
        String created = "...";
        try {
            Path file;
            if (!StringUtils.isBlank((CharSequence)profile.name) && Files.exists(file = Paths.get(IoTSetupWizard.getFlashingProfileDir() + profile.name + ".config.json", new String[0]), new LinkOption[0])) {
                BasicFileAttributes attr = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
                Date creationDate = new Date(attr.creationTime().to(TimeUnit.MILLISECONDS));
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss MMM. dd, yyyy");
                created = simpleDateFormat.format(creationDate);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.summaryCreatedLabel.setText("Created: " + created);
        Path bootPath = Paths.get(profile.bootPath, new String[0]);
        String bootFile = "";
        if (bootPath.getFileName() != null) {
            bootFile = bootPath.getFileName().toString();
        }
        this.summaryBootLabel.setText("Boot image: " + bootFile);
        Path platformPath = Paths.get(profile.platformPath, new String[0]);
        String platformFile = "";
        if (platformPath.getFileName() != null) {
            platformFile = platformPath.getFileName().toString();
        }
        this.summaryPlatformLabel.setText("Platform image: " + platformFile);
        this.summaryHWDriversLabel.setText("RPM bundles: " + profile.rpmPath);
        if (profile.networkData != null && profile.networkData.wifi != null) {
            String wifiInfo = "Wifi: ssid = " + profile.networkData.wifi.ssid + ", pw = " + profile.networkData.wifi.password;
            String etherInfo = "Ethernet: IP = " + profile.networkData.ethernet.ipAddress.getHostAddress() + ", NetMask = " + profile.networkData.ethernet.netmask.getHostAddress() + ", Gateway = " + profile.networkData.ethernet.defaultGateway.getHostAddress() + ", DNS = " + profile.networkData.ethernet.primaryDnsServer.getHostAddress();
            String combined = "";
            combined = profile.networkData.wifi.enabled != false ? combined + wifiInfo + "\n" : (profile.networkData.ethernet.enabled ? combined + etherInfo : "<None>");
            this.summaryConfigFileLabel.setText("Network configuration: " + combined);
        } else {
            this.summaryConfigFileLabel.setText("Network configuration: ...");
        }
        switch (profile.deviceType) {
            case ARTIK530_HEADED: 
            case ARTIK530_HEADLESS: 
            case RPI3_HEADLESS: 
            case RPI3_HEADED: 
            case RPI4_HEADLESS: 
            case RPI4_HEADED: {
                this.summaryWorkingStorageLabel.setText("Working storage: SD");
                break;
            }
            case ARTIK530_HEADED_INSTALLABLE: 
            case ARTIK530_HEADLESS_INSTALLABLE: {
                this.summaryWorkingStorageLabel.setText("Working storage: eMMC");
                break;
            }
            case NONE: 
            case UNKNOWN: {
                this.summaryWorkingStorageLabel.setText("Working storage: ...");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported device type");
            }
        }
    }
}

