/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.linux;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.FlashScriptBuilder;
import org.tizen.iotsetupmanager.Reporter;
import org.tizen.iotsetupmanager.TargetDeviceInfo;
import org.tizen.iotsetupmanager.linux.tasks.TaskCleanEnvironmentLinux;
import org.tizen.iotsetupmanager.linux.tasks.TaskCopyWifiConfigCommon;
import org.tizen.iotsetupmanager.linux.tasks.TaskExtractBootImageRPi3;
import org.tizen.iotsetupmanager.linux.tasks.TaskExtractPlatformImageRPi3;
import org.tizen.iotsetupmanager.linux.tasks.TaskFormatSDRPi3;
import org.tizen.iotsetupmanager.linux.tasks.TaskFuseImagesRPi3Linux;
import org.tizen.iotsetupmanager.linux.tasks.TaskInstallRPMCommon;
import org.tizen.iotsetupmanager.linux.tasks.TaskPrepareScriptRPi3;

public class FlashScriptBuilderRPi3Linux
extends FlashScriptBuilder {
    public FlashScriptBuilderRPi3Linux(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        super(flashProfile, targetDevice, reporter);
    }

    @Override
    public List<Callable<Boolean>> generateFreshFlash() {
        if (this.flashProfile.flashType != FlashProfile.FlashType.FRESH_INSTALL) {
            throw new IllegalArgumentException("Flash request is of wrong type");
        }
        if (this.flashProfile.deviceType != FlashProfile.DeviceTYPE.RPI3_HEADLESS && this.flashProfile.deviceType != FlashProfile.DeviceTYPE.RPI4_HEADLESS && this.flashProfile.deviceType != FlashProfile.DeviceTYPE.RPI3_HEADED && this.flashProfile.deviceType != FlashProfile.DeviceTYPE.RPI4_HEADED) {
            throw new IllegalArgumentException("Device is of wrong type");
        }
        ArrayList<Callable<Boolean>> script = new ArrayList<Callable<Boolean>>();
        script.add(new TaskPrepareScriptRPi3(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskFormatSDRPi3(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskExtractBootImageRPi3(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskExtractPlatformImageRPi3(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskInstallRPMCommon(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskCopyWifiConfigCommon(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskFuseImagesRPi3Linux(this.flashProfile, this.targetDevice, this.reporter));
        script.add(new TaskCleanEnvironmentLinux(this.flashProfile, this.targetDevice, this.reporter));
        return script;
    }
}

