/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.linux;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.tizen.iotsetupmanager.INetworkExtractor;
import org.tizen.iotsetupmanager.PasswordCancelledException;
import org.tizen.iotsetupmanager.ProcessManagerLinux;
import org.tizen.iotsetupmanager.WifiInfo;

public class NetworkExtractorLinux
implements INetworkExtractor {
    private static String wirelessType = "802-11-wireless";
    private static String networkConfigDirectory = "/etc/NetworkManager/system-connections/";
    private static String[] command1 = new String[]{"nmcli", "-f", "name", "c", "list"};
    private static String[] command2 = new String[]{"nmcli", "-f", "type", "c", "list"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<WifiInfo> getWirelessData() {
        ProcessManagerLinux processManager = new ProcessManagerLinux();
        String[] nameList = processManager.runCommand(true, command1).split("\n");
        String[] typeList = processManager.runCommand(true, command2).split("\n");
        List names = IntStream.range(0, nameList.length).filter(i -> typeList[i].trim().compareTo(wirelessType) == 0).mapToObj(i -> nameList[i].trim()).collect(Collectors.toList());
        System.out.println(names.size());
        ArrayList<WifiInfo> wifiList = null;
        for (String name : names) {
            String fileStr = "";
            try {
                fileStr = processManager.runCommandElevated((Boolean)true, "cat", networkConfigDirectory + "\"" + name + "\"");
            }
            catch (PasswordCancelledException e) {
                e.printStackTrace();
                return null;
            }
            BufferedReader reader = null;
            String ssid = null;
            String pwd = null;
            Boolean isOpen = true;
            try {
                reader = new BufferedReader(new StringReader(fileStr));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("ssid=")) {
                        ssid = line.trim().substring(5);
                        continue;
                    }
                    if (line.startsWith("psk=")) {
                        pwd = line.trim().substring(4);
                        continue;
                    }
                    if (line.startsWith("wep-key0=")) {
                        pwd = line.trim().substring(9);
                        continue;
                    }
                    if (!line.startsWith("security=")) continue;
                    isOpen = false;
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (ssid == null || pwd == null && !isOpen.booleanValue()) continue;
            if (wifiList == null) {
                wifiList = new ArrayList<WifiInfo>();
            }
            wifiList.add(new WifiInfo(ssid, pwd));
        }
        return wifiList;
    }
}

