/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.linux.tasks;

import java.io.File;
import org.tizen.iotsetupmanager.AbstractFlashingTask;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.IoTSetupWizard;
import org.tizen.iotsetupmanager.PasswordCancelledException;
import org.tizen.iotsetupmanager.ProcessManagerLinux;
import org.tizen.iotsetupmanager.Reporter;
import org.tizen.iotsetupmanager.TargetDeviceInfo;

public class TaskCopyWifiConfigCommon
extends AbstractFlashingTask {
    private static final String MOUNT_DIR = "ism/system-data/";
    private static final String ADAPTOR_DIR = "ism/system-data/etc/setup-adaptor/";
    private static final String CONFIG_FILE = "ism/system-data/etc/setup-adaptor/config.json";

    public TaskCopyWifiConfigCommon(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        super(flashProfile, targetDevice, reporter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean copyConfigFile() throws Exception {
        File configFile = new File(IoTSetupWizard.getNetworkProfileDir() + this.flashProfile.name + ".config.json");
        if (!configFile.exists()) {
            this.reporter.failedStep("Wireless config file not found");
            return false;
        }
        ProcessManagerLinux pm = new ProcessManagerLinux();
        pm.runCommandElevated((Boolean)false, "mkdir", MOUNT_DIR);
        pm.runCommandElevated((Boolean)false, "mount", "-n", "ism/images/system-data.img", MOUNT_DIR);
        pm.runCommandElevated((Boolean)false, "mkdir", "-p", ADAPTOR_DIR);
        try {
            pm.runCommandElevated((Boolean)false, "cp", "\"" + configFile.getPath() + "\"", CONFIG_FILE);
        }
        catch (PasswordCancelledException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                pm.runCommandElevated((Boolean)false, "sync");
                pm.runCommandElevated((Boolean)false, "sync");
                pm.runCommandElevated((Boolean)false, "sleep", "0.5");
                pm.runCommandElevated((Boolean)false, "umount", "-fd", MOUNT_DIR);
                pm.runCommandElevated((Boolean)false, "rm", "-rf", MOUNT_DIR);
                throw throwable;
            }
            pm.runCommandElevated((Boolean)false, "sync");
            pm.runCommandElevated((Boolean)false, "sync");
            pm.runCommandElevated((Boolean)false, "sleep", "0.5");
            pm.runCommandElevated((Boolean)false, "umount", "-fd", MOUNT_DIR);
            pm.runCommandElevated((Boolean)false, "rm", "-rf", MOUNT_DIR);
        }
        pm.runCommandElevated((Boolean)false, "sync");
        pm.runCommandElevated((Boolean)false, "sync");
        pm.runCommandElevated((Boolean)false, "sleep", "0.5");
        pm.runCommandElevated((Boolean)false, "umount", "-fd", MOUNT_DIR);
        pm.runCommandElevated((Boolean)false, "rm", "-rf", MOUNT_DIR);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean setRetrySetupAdaptorService() throws Exception {
        File configFile = new File(IoTSetupWizard.getNetworkProfileDir() + this.flashProfile.name + ".config.json");
        if (!configFile.exists()) {
            this.reporter.failedStep("Wireless config file not found");
            return false;
        }
        ProcessManagerLinux pm = new ProcessManagerLinux();
        String tempWorkingPath = "ism/tmp2/";
        pm.runCommandElevated((Boolean)false, "mkdir", tempWorkingPath);
        String serviceFileName = "setup-adaptor.service";
        String serviceFilePath = tempWorkingPath + serviceFileName;
        try {
            pm.runCommandElevated((Boolean)false, "cp", "ism/rpi3/" + serviceFileName, serviceFilePath);
        }
        catch (PasswordCancelledException e) {
            e.printStackTrace();
        }
        String rootfsDir = "ism/rootfs/";
        pm.runCommandElevated((Boolean)false, "mkdir", "ism/rootfs");
        pm.runCommandElevated((Boolean)true, "mount", "-n", "ism/images/rootfs.img", "ism/rootfs");
        String serviceDir = rootfsDir + "usr/lib/systemd/system/";
        String serviceFileDestinationPath = serviceDir + "setup-adaptor.service";
        pm.runCommandElevated((Boolean)false, "rm", serviceFileDestinationPath);
        try {
            pm.runCommandElevated((Boolean)false, "cp", "\"" + serviceFilePath + "\"", serviceFileDestinationPath);
        }
        catch (PasswordCancelledException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                pm.runCommandElevated((Boolean)false, "sync");
                pm.runCommandElevated((Boolean)false, "sync");
                pm.runCommandElevated((Boolean)false, "sleep", "0.5");
                pm.runCommandElevated((Boolean)false, "umount", "-fd", rootfsDir);
                pm.runCommandElevated((Boolean)false, "rm", "-rf", rootfsDir);
                throw throwable;
            }
            pm.runCommandElevated((Boolean)false, "sync");
            pm.runCommandElevated((Boolean)false, "sync");
            pm.runCommandElevated((Boolean)false, "sleep", "0.5");
            pm.runCommandElevated((Boolean)false, "umount", "-fd", rootfsDir);
            pm.runCommandElevated((Boolean)false, "rm", "-rf", rootfsDir);
        }
        pm.runCommandElevated((Boolean)false, "sync");
        pm.runCommandElevated((Boolean)false, "sync");
        pm.runCommandElevated((Boolean)false, "sleep", "0.5");
        pm.runCommandElevated((Boolean)false, "umount", "-fd", rootfsDir);
        pm.runCommandElevated((Boolean)false, "rm", "-rf", rootfsDir);
        return true;
    }

    @Override
    public Boolean call() throws Exception {
        this.reporter.startStep("Copying Wifi Config...");
        this.copyConfigFile();
        this.setRetrySetupAdaptorService();
        this.reporter.finishStep("Copying Wifi Config...Done");
        return true;
    }
}

