/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.linux.tasks;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.tizen.iotsetupmanager.AbstractFlashingTask;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.PasswordCancelledException;
import org.tizen.iotsetupmanager.ProcessManagerLinux;
import org.tizen.iotsetupmanager.Reporter;
import org.tizen.iotsetupmanager.ResourceUtils;
import org.tizen.iotsetupmanager.TargetDeviceInfo;

public class TaskPrepareScriptRPi3
extends AbstractFlashingTask {
    public TaskPrepareScriptRPi3(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        super(flashProfile, targetDevice, reporter);
    }

    @Override
    public Boolean call() throws PasswordCancelledException {
        this.reporter.startStep("Preparing script...");
        ProcessManagerLinux pm = new ProcessManagerLinux();
        pm.runCommandElevated((Boolean)false, "rm", "-rf", "ism/");
        try {
            for (String fname : ResourceUtils.RPIFILES) {
                ResourceUtils.copyToFile("rpi3/" + fname);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        pm.runCommand(false, "chmod", "755", "ism/rpi3/sd_fusing_rpi3.sh");
        String output = pm.runCommand(true, "gsettings", "get", "org.gnome.desktop.media-handling", "automount-open");
        if (!StringUtils.isBlank((CharSequence)output) && output.trim().compareTo("true") == 0) {
            ResourceUtils.automount = true;
            System.out.println("Setting automount-open to false");
            pm.runCommand(false, "gsettings", "set", "org.gnome.desktop.media-handling", "automount-open", "false");
        }
        this.reporter.finishStep("Preparing script...Done");
        return true;
    }
}

