/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.windows.tasks;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.tizen.iotsetupmanager.AbstractFlashingTask;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.IoTSetupWizard;
import org.tizen.iotsetupmanager.Reporter;
import org.tizen.iotsetupmanager.TargetDeviceInfo;
import org.tizen.iotsetupmanager.windows.DiskInfoWindows;
import org.tizen.iotsetupmanager.windows.Ext4FileSystemUtils;
import org.tizen.iotsetupmanager.windows.FlashUtils;

public class TaskCopyWifiConfigCommon
extends AbstractFlashingTask {
    public TaskCopyWifiConfigCommon(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        super(flashProfile, targetDevice, reporter);
        if (!DiskInfoWindows.class.isInstance(targetDevice)) {
            throw new IllegalArgumentException("Target Device is not an instance of DiskInfoWindows!!!");
        }
    }

    private Boolean copyConfigFile() throws Exception {
        File configFile = new File(IoTSetupWizard.getNetworkProfileDir() + this.flashProfile.name + ".config.json");
        if (!configFile.exists()) {
            this.reporter.finishStep("Wireless config file not found. Skipping");
            return true;
        }
        String tempDirPath = "ism/tempdir/";
        String adaptorDir = tempDirPath + "etc/setup-adaptor/";
        String configFileDestinationPath = adaptorDir + "config.json";
        File tempMountDir = new File(tempDirPath);
        FileUtils.forceMkdir(tempMountDir);
        Ext4FileSystemUtils fsutils = new Ext4FileSystemUtils();
        if (!fsutils.mountDiskImage(".\\ism\\images\\system-data.img", tempDirPath)) {
            System.err.println("Failed to mount system-data image!!");
            FileUtils.deleteDirectory(tempMountDir);
            this.reporter.finishStep("Failed to mount system-data.img..");
            return true;
        }
        fsutils.createDirectory(adaptorDir);
        fsutils.copyFileToDirectory(configFile.getAbsolutePath(), configFileDestinationPath);
        fsutils.unMountPath(tempDirPath);
        fsutils.clearAllDevices();
        FileUtils.deleteDirectory(tempMountDir);
        Ext4FileSystemUtils.unLoadLibrary();
        return true;
    }

    private Boolean setRetrySetupAdaptorService() throws Exception {
        File configFile = new File(IoTSetupWizard.getNetworkProfileDir() + this.flashProfile.name + ".config.json");
        if (!configFile.exists()) {
            this.reporter.finishStep("config file not found. Skipping");
            return true;
        }
        String tempWorkingPath = "ism/tmp/";
        File tempWorkingDir = new File(tempWorkingPath);
        FileUtils.forceMkdir(tempWorkingDir);
        String serviceFileName = "setup-adaptor.service";
        String serviceFilePath = tempWorkingPath + serviceFileName;
        FlashUtils.copyResourceFile(serviceFileName, tempWorkingPath);
        File serviceFile = new File(serviceFilePath);
        if (!serviceFile.exists()) {
            System.err.println("service file not copied... : " + serviceFilePath);
            this.reporter.finishStep("service file not found. Error");
            return false;
        }
        System.out.println("service file is copied... : " + serviceFile.getAbsolutePath());
        String tempDirPath = "ism/tempdir/";
        File tempMountDir = new File(tempDirPath);
        FileUtils.forceMkdir(tempMountDir);
        Ext4FileSystemUtils fsutils = new Ext4FileSystemUtils();
        if (!fsutils.mountDiskImage(".\\ism\\images\\rootfs.img", tempDirPath)) {
            System.err.println("Failed to mount rootfs image!!");
            FileUtils.deleteDirectory(tempMountDir);
            this.reporter.finishStep("Failed to mount rootfs.img..");
            return true;
        }
        String serviceDir = tempDirPath + "usr/lib/systemd/system/";
        String serviceFileDestinationPath = serviceDir + "setup-adaptor.service";
        if (fsutils.doesFileExist(serviceFileDestinationPath)) {
            System.out.println("delete existing service file : " + serviceFileDestinationPath);
            fsutils.removeFile(serviceFileDestinationPath);
        }
        System.out.println(String.format("Copy file from : {%s} to {%s}", serviceFile.getAbsolutePath(), serviceFileDestinationPath));
        fsutils.copyFileToDirectory(serviceFile.getAbsolutePath(), serviceFileDestinationPath);
        fsutils.unMountPath(tempDirPath);
        fsutils.clearAllDevices();
        FileUtils.deleteDirectory(tempMountDir);
        FileUtils.deleteDirectory(tempWorkingDir);
        Ext4FileSystemUtils.unLoadLibrary();
        return true;
    }

    @Override
    public Boolean call() throws Exception {
        this.reporter.startStep("Copying Wifi configs..");
        this.copyConfigFile();
        this.setRetrySetupAdaptorService();
        this.reporter.finishStep("Wifi Config prepared..");
        return true;
    }
}

