/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.windows.tasks;

import com.sun.jna.platform.win32.WinNT;
import java.io.File;
import org.tizen.iotsetupmanager.AbstractFlashingTask;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.Reporter;
import org.tizen.iotsetupmanager.TargetDeviceInfo;
import org.tizen.iotsetupmanager.windows.DiskInfoWindows;
import org.tizen.iotsetupmanager.windows.FlashUtils;
import org.tizen.iotsetupmanager.windows.WinUtils;

public class TaskFuseImagesCommon
extends AbstractFlashingTask {
    private String[] imageNames = null;
    private long[] partitionStartSectors = null;
    private long[] filesystemTotalSectors = null;

    public TaskFuseImagesCommon(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        super(flashProfile, targetDevice, reporter);
        if (!DiskInfoWindows.class.isInstance(targetDevice)) {
            throw new IllegalArgumentException("Target Device is not an instance of DiskInfoWindows!!!");
        }
        if (flashProfile.deviceType == FlashProfile.DeviceTYPE.RPI3_HEADLESS || flashProfile.deviceType == FlashProfile.DeviceTYPE.RPI3_HEADED) {
            this.imageNames = FlashUtils.RPI3_IMAGE_NAMES;
            this.partitionStartSectors = FlashUtils.RPI3_PARTITION_START_SECTORS;
            this.filesystemTotalSectors = FlashUtils.RPI3_FILESYSTEM_TOTAL_SECTORS;
        } else if (flashProfile.deviceType == FlashProfile.DeviceTYPE.RPI4_HEADLESS || flashProfile.deviceType == FlashProfile.DeviceTYPE.RPI4_HEADED) {
            this.imageNames = FlashUtils.RPI3_IMAGE_NAMES;
            this.partitionStartSectors = FlashUtils.RPI3_PARTITION_START_SECTORS;
            this.filesystemTotalSectors = FlashUtils.RPI3_FILESYSTEM_TOTAL_SECTORS;
        } else {
            this.imageNames = FlashUtils.RPI3_IMAGE_NAMES;
            this.partitionStartSectors = FlashUtils.RPI3_PARTITION_START_SECTORS;
            this.filesystemTotalSectors = FlashUtils.RPI3_FILESYSTEM_TOTAL_SECTORS;
        }
    }

    @Override
    public Boolean call() throws Exception {
        this.reporter.startStep("Fusing Images...");
        for (int i = 0; i < this.imageNames.length; ++i) {
            WinNT.HANDLE fileHandle = null;
            WinNT.HANDLE volumeHandle = null;
            WinNT.HANDLE diskHandle = null;
            String imageName = this.imageNames[i];
            String imagePath = ".\\ism\\images\\" + imageName;
            File file = new File(imagePath);
            if (!file.exists()) {
                System.err.println("Skipping " + imageName + ". File not present");
                continue;
            }
            fileHandle = WinUtils.getHandle(file.getAbsolutePath());
            if (fileHandle == null) {
                System.err.println("File Handle is null for " + imageName + ". Skipping it");
                continue;
            }
            String volumePath = "\\\\.\\" + ((DiskInfoWindows)this.targetDevice).getPath().substring(0, 2);
            volumeHandle = WinUtils.getHandle(volumePath);
            if (volumeHandle == null) {
                System.err.println("Volume Handle is null for " + ((DiskInfoWindows)this.targetDevice).getPath() + ". Skipping it");
                WinUtils.releaseHandle(fileHandle);
                continue;
            }
            diskHandle = WinUtils.getPhysicalDriveHandle(volumeHandle);
            if (diskHandle == null) {
                System.err.println("Physical Disk Handle is null for " + ((DiskInfoWindows)this.targetDevice).getPath() + ". Skipping it");
                WinUtils.releaseHandle(fileHandle);
                WinUtils.releaseHandle(volumeHandle);
                continue;
            }
            WinUtils.lockVolume(volumeHandle);
            WinUtils.dismountVolume(volumeHandle);
            if (!WinUtils.copySectorDataFromFileToPartition(fileHandle, diskHandle, (int)this.partitionStartSectors[i], (int)this.filesystemTotalSectors[i], ((DiskInfoWindows)this.targetDevice).getSectorSize())) {
                System.err.println("Failed to fuse image file " + imageName + ". Skipping...");
            }
            WinUtils.unlockVolume(volumeHandle);
            WinUtils.releaseHandle(diskHandle);
            WinUtils.releaseHandle(volumeHandle);
            WinUtils.releaseHandle(fileHandle);
        }
        this.reporter.finishStep("Fusing images done...");
        return true;
    }
}

