/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.windows.tasks;

import com.sun.jna.platform.win32.WinNT;
import java.io.InputStream;
import org.tizen.iotsetupmanager.AbstractFlashingTask;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.Reporter;
import org.tizen.iotsetupmanager.TargetDeviceInfo;
import org.tizen.iotsetupmanager.windows.BootRecord;
import org.tizen.iotsetupmanager.windows.DiskInfoWindows;
import org.tizen.iotsetupmanager.windows.FlashUtils;
import org.tizen.iotsetupmanager.windows.WinUtils;

public class TaskMakePartitionsRPi3
extends AbstractFlashingTask {
    BootRecord[] bootRec = new BootRecord[8];
    int numParts = 10;
    int userPartNumber = 3;

    private int getUserPartitionSize(long totalSectors) {
        return (int)(totalSectors - 9735172L);
    }

    private void calcPartOffsets(long userPartNumSectors) {
        FlashUtils.RPI3_FILESYSTEM_TOTAL_SECTORS[this.userPartNumber] = userPartNumSectors - 1L;
        for (int i = this.userPartNumber + 1; i < this.numParts; ++i) {
            FlashUtils.RPI3_PARTITION_START_SECTORS[i] = FlashUtils.RPI3_PARTITION_START_SECTORS[i - 1] + FlashUtils.RPI3_FILESYSTEM_TOTAL_SECTORS[i - 1] + 1L;
            FlashUtils.RPI3_BOOT_SECTORS[i - 2] = FlashUtils.RPI3_PARTITION_START_SECTORS[i] - 1L;
        }
    }

    public TaskMakePartitionsRPi3(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        super(flashProfile, targetDevice, reporter);
        if (!DiskInfoWindows.class.isInstance(targetDevice)) {
            throw new IllegalArgumentException("Target Device is not an instance of DiskInfoWindows!!!");
        }
    }

    private void readSectorBackup(String path) throws Exception {
        path = "/org/tizen/iotsetupmanager/windows/" + path;
        InputStream is = this.getClass().getResourceAsStream(path);
        byte[] buffer = new byte[512];
        int len = 0;
        int count = 0;
        if (is != null) {
            try {
                while ((len = is.read(buffer, 0, 512)) >= 512) {
                    System.out.println(String.format("Read %d bytes", len));
                    WinUtils.printBootRecord(buffer);
                    this.bootRec[count++] = new BootRecord((byte[])buffer.clone());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            is.close();
        }
        if (count != 8) {
            throw new Exception(String.format("Failed to read boot sector backup. Only read %d values", count));
        }
    }

    private void setSectorInfo() {
        int i;
        int sum = 0;
        for (i = 3; i < 10; ++i) {
            sum = (int)((long)sum + (FlashUtils.RPI3_FILESYSTEM_TOTAL_SECTORS[i] + 1L));
        }
        this.bootRec[0].setPartitionTotalSectors(3, sum);
        for (i = 1; i < 7; ++i) {
            sum = (int)((long)sum - (FlashUtils.RPI3_FILESYSTEM_TOTAL_SECTORS[2 + i] + 1L));
            this.bootRec[i].setPartitionStartLBA(0, 1);
            this.bootRec[i].setPartitionTotalSectors(0, (int)FlashUtils.RPI3_FILESYSTEM_TOTAL_SECTORS[2 + i]);
            this.bootRec[i].setPartitionStartLBA(1, (int)(FlashUtils.RPI3_BOOT_SECTORS[i + 1] - FlashUtils.RPI3_BOOT_SECTORS[1]));
            this.bootRec[i].setPartitionTotalSectors(1, sum);
        }
        this.bootRec[7].setPartitionStartLBA(0, 1);
        this.bootRec[7].setPartitionTotalSectors(0, (int)FlashUtils.RPI3_FILESYSTEM_TOTAL_SECTORS[9]);
    }

    public boolean writeSectorInfoToDisk() {
        WinNT.HANDLE handle = WinUtils.getHandle("\\\\.\\" + ((DiskInfoWindows)this.targetDevice).getPath().substring(0, 2));
        if (handle == null) {
            System.err.println("Received empty logical disk handle");
            return false;
        }
        WinNT.HANDLE pHandle = WinUtils.getPhysicalDriveHandle(handle);
        if (pHandle == null) {
            System.err.println("Received empty physical disk handle");
            return false;
        }
        WinUtils.lockVolume(handle);
        WinUtils.dismountVolume(handle);
        for (int i = 0; i < 8; ++i) {
            boolean success = WinUtils.writeSectorsToFile(pHandle, this.bootRec[i].getBytes(), (int)FlashUtils.RPI3_BOOT_SECTORS[i], 1, ((DiskInfoWindows)this.targetDevice).getSectorSize());
            if (success) continue;
            System.err.println(String.format("Failed to write boot sector no: %d", i));
        }
        WinUtils.unlockVolume(handle);
        WinUtils.releaseHandle(pHandle);
        WinUtils.releaseHandle(handle);
        return true;
    }

    @Override
    public Boolean call() throws Exception {
        this.reporter.startStep("Partitioning the disk...");
        int userPartSize = this.getUserPartitionSize(((DiskInfoWindows)this.targetDevice).getNumSectors());
        if (userPartSize < 204800) {
            System.err.println("SD Card size too small!!! Use SD Card larger than 4GB...");
            this.reporter.failedStep("SD Card is too small. Please use SD Card greated than 4GB!!!");
            return false;
        }
        this.calcPartOffsets(userPartSize);
        this.readSectorBackup("rpi3/sectors.bin.bk");
        this.setSectorInfo();
        this.writeSectorInfoToDisk();
        this.reporter.finishStep("Partitioning completed");
        return true;
    }
}

