/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager;

import com.google.gson.Gson;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.tizen.iotsetupmanager.EthernetInfo;
import org.tizen.iotsetupmanager.IoTSetupWizard;
import org.tizen.iotsetupmanager.NetworkInfo;
import org.tizen.iotsetupmanager.WifiInfo;

public class FlashProfile {
    public String name = "";
    public String bootPath = "";
    public String platformPath = "";
    public String rpmPath = "";
    public DeviceTYPE deviceType = DeviceTYPE.RPI3_HEADLESS;
    public FlashType flashType = FlashType.FRESH_INSTALL;
    public NetworkInfo networkData = new NetworkInfo();

    public FlashProfile clone() {
        FlashProfile cloneProfile = new FlashProfile();
        cloneProfile.name = this.name;
        cloneProfile.bootPath = this.bootPath;
        cloneProfile.platformPath = this.platformPath;
        cloneProfile.rpmPath = this.rpmPath;
        cloneProfile.deviceType = this.deviceType;
        cloneProfile.flashType = this.flashType;
        cloneProfile.networkData = this.networkData.clone();
        return cloneProfile;
    }

    public boolean valid() {
        if (StringUtils.isBlank((CharSequence)this.name)) {
            return false;
        }
        if (StringUtils.isBlank((CharSequence)this.bootPath)) {
            return false;
        }
        return !StringUtils.isBlank((CharSequence)this.platformPath);
    }

    public static FlashProfile createEmpty() {
        return new FlashProfile();
    }

    public static String getDefaultImagesDir() {
        if (SystemUtils.IS_OS_LINUX) {
            return IoTSetupWizard.getHomeDirectory() + "images/";
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return IoTSetupWizard.getHomeDirectory() + "images\\";
        }
        return IoTSetupWizard.getHomeDirectory() + "images/";
    }

    public static FlashProfile createDefault(DeviceTYPE targetType) {
        FlashProfile profile = FlashProfile.createEmpty();
        profile.name = "new_profile";
        profile.deviceType = targetType;
        profile.flashType = FlashType.FRESH_INSTALL;
        switch (targetType) {
            case RPI3_HEADLESS: {
                profile.bootPath = "xxx-boot-armv7l-rpi3.tar.gz";
                profile.platformPath = "xxx_headless-2parts-armv7l-btrfs-rootfs-rpi.tar.gz";
                break;
            }
            case RPI3_HEADED: {
                profile.bootPath = "xxx-boot-armv7l-rpi3.tar.gz";
                profile.platformPath = "xxx-headed-3parts-armv7l-rpi.tar.gz";
                break;
            }
            case RPI4_HEADLESS: {
                profile.bootPath = "xxx-boot-armv7l-rpi4.tar.gz";
                profile.platformPath = "xxx_headless-2parts-armv7l-btrfs-rootfs-rpi.tar.gz";
                break;
            }
            case RPI4_HEADED: {
                profile.bootPath = "xxx_boot-armv7l-rpi4.tar.gz";
                profile.platformPath = "xxx_headed-3parts-armv7l-rpi.tar.gz";
                break;
            }
            case NONE: 
            case UNKNOWN: {
                profile.bootPath = "";
                profile.platformPath = "";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported device type");
            }
        }
        profile.rpmPath = "";
        profile.networkData = new NetworkInfo();
        profile.networkData.version = "0.1";
        profile.networkData.wifi = new WifiInfo();
        profile.networkData.ethernet = new EthernetInfo();
        try {
            profile.networkData.httpProxyHost = (Inet4Address)Inet4Address.getByName("localhost");
        }
        catch (UnknownHostException e1) {
            e1.printStackTrace();
        }
        profile.networkData.httpProxyPort = 8080;
        profile.networkData.wifi.ssid = "ssid";
        profile.networkData.wifi.password = "password";
        profile.networkData.wifi.enabled = true;
        profile.networkData.wifi.dhcpEnabled = true;
        try {
            profile.networkData.wifi.ipAddress = (Inet4Address)Inet4Address.getByName("localhost");
            profile.networkData.wifi.netmask = (Inet4Address)Inet4Address.getByName("localhost");
            profile.networkData.wifi.defaultGateway = (Inet4Address)Inet4Address.getByName("localhost");
            profile.networkData.wifi.primaryDNSServer = (Inet4Address)Inet4Address.getByName("localhost");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        profile.networkData.ethernet.enabled = false;
        profile.networkData.ethernet.dhcpEnabled = false;
        try {
            profile.networkData.ethernet.ipAddress = (Inet4Address)Inet4Address.getByName("localhost");
            profile.networkData.ethernet.netmask = (Inet4Address)Inet4Address.getByName("localhost");
            profile.networkData.ethernet.defaultGateway = (Inet4Address)Inet4Address.getByName("localhost");
            profile.networkData.ethernet.primaryDnsServer = (Inet4Address)Inet4Address.getByName("localhost");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return profile;
    }

    public void write(String path) {
        Gson gson = new Gson();
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);){
            gson.toJson((Object)this, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String path) {
        FileOutputStream fs = null;
        BufferedWriter writer = null;
        try {
            fs = new FileOutputStream(path);
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fs, "UTF-8"));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (fs != null) {
                    fs.close();
                }
            }
            catch (IOException e) {
                System.err.println("delete >>> error during closing !!!");
                e.printStackTrace();
            }
        }
        File file = new File(path);
        if (file.exists()) {
            System.out.println("Delete file :" + path);
            if (file.delete()) {
                System.out.println("success to delete file..");
            } else {
                System.err.println("fail to delete file" + path);
            }
        }
    }

    public static FlashProfile read(String path) {
        Gson gson = new Gson();
        FlashProfile profile = null;
        try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(path), StandardCharsets.UTF_8);){
            profile = gson.fromJson((Reader)reader, FlashProfile.class);
            System.out.println(profile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return profile;
    }

    public static List<String> getReadableDeviceTypes() {
        ArrayList<String> types = new ArrayList<String>();
        types.add("RPI3_HEADLESS");
        types.add("RPI3_HEADED");
        types.add("RPI4_HEADLESS");
        types.add("RPI4_HEADED");
        return types;
    }

    public static DeviceTYPE getDeviceTypeFromString(String type) {
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new IllegalArgumentException("This should not have happened");
        }
        switch (type) {
            case "RPI3_HEADLESS": {
                return DeviceTYPE.RPI3_HEADLESS;
            }
            case "RPI4_HEADLESS": {
                return DeviceTYPE.RPI4_HEADLESS;
            }
            case "RPI3_HEADED": {
                return DeviceTYPE.RPI3_HEADED;
            }
            case "ARTIK530_HEADLESS_INSTALLABLE": {
                return DeviceTYPE.ARTIK530_HEADLESS_INSTALLABLE;
            }
            case "ARTIK530_HEADED_INSTALLABLE": {
                return DeviceTYPE.ARTIK530_HEADED_INSTALLABLE;
            }
            case "ARTIK530_HEADLESS": {
                return DeviceTYPE.ARTIK530_HEADLESS;
            }
            case "ARTIK530_HEADED": {
                return DeviceTYPE.ARTIK530_HEADED;
            }
            case "RPI4_HEADED": {
                return DeviceTYPE.RPI4_HEADED;
            }
        }
        throw new IllegalArgumentException("This should not have happened");
    }

    public static String getReadableDeviceType(DeviceTYPE type) {
        switch (type) {
            case RPI3_HEADLESS: {
                return "RPI3_HEADLESS";
            }
            case RPI4_HEADLESS: {
                return "RPI4_HEADLESS";
            }
            case RPI3_HEADED: {
                return "RPI3_HEADED";
            }
            case RPI4_HEADED: {
                return "RPI4_HEADED";
            }
            case NONE: {
                return "NONE";
            }
            case UNKNOWN: {
                return "UNKNOWN";
            }
        }
        throw new IllegalArgumentException("This should not have happened");
    }

    public boolean bootImageFileExists() {
        return Files.exists(Paths.get(this.bootPath, new String[0]), new LinkOption[0]);
    }

    public boolean platformImageFileExists() {
        return Files.exists(Paths.get(this.platformPath, new String[0]), new LinkOption[0]);
    }

    public boolean rpmDirExists() {
        return Files.exists(Paths.get(this.rpmPath, new String[0]), new LinkOption[0]);
    }

    public static enum FlashType {
        FRESH_INSTALL,
        KERNEL_ONLY,
        PLATFORM_ONLY;

    }

    public static enum DeviceTYPE {
        NONE,
        RPI3_HEADLESS,
        RPI3_HEADED,
        RPI4_HEADED,
        RPI4_HEADLESS,
        ARTIK530_HEADLESS_INSTALLABLE,
        ARTIK530_HEADED_INSTALLABLE,
        ARTIK530_HEADLESS,
        ARTIK530_HEADED,
        UNKNOWN;

    }
}

