/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager;

import java.awt.BorderLayout;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import org.apache.commons.lang3.StringUtils;
import org.tizen.iotsetupmanager.IProcessManager;
import org.tizen.iotsetupmanager.PasswordCancelledException;

public class ProcessManagerLinux
implements IProcessManager {
    private static String password = null;

    private static String getPasswdForRoot() throws IOException, PasswordCancelledException {
        int ret;
        byte[] buff;
        ProcessBuilder pb = new ProcessBuilder("sh", "-c", "sudo -S id");
        Process p = pb.start();
        InputStream is = p.getErrorStream();
        int n = is.read(buff = new byte[8192], 0, 8192);
        if (n < 0) {
            return null;
        }
        String text = new String(buff, 0, n);
        if (text.contains("root")) {
            return null;
        }
        JPanel panel = new JPanel(new BorderLayout());
        JLabel lab = new JLabel(text);
        panel.add((Component)lab, "North");
        JPasswordField password = new JPasswordField();
        panel.add((Component)password, "South");
        while ((ret = JOptionPane.showConfirmDialog(null, panel, "Password", 2)) == 0) {
            byte[] passwd = null;
            char[] pw = password.getPassword();
            passwd = pw == null ? (new String("") + "\r\n").getBytes() : (new String(pw) + "\r\n").getBytes();
            p.getOutputStream().write(passwd);
            p.getOutputStream().flush();
            n = is.read(buff, 0, 8192);
            if (n == -1) {
                char[] pass = password.getPassword();
                if (pass != null) {
                    return new String(pass);
                }
                return null;
            }
            text = new String(buff, 0, n);
            p = pb.start();
            is.close();
            is = p.getErrorStream();
            n = is.read(buff, 0, 8192);
            if (n != -1) continue;
        }
        System.out.println("Throwing PasswordCancelledException!!!");
        throw new PasswordCancelledException();
    }

    @Override
    public String runCommand(Boolean getOutput, String ... command) {
        System.out.println("*************Bash command**********");
        System.out.print(">");
        for (String c : command) {
            System.out.print(" " + c);
        }
        System.out.println("");
        StringBuilder builder = new StringBuilder("");
        try {
            String err;
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(new File("."));
            Process p = pb.start();
            BufferedReader brerr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((err = brerr.readLine()) != null) {
                System.out.println("E: " + err);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            if (getOutput.booleanValue()) {
                String line;
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                    builder.append(System.getProperty("line.separator"));
                }
            } else {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.println("O: " + line);
                }
            }
            p.waitFor();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        System.out.println("************************************");
        return builder.toString();
    }

    @Override
    public String runCommandElevated(Boolean getOutput, String ... command) throws PasswordCancelledException {
        return this.runCommandElevated(getOutput, (File)null, command);
    }

    @Override
    public String runCommandElevated(Boolean getOutput, File directory, String ... command) throws PasswordCancelledException {
        System.out.println("*************Bash SUDO commandr**********");
        String commandStr = "";
        System.out.print("$ sudo -S ");
        for (String c : command) {
            commandStr = commandStr + c + " ";
        }
        System.out.println(commandStr);
        try {
            if (StringUtils.isBlank((CharSequence)password)) {
                password = ProcessManagerLinux.getPasswdForRoot();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] passwd = null;
        if (password != null) {
            passwd = (password + "\n").getBytes();
        }
        StringBuilder builder = new StringBuilder("");
        try {
            String err;
            ProcessBuilder pb = new ProcessBuilder("/bin/sh", "-c", "sudo -S " + commandStr);
            Map<String, String> env = pb.environment();
            env.put("TERM", "dumb");
            if (directory != null) {
                pb.directory(new File(directory.getAbsolutePath() + "/"));
            }
            Process p = pb.start();
            if (password != null) {
                p.getOutputStream().write(passwd);
                p.getOutputStream().flush();
            }
            BufferedReader brerr = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((err = brerr.readLine()) != null) {
                System.out.println("E: " + err);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));
            if (getOutput.booleanValue()) {
                String line;
                while ((line = br.readLine()) != null) {
                    builder.append(line);
                    builder.append(System.getProperty("line.separator"));
                }
            } else {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.println("O: " + line);
                }
            }
            p.waitFor();
        }
        catch (Exception ex) {
            System.out.println(ex);
        }
        System.out.println("************************************");
        return builder.toString();
    }
}

