/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.tizen.iotsetupmanager.AbstractFlashingTask;
import org.tizen.iotsetupmanager.DiskInfo;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.FlashScriptBuilder;
import org.tizen.iotsetupmanager.IFlasher;
import org.tizen.iotsetupmanager.IProgress;
import org.tizen.iotsetupmanager.PasswordCancelledException;
import org.tizen.iotsetupmanager.Reporter;
import org.tizen.iotsetupmanager.TargetDeviceInfo;

public class SDFlasher
implements IFlasher {
    private final int flashingStopped = 0;
    private final int flashingStarted = 1;
    private AtomicInteger curState = new AtomicInteger(0);
    private FlashProfile flashProfile;
    private IProgress progress = null;
    ExecutorService executor = null;

    @Override
    public void start(FlashProfile profile, TargetDeviceInfo targetDevice) {
        if (profile == null) {
            throw new IllegalArgumentException("Flash profile is null");
        }
        if (targetDevice == null) {
            throw new IllegalArgumentException("Target device is null");
        }
        if (!this.curState.compareAndSet(0, 1)) {
            throw new IllegalStateException("Attempt to start when state is: " + this.curState.toString());
        }
        this.flashProfile = profile;
        this.executor = Executors.newSingleThreadExecutor();
        Reporter reporter = new Reporter(this.progress);
        FlashScriptBuilder builder = FlashScriptBuilder.construct(this.flashProfile, targetDevice, reporter);
        List<Callable<Boolean>> script = builder.generate();
        script.add(new TaskFinalize(this.flashProfile, reporter));
        reporter.setStepTotal(script.size());
        this.executor.submit(() -> this.scheduleAndMonitorTasks(script));
    }

    private void stopFlash(String message) {
        this.progress.update(0, 1);
        this.progress.updateStatus(message);
        this.stop(false);
    }

    private void scheduleAndMonitorTasks(List<Callable<Boolean>> script) {
        for (Callable<Boolean> task : script) {
            if (Thread.currentThread().isInterrupted()) {
                this.stopFlash("Flashing Stopped due to external interruption");
                break;
            }
            try {
                Boolean success = task.call();
                if (success != null && success.booleanValue()) continue;
                this.stopFlash("Flashing Stopped due to error in previous step");
            }
            catch (PasswordCancelledException e) {
                e.printStackTrace();
                this.stopFlash("Flashing Stopped due to cancellation of password");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.stopFlash("Flashing Stopped due to unknown Exception");
            }
            break;
        }
    }

    @Override
    public void stop(boolean force) {
        System.out.println("SDFLASHER: stop");
        this.curState.compareAndSet(1, 0);
        if (this.executor == null) {
            return;
        }
        try {
            System.out.println("attempt to shutdown executor");
            this.executor.shutdown();
            this.executor.awaitTermination(force ? 0L : 120L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            System.err.println("tasks interrupted");
        }
        finally {
            if (this.executor == null) {
                return;
            }
            if (!this.executor.isTerminated()) {
                System.err.println("cancel non-finished tasks");
            }
            this.executor.shutdownNow();
            System.out.println("shutdown finished");
            System.out.println("SD flashed!");
            this.executor = null;
            this.curState.compareAndSet(1, 0);
        }
    }

    @Override
    public boolean isRunning() {
        return this.curState.get() == 1;
    }

    @Override
    public void setProgressCallback(IProgress progress) {
        this.progress = progress;
    }

    private class TaskFinalize
    extends AbstractFlashingTask {
        public TaskFinalize(FlashProfile flashProfile, Reporter reporter) {
            super(flashProfile, new DiskInfo("", "", Float.valueOf(0.0f)), reporter);
        }

        @Override
        public Boolean call() throws Exception {
            if (SDFlasher.this.progress != null) {
                SDFlasher.this.progress.updateStatus("Finalizing...");
            }
            SDFlasher.this.curState.compareAndSet(1, 0);
            if (SDFlasher.this.progress != null) {
                SDFlasher.this.progress.update(this.reporter.getCurStep(), this.reporter.getStepTotal());
                SDFlasher.this.progress.updateStatus("Done");
            }
            return true;
        }
    }
}

