/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.linux;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.tizen.iotsetupmanager.DiskInfo;
import org.tizen.iotsetupmanager.IDiskEventHandler;
import org.tizen.iotsetupmanager.IDiskManager;

public class DiskManagerLinux
implements IDiskManager {
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    IDiskEventHandler handler = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLineFromFile(String filePath) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(filePath))));
            String line = reader.readLine();
            if (line != null) {
                String string = line;
                return string;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return "";
    }

    private File[] getRemovableDiskFileList() {
        File dir = new File("/sys/block");
        return dir.listFiles(new FilenameFilter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean accept(File dir, String name) {
                if (name.contains("sd") || name.contains("mmcblk")) {
                    File removable = new File("/sys/block/" + name + "/removable");
                    FileInputStream in = null;
                    try {
                        in = new FileInputStream(removable);
                        if ((char)in.read() == '1') {
                            boolean bl = true;
                            return bl;
                        }
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
                return false;
            }
        });
    }

    private void poller() {
        int i = 0;
        File[] newDrives = null;
        ArrayList<Float> mArraySize = new ArrayList<Float>();
        mArraySize.clear();
        ArrayList<String> mArrayName = new ArrayList<String>();
        mArrayName.clear();
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                System.out.println("Exiting Removable Drive monitor thread");
                break;
            }
            newDrives = this.getRemovableDiskFileList();
            boolean changed = true;
            if (0 == mArraySize.size() && newDrives == null) {
                changed = false;
            } else if (0 < mArraySize.size() && newDrives != null && mArraySize.size() == newDrives.length) {
                for (i = 0; i < newDrives.length; ++i) {
                    if (newDrives[i].getName().compareTo((String)mArrayName.get(i)) != 0) {
                        System.out.println("Existing deivce name is changed~~~");
                        break;
                    }
                    if (0 >= mArraySize.size() || this.getDiskSize(newDrives[i]).compareTo((Float)mArraySize.get(i)) == 0) continue;
                    System.out.println("Existing deivce size is changed~~~");
                    break;
                }
                if (i == newDrives.length) {
                    changed = false;
                }
            }
            if (!changed || newDrives == null) continue;
            System.out.println("Device changed ~~~");
            mArraySize.clear();
            for (i = 0; i < newDrives.length; ++i) {
                mArraySize.add(this.getDiskSize(newDrives[i]));
            }
            mArrayName.clear();
            for (i = 0; i < newDrives.length; ++i) {
                mArrayName.add(newDrives[i].getName());
            }
            this.handler.diskEventDetected();
        }
    }

    private Float getDiskSize(File file) {
        if (file == null) {
            return Float.valueOf(0.0f);
        }
        String sizeStr = this.getLineFromFile(file.getAbsolutePath() + "/size");
        String blocksStr = this.getLineFromFile(file.getAbsolutePath() + "/queue/logical_block_size");
        Float size = Float.valueOf(0.0f);
        if (!StringUtils.isBlank((CharSequence)sizeStr) && !StringUtils.isBlank((CharSequence)blocksStr)) {
            try {
                size = Float.valueOf(Float.parseFloat(sizeStr) * Float.parseFloat(blocksStr) / 1.074E9f);
            }
            catch (NumberFormatException e) {
                System.err.println("Error parsing disk size!!! Returning default value of 0");
            }
        }
        return size;
    }

    @Override
    public List<DiskInfo> getRemovableDisks() {
        File[] fileList = null;
        fileList = this.getRemovableDiskFileList();
        if (fileList == null) {
            return null;
        }
        ArrayList<DiskInfo> sdList = null;
        for (int i = 0; i < fileList.length; ++i) {
            Float size = this.getDiskSize(fileList[i]);
            if ((double)size.floatValue() == 0.0) continue;
            String vendorStr = this.getLineFromFile(fileList[i].getAbsolutePath() + "/device/vendor");
            String modelStr = this.getLineFromFile(fileList[i].getAbsolutePath() + "/device/model");
            String diskName = "";
            if (!StringUtils.isBlank((CharSequence)vendorStr) || !StringUtils.isBlank((CharSequence)modelStr)) {
                diskName = vendorStr + " " + modelStr;
            }
            if (sdList == null) {
                sdList = new ArrayList<DiskInfo>();
            }
            sdList.add(new DiskInfo("/dev/" + fileList[i].getName(), diskName, size));
        }
        return sdList;
    }

    @Override
    public Boolean subscribeDiskEvent(IDiskEventHandler diskEventHandler) {
        if (diskEventHandler == null) {
            System.err.println("Event Handler is null!!! Provide non-null event handler");
            return false;
        }
        if (this.handler != null) {
            System.err.println("Disk Event already subscribed!!! Call unsubscribeDiskEvent() first");
            return false;
        }
        this.handler = diskEventHandler;
        this.executor.submit(() -> this.poller());
        return true;
    }

    @Override
    public Boolean unsubscribeDiskEvent() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                System.err.println("Disk Event Watcher thread interrupted");
            }
            finally {
                if (!this.executor.isTerminated()) {
                    System.err.println("Disk Event Watcher - cancel non-finished tasks");
                }
                this.executor.shutdownNow();
                System.out.println("Disk Event Watcher shutdown finished");
                this.executor = null;
                this.handler = null;
            }
        }
        return true;
    }
}

