/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.windows;

import java.nio.ByteBuffer;

public class BootRecord {
    private byte[] bytes;
    private static int partition_table_offset = 446;
    private static int startLBA_offset = 8;
    private static int totalSectors_offset = 12;

    public BootRecord() {
    }

    public BootRecord(byte[] bytes) {
        this.bytes = bytes;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    private byte[] intToBytes(int x) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(x);
        return buffer.array();
    }

    private void setBytes(int offset, int payload) {
        byte[] arr = this.intToBytes(payload);
        System.out.println(String.format("Setting bytes: %d", payload));
        for (byte b : arr) {
            System.out.print(String.format("%02x ", b));
        }
        System.out.println();
        int j = 0;
        for (int i = arr.length - 1; i >= 0; --i) {
            this.bytes[offset + j++] = arr[i];
        }
    }

    public void setPartitionStartLBA(int partitionNumber, int lba) {
        int offset = partition_table_offset + partitionNumber * 16 + startLBA_offset;
        this.setBytes(offset, lba);
    }

    public void setPartitionTotalSectors(int partitionNumber, int numSectors) {
        int offset = partition_table_offset + partitionNumber * 16 + totalSectors_offset;
        this.setBytes(offset, numSectors);
    }
}

