/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.windows;

import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinNT;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.tizen.iotsetupmanager.DiskInfo;
import org.tizen.iotsetupmanager.IDiskEventHandler;
import org.tizen.iotsetupmanager.IDiskManager;
import org.tizen.iotsetupmanager.windows.DiskInfoWindows;
import org.tizen.iotsetupmanager.windows.WinUtils;
import org.tizen.iotsetupmanager.windows.ioctl.DiskGeometry;

public class DiskManagerWindows
implements IDiskManager {
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    IDiskEventHandler handler = null;

    @Override
    public List<DiskInfo> getRemovableDisks() {
        List<String> drives = WinUtils.getRemovableDriveLetters();
        if (drives == null) {
            return null;
        }
        WinNT.HANDLE lHandle = null;
        WinNT.HANDLE pHandle = null;
        ArrayList<DiskInfo> diskInfoList = new ArrayList<DiskInfo>();
        for (String drive : drives) {
            String logicaDrivePath = "\\\\.\\" + drive.substring(0, 2);
            lHandle = WinUtils.getHandle(logicaDrivePath);
            pHandle = WinUtils.getPhysicalDriveHandle(lHandle);
            if (pHandle == null) {
                System.err.println("Received null physical handle for " + logicaDrivePath + ". Skipping!!!");
            } else {
                DiskGeometry geometry = WinUtils.getDiskGeometry(pHandle);
                if (geometry != null) {
                    long numSectors = ((long)geometry.cylinderHigh << 32 | (long)geometry.cylinderLow) * (long)geometry.tracksPerCylinder * (long)geometry.sectorsPerTrack;
                    double size = (double)numSectors * (double)geometry.bytesPerSector / 1.074E9;
                    System.out.println(String.format("Size: %.2f", size));
                    diskInfoList.add(new DiskInfoWindows(drive, null, new Float(size), numSectors, geometry.bytesPerSector));
                }
            }
            WinUtils.releaseHandle(pHandle);
            WinUtils.releaseHandle(lHandle);
            lHandle = null;
            pHandle = null;
        }
        return diskInfoList.size() == 0 ? null : diskInfoList;
    }

    private void poller() {
        List drives = new ArrayList();
        List newDrives = null;
        while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                System.out.println("Exiting Removable Drive monitor thread");
                break;
            }
            newDrives = Kernel32Util.getLogicalDriveStrings();
            if (drives.equals(newDrives)) continue;
            drives = newDrives;
            this.handler.diskEventDetected();
        }
    }

    @Override
    public Boolean subscribeDiskEvent(IDiskEventHandler diskEventHandler) {
        if (diskEventHandler == null) {
            System.err.println("Event Handler is null!!! Provide non-null event handler");
            return false;
        }
        if (this.handler != null) {
            System.err.println("Disk Event already subscribed!!! Call unsubscribeDiskEvent() first");
            return false;
        }
        this.handler = diskEventHandler;
        this.executor.submit(() -> this.poller());
        return true;
    }

    @Override
    public Boolean unsubscribeDiskEvent() {
        if (this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(100L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                System.err.println("Disk Event Polling thread interrupted");
            }
            finally {
                if (!this.executor.isTerminated()) {
                    System.err.println("Disk Event Polling thread - cancel non-finished tasks");
                }
                this.executor.shutdownNow();
                System.out.println("Disk Event Polling thread shutdown finished");
                this.executor = null;
                this.handler = null;
            }
        }
        return true;
    }
}

