/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.windows;

import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.tizen.iotsetupmanager.windows.FlashUtils;

public class Ext4FileSystemUtils {
    private static LwExt4 INSTANCE = null;
    private static int blockDevCount = 0;
    public static final int EXT4_DE_UNKNOWN = 0;
    public static final int EXT4_DE_REG_FILE = 1;
    public static final int EXT4_DE_DIR = 2;
    public static final int EXT4_DE_CHRDEV = 3;
    public static final int EXT4_DE_BLKDEV = 4;
    public static final int EXT4_DE_FIFO = 5;
    public static final int EXT4_DE_SOC = 6;
    public static final int EXT4_DE_SYMLINK = 7;

    public Ext4FileSystemUtils() throws Exception {
        if (INSTANCE == null) {
            String libraryName = "lwext4";
            String arch = System.getProperty("sun.arch.data.model");
            if (arch.compareTo("32") == 0) {
                System.out.println("Loading 32 bit dll");
                libraryName = "lwext4_32";
            } else if (arch.compareTo("64") == 0) {
                System.out.println("Loading 64 bit dll");
                libraryName = "lwext4";
            } else {
                System.out.println("Unknown architecture!! unable to load dll");
                throw new Exception("Architecture is neither 64-bit nor 32-bit!! Unable to load appropriate dll");
            }
            FlashUtils.copyResourceFile(libraryName + ".dll", "./ism/");
            System.setProperty("jna.library.path", "./ism/");
            INSTANCE = (LwExt4)Native.loadLibrary((String)libraryName, LwExt4.class, (Map)W32APIOptions.ASCII_OPTIONS);
        }
    }

    private boolean mountBlockDev(String devPath, String mountPath, boolean isDisk) {
        System.out.println("Starting to mount " + devPath + " to " + mountPath);
        if (mountPath.charAt(mountPath.length() - 1) != '/') {
            System.err.println("Mount path should end with a '/'");
            return false;
        }
        File file = new File(mountPath);
        System.out.println("Mount path: " + file.getAbsolutePath());
        if (!file.exists()) {
            System.err.println("Mount Path \" + file.getAbsolutePath() + \"  does not exist!!!");
            return false;
        }
        Pointer p = null;
        if (isDisk) {
            INSTANCE.dll_file_windows_name_set(devPath);
            p = INSTANCE.dll_file_windows_dev_get();
            System.out.println("Obtained pointer to windows disk blockdevice");
        } else {
            INSTANCE.dll_file_dev_name_set(devPath);
            p = INSTANCE.dll_file_dev_get();
            System.out.println("Obtained pointer to disk image blockdevice");
        }
        String devName = String.format("swizBlockDev%d", blockDevCount++);
        Ext4Blockdev bdev = new Ext4Blockdev(p);
        int success = INSTANCE.dll_ext4_device_register(p, devName);
        bdev.read();
        if (success != 0) {
            System.err.println(String.format("Error registering device %d", success));
            return false;
        }
        System.out.println(String.format("Registered device successfully with name : %s", devName));
        success = INSTANCE.dll_ext4_mount(devName, mountPath, false);
        if (success != 0) {
            System.err.println(String.format("Error Mounting device %d", success));
            INSTANCE.dll_ext4_device_unregister(devName);
            return false;
        }
        System.out.println(String.format("Mounting Successful", new Object[0]));
        return true;
    }

    public boolean mountDisk(String diskPath, String mountPath) {
        return this.mountBlockDev(diskPath, mountPath, true);
    }

    public boolean mountDiskImage(String imagePath, String mountPath) {
        return this.mountBlockDev(imagePath, mountPath, false);
    }

    public boolean unMountPath(String mountPath) {
        int success = INSTANCE.dll_ext4_umount(mountPath);
        if (success != 0) {
            System.err.println(String.format("Unmount failed with error %d", success));
            return false;
        }
        System.out.println(String.format("Successfully unmounted - " + mountPath, new Object[0]));
        return true;
    }

    public boolean clearAllDevices() {
        int success = INSTANCE.dll_ext4_device_unregister_all();
        if (success != 0) {
            System.err.println(String.format("Failed to unregister all block devices with error : %d", success));
            return false;
        }
        return true;
    }

    public boolean copyFileToDirectory(String sourcePath, String destinationPath) {
        File sourceFile = new File(sourcePath);
        if (!sourceFile.exists()) {
            System.err.println(String.format("Source file does not exist -- %s", sourcePath));
            return false;
        }
        Ext4File file = new Ext4File();
        Pointer filePointer = file.getPointer();
        file.write();
        int success = INSTANCE.dll_ext4_fopen(filePointer, destinationPath, "wb");
        if (success != 0) {
            System.err.println(String.format("Failed to create destination file: %s", destinationPath));
            return false;
        }
        file.read();
        boolean retVal = true;
        byte[] buffer = new byte[10240];
        Memory ptr = new Memory((long)buffer.length);
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(sourceFile);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            retVal = false;
        }
        long offset = 0L;
        int bytesread = 0;
        IntByReference ibf = new IntByReference(0);
        if (retVal) {
            try {
                while ((bytesread = fis.read(buffer, 0, 10240)) != -1) {
                    ptr.write(0L, buffer, 0, buffer.length);
                    success = INSTANCE.dll_ext4_fwrite(filePointer, (Pointer)ptr, bytesread, ibf);
                    if (success != 0 || ibf.getValue() != bytesread) {
                        System.out.println(String.format("Writing bytes [%d] at offset [%d]", bytesread, offset));
                        System.out.println(String.format("Originally written [%d]", ibf.getValue()));
                        System.err.println(String.format("Failed to write to file with error %d", success));
                        System.out.flush();
                        retVal = false;
                        break;
                    }
                    offset += (long)bytesread;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                retVal = false;
            }
            System.out.println(String.format("Copied bytes: %d", offset));
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        INSTANCE.dll_ext4_fclose(filePointer);
        return retVal;
    }

    public boolean createDirectory(String directoryPath) {
        int success = INSTANCE.dll_ext4_dir_mk(directoryPath);
        if (success != 0) {
            System.err.println(String.format("Failed to create directory: %s", directoryPath));
            return false;
        }
        return true;
    }

    public boolean removeFile(String path) {
        int success = INSTANCE.dll_ext4_fremove(path);
        if (success != 0) {
            System.err.println(String.format("Failed to remove file: %s", path));
            return false;
        }
        return true;
    }

    public boolean createSymlink(String target, String path) {
        int success = INSTANCE.dll_ext4_fsymlink(target, path);
        if (success != 0) {
            System.err.println(String.format("Failed to create symlink: %s", path));
            return false;
        }
        return true;
    }

    public boolean setMode(String path, int mode) {
        int success = INSTANCE.dll_ext4_mode_set(path, mode);
        if (success != 0) {
            System.err.println(String.format("Failed to set mode of %s to [%d]", path, mode));
            return false;
        }
        return true;
    }

    public long getFileSize(Pointer file) {
        return INSTANCE.dll_ext4_fsize(file);
    }

    public boolean doesFileExist(String path) {
        int success = INSTANCE.dll_ext4_inode_exist(path, 0);
        System.out.println(String.format("Retval is: [%d]", success));
        if (success != 0) {
            System.out.println(String.format("Did not find file: %s", path));
            return false;
        }
        System.out.println(String.format("Found file: %s", path));
        return true;
    }

    public boolean copyAllFiles(String sourceDirectory, String destinationDirectory, HashMap<String, Integer> modeMap) {
        char lastchar = sourceDirectory.charAt(sourceDirectory.length() - 1);
        if (lastchar != '\\' && lastchar != '/') {
            sourceDirectory = sourceDirectory + "\\";
        }
        Collection files = FileUtils.listFiles(new File(sourceDirectory), null, true);
        for (File file : files) {
            String relativeFilePath = file.getPath().substring(sourceDirectory.length());
            System.out.println(String.format("Extracting file: [%s]", relativeFilePath));
            String[] folders = relativeFilePath.split("(\\\\|/)");
            String[] foldersOrig = relativeFilePath.split("(\\\\|/)");
            String pathStr = "";
            String pathStrOrig = "";
            for (int i = 0; i < foldersOrig.length - 1; ++i) {
                pathStrOrig = pathStrOrig + foldersOrig[i] + "/";
            }
            pathStrOrig = pathStrOrig + foldersOrig[foldersOrig.length - 1];
            String first = folders[0];
            System.out.println("First is: " + first);
            if (first.compareTo("lib") == 0 || first.compareTo("bin") == 0 || first.compareTo("sbin") == 0) {
                List<String> folderArray = Arrays.asList(folders);
                ArrayList<String> folderArrayNew = new ArrayList<String>();
                System.out.println("Adding usr");
                folderArrayNew.add("usr");
                for (String s : folderArray) {
                    folderArrayNew.add(s);
                }
                folders = folderArrayNew.toArray(new String[0]);
            }
            for (int i = 0; i < folders.length - 1; ++i) {
                pathStr = pathStr + folders[i] + "/";
                System.out.println(pathStr);
                if (this.doesFileExist(destinationDirectory + pathStr.substring(0, pathStr.length() - 1))) continue;
                this.createDirectory(destinationDirectory + pathStr.substring(0, pathStr.length() - 1));
            }
            System.out.println(String.format("Writing to file [%s]", destinationDirectory + pathStr + folders[folders.length - 1]));
            this.copyFileToDirectory(file.getPath(), destinationDirectory + pathStr + folders[folders.length - 1]);
            if (modeMap == null) continue;
            if (modeMap.containsKey(pathStrOrig)) {
                System.out.println("Setting filemode!!");
                this.setMode(destinationDirectory + pathStr + folders[folders.length - 1], modeMap.get(pathStrOrig));
                continue;
            }
            System.err.println(String.format("Error. File mode not set. File not present in Mode Map!!!\nKey not present [%s]", pathStrOrig));
        }
        return true;
    }

    public boolean setCapability(String path, byte[] capabilityBytes) {
        String capabilityAttrKey = "security.capability";
        Memory ptr = new Memory((long)capabilityBytes.length);
        ptr.write(0L, capabilityBytes, 0, capabilityBytes.length);
        int success = INSTANCE.dll_ext4_setxattr(path, "security.capability", "security.capability".length(), (Pointer)ptr, capabilityBytes.length);
        if (success != 0) {
            System.err.println(String.format("Failed to set capability of %s", path));
            return false;
        }
        return true;
    }

    public byte[] getCapability(String path) {
        String capabilityAttrKey = "security.capability";
        Memory ptr = new Memory(40L);
        IntByReference ibf = new IntByReference(0);
        int success = INSTANCE.dll_ext4_getxattr(path, "security.capability", "security.capability".length(), (Pointer)ptr, 40, ibf);
        if (success != 0) {
            System.err.println(String.format("Failed to get capability of %s [%d]", path, success));
            return null;
        }
        byte[] bytes = new byte[ibf.getValue()];
        ptr.read(0L, bytes, 0, ibf.getValue());
        return bytes;
    }

    public static void unLoadLibrary() {
        INSTANCE = null;
        System.gc();
    }

    public static interface LwExt4
    extends Library {
        public Pointer dll_file_dev_get();

        public void dll_file_dev_name_set(String var1);

        public Pointer dll_file_windows_dev_get();

        public void dll_file_windows_name_set(String var1);

        public int dll_ext4_device_register(Pointer var1, String var2);

        public int dll_ext4_device_unregister(String var1);

        public int dll_ext4_device_unregister_all();

        public int dll_ext4_mount(String var1, String var2, boolean var3);

        public int dll_ext4_umount(String var1);

        public int dll_ext4_fremove(String var1);

        public int dll_ext4_frename(String var1, String var2);

        public int dll_ext4_flink(String var1, String var2);

        public int dll_ext4_fsymlink(String var1, String var2);

        public int dll_ext4_fopen(Pointer var1, String var2, String var3);

        public int dll_ext4_fclose(Pointer var1);

        public int dll_ext4_fread(Pointer var1, Pointer var2, int var3, IntByReference var4);

        public int dll_ext4_fwrite(Pointer var1, Pointer var2, int var3, IntByReference var4);

        public int dll_ext4_fseek(Pointer var1, long var2, int var4);

        public long dll_ext4_fsize(Pointer var1);

        public int dll_ext4_mode_set(String var1, int var2);

        public int dll_ext4_dir_rm(String var1);

        public int dll_ext4_dir_mv(String var1, String var2);

        public int dll_ext4_dir_mk(String var1);

        public int dll_ext4_dir_open(Pointer var1, String var2);

        public int dll_ext4_dir_close(Pointer var1);

        public Pointer dll_ext4_dir_entry_next(Pointer var1);

        public void dll_ext4_dir_entry_rewind(Pointer var1);

        public int dll_ext4_inode_exist(String var1, int var2);

        public int dll_ext4_setxattr(String var1, String var2, int var3, Pointer var4, int var5);

        public int dll_ext4_getxattr(String var1, String var2, int var3, Pointer var4, int var5, IntByReference var6);

        public int dll_ext4_listxattr(String var1, Pointer var2, int var3, IntByReference var4);

        public int dll_ext4_removexattr(String var1, String var2, int var3);
    }

    public static class Ext4Blockdev
    extends Structure {
        public Pointer bdiff;
        public long partOffset;
        public long partSize;
        public Pointer bc;
        public int lgBsize;
        public long lgBcnt;
        public int cacheWriteBack;
        public Pointer fs;
        public Pointer journal;

        protected List<String> getFieldOrder() {
            return Arrays.asList("bdiff", "partOffset", "partSize", "bc", "lgBsize", "lgBcnt", "cacheWriteBack", "fs", "journal");
        }

        public Ext4Blockdev(Pointer p) {
            super(p);
        }
    }

    public static class Ext4Dir
    extends Structure {
        public Ext4File f;
        public Ext4Direntry de;
        public long nextOff;

        protected List<String> getFieldOrder() {
            return Arrays.asList("f", "de", "nextOff");
        }
    }

    public static class Ext4Direntry
    extends Structure {
        public int inode;
        public short entryLength;
        public byte nameLength;
        public byte inodeType;
        public byte[] name = new byte[255];

        public Ext4Direntry(Pointer p) {
            super(p);
        }

        public Ext4Direntry() {
        }

        protected List<String> getFieldOrder() {
            return Arrays.asList("inode", "entryLength", "nameLength", "inodeType", "name");
        }
    }

    public static class Ext4File
    extends Structure {
        public Pointer mp;
        public int inode;
        public int flags;
        public long fsize;
        public long fpos;

        protected List<String> getFieldOrder() {
            return Arrays.asList("mp", "inode", "flags", "fsize", "fpos");
        }
    }
}

