/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.windows;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;

public class FlashUtils {
    public static final String IMAGE_DIRECTORY = ".\\ism\\images\\";
    public static final long[] RPI3_BOOT_SECTORS = new long[]{0L, 9183232L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final long[] RPI3_PARTITION_START_SECTORS = new long[]{8192L, 139264L, 0x622000L, 9183233L, 0L, 0L, 0L, 0L, 0L, 0L};
    public static final long[] RPI3_FILESYSTEM_TOTAL_SECTORS = new long[]{131072L, 0x600000L, 0x2A0000L, 0L, 65536L, 16384L, 65536L, 16384L, 131072L, 256000L};
    public static final long RPI3_RESERVED_SECTOR_SIZE = 9735172L;
    public static final String[] RPI3_IMAGE_NAMES = new String[]{"boot.img", "rootfs.img", "system-data.img", "user.img", "modules.img", "ramdisk.img", "ramdisk-recovery.img", "inform.img"};

    public static void resetState() {
        FlashUtils.RPI3_BOOT_SECTORS[2] = 0L;
        FlashUtils.RPI3_BOOT_SECTORS[3] = 0L;
        FlashUtils.RPI3_BOOT_SECTORS[4] = 0L;
        FlashUtils.RPI3_PARTITION_START_SECTORS[4] = 0L;
        FlashUtils.RPI3_PARTITION_START_SECTORS[5] = 0L;
        FlashUtils.RPI3_PARTITION_START_SECTORS[6] = 0L;
        FlashUtils.RPI3_FILESYSTEM_TOTAL_SECTORS[3] = 0L;
    }

    public static void removeImages() {
        File directory = new File(IMAGE_DIRECTORY);
        if (!directory.exists()) {
            System.err.println("Images directory does not exist!!! Skipping");
            return;
        }
        try {
            FileUtils.deleteDirectory(directory);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyResourceFile(String relativePath, String fileName, String destinationDir) throws IOException {
        Files.createDirectories(Paths.get(destinationDir, new String[0]), new FileAttribute[0]);
        if (!new File(destinationDir).exists()) {
            System.err.println("Failed to create destination directory!!!");
            throw new IOException("Failed in directory creation!!!");
        }
        System.out.println("Created path: ");
        System.out.println(Paths.get(destinationDir, new String[0]).toAbsolutePath().toString());
        Class<?> currentClass = new Object(){}.getClass().getEnclosingClass();
        InputStream is = currentClass.getResourceAsStream("/org/tizen/iotsetupmanager/" + relativePath + fileName);
        if (is != null) {
            File targetFile = new File(destinationDir + fileName);
            try {
                Files.copy(is, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                is.close();
                throw e;
            }
            is.close();
        }
    }

    public static void copyResourceFile(String fileName, String destinationDir) throws IOException {
        FlashUtils.copyResourceFile("", fileName, destinationDir);
    }
}

