/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.windows;

import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.archivers.cpio.CpioArchiveEntry;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.compress.compressors.xz.XZCompressorInputStream;
import org.tizen.iotsetupmanager.windows.Constants;
import org.tizen.iotsetupmanager.windows.ioctl.DiskGeometry;
import org.tizen.iotsetupmanager.windows.ioctl.ISWKernel32;
import org.tizen.iotsetupmanager.windows.ioctl.VolumeDiskExtents;

public class WinUtils {
    private static final String PHYSICAL_DRIVE_PREFIX = "\\\\.\\PhysicalDrive";
    private static final ISWKernel32 instance = (ISWKernel32)Native.loadLibrary((String)"kernel32", ISWKernel32.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
    private static boolean flag1 = false;
    private static boolean flag2 = false;
    private static boolean flag3 = false;
    private static boolean flag4 = false;
    private static boolean flag5 = false;
    private static boolean flag6 = false;

    public static WinNT.HANDLE getHandle(String devicePath) {
        WinNT.HANDLE handle = null;
        handle = instance.CreateFile(devicePath, -1073741824, 3, null, 3, 0, null);
        if (handle == Kernel32.INVALID_HANDLE_VALUE) {
            int error = instance.GetLastError();
            System.err.println(String.format("Handle Creation for \"" + devicePath + "\" failed with error - %d", error));
            handle = null;
        } else {
            System.out.println("Handle successfully created for " + devicePath);
        }
        return handle;
    }

    public static WinNT.HANDLE getPhysicalDriveHandle(WinNT.HANDLE lHandle) {
        if (lHandle == Kernel32.INVALID_HANDLE_VALUE || lHandle == null) {
            System.err.println(String.format("Handle provided is " + lHandle == null ? "NULL" : "INVALID", new Object[0]));
            return null;
        }
        IntByReference bytesReturned = new IntByReference();
        VolumeDiskExtents vExtents = new VolumeDiskExtents();
        vExtents.write();
        boolean success = instance.DeviceIoControl(lHandle, Constants.IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS, null, 0, vExtents.getPointer(), vExtents.size(), bytesReturned, null);
        if (!success) {
            int error = instance.GetLastError();
            System.err.println(String.format("Failed to get volume extents with error - %d", error));
            return null;
        }
        vExtents.read();
        System.out.println("Successfully received volume extents");
        System.out.println(String.format("Size of output buffer: %d", vExtents.size()));
        System.out.println(String.format("Bytes returned: %d", bytesReturned.getValue()));
        int numDisks = vExtents.numberOfDiskExtents;
        System.out.println(String.format("Number of disks: %d", numDisks));
        if (numDisks != 1) {
            System.err.println("Multiple Disk Extents found!!!");
            return null;
        }
        int diskNum = vExtents.extents[0].diskNumber;
        System.out.println(String.format("Disk Number: %d", diskNum));
        System.out.println(String.format("Physical drive is : " + String.format("\\\\.\\PhysicalDrive%d", diskNum), new Object[0]));
        return WinUtils.getHandle(String.format("\\\\.\\PhysicalDrive%d", diskNum));
    }

    public static void releaseHandle(WinNT.HANDLE handle) {
        if (handle != null || handle != Kernel32.INVALID_HANDLE_VALUE) {
            instance.CloseHandle(handle);
        }
        System.out.println("Handle Released!!");
    }

    public static boolean lockVolume(WinNT.HANDLE handle) {
        IntByReference bytesReturned = new IntByReference();
        boolean success = instance.DeviceIoControl(handle, Constants.FSCTL_LOCK_VOLUME, null, 0, null, 0, bytesReturned, null);
        if (!success) {
            int error = instance.GetLastError();
            System.err.println(String.format("Failed to lock volume with error - %d", error));
            return false;
        }
        System.out.println("Successfully locked volume");
        return true;
    }

    public static boolean unlockVolume(WinNT.HANDLE handle) {
        IntByReference bytesReturned = new IntByReference();
        boolean success = instance.DeviceIoControl(handle, Constants.FSCTL_UNLOCK_VOLUME, null, 0, null, 0, bytesReturned, null);
        if (!success) {
            int error = instance.GetLastError();
            System.err.println(String.format("Failed to remove lock on volume with error - %d", error));
            return false;
        }
        System.out.println("Successfully removed lock on volume");
        return true;
    }

    public static boolean dismountVolume(WinNT.HANDLE handle) {
        IntByReference bytesReturned = new IntByReference();
        boolean success = instance.DeviceIoControl(handle, Constants.FSCTL_DISMOUNT_VOLUME, null, 0, null, 0, bytesReturned, null);
        if (!success) {
            int error = instance.GetLastError();
            System.err.println(String.format("Failed to dismout volume with error - %d", error));
            return false;
        }
        System.out.println("Successfully dismounted volume");
        return true;
    }

    public static List<String> getRemovableDriveLetters() {
        List allDrives = Kernel32Util.getLogicalDriveStrings();
        ArrayList<String> remDrives = new ArrayList<String>();
        for (String drive : allDrives) {
            if (Kernel32Util.getDriveType((String)("\\\\.\\" + drive)) != Constants.DRIVE_REMOVABLE) continue;
            remDrives.add(drive);
        }
        if (remDrives.size() == 0) {
            return null;
        }
        return remDrives;
    }

    public static DiskGeometry getDiskGeometry(WinNT.HANDLE handle) {
        DiskGeometry geometry = new DiskGeometry();
        IntByReference bytesReturned = new IntByReference();
        if (handle == Kernel32.INVALID_HANDLE_VALUE || handle == null) {
            System.err.println(String.format("Handle provided is " + handle == null ? "NULL" : "INVALID", new Object[0]));
            return null;
        }
        boolean success = instance.DeviceIoControl(handle, Constants.IOCTL_DISK_GET_DRIVE_GEOMETRY, null, 0, geometry.getPointer(), geometry.size(), bytesReturned, null);
        if (!success) {
            int error = instance.GetLastError();
            System.err.println(String.format("Failed to get disk geometry information with error - %d", error));
            return null;
        }
        System.out.println("Successfully received geometry");
        System.out.println(String.format("Size of output buffer: %d", geometry.size()));
        System.out.println(String.format("Bytes returned: %d", bytesReturned.getValue()));
        geometry.read();
        return geometry;
    }

    public static boolean writeSectorsToFile(WinNT.HANDLE toHandle, byte[] buffer, int startSector, int numSectors, int sectorSize) {
        WinNT.LARGE_INTEGER fileOffset = new WinNT.LARGE_INTEGER((long)startSector * (long)sectorSize);
        instance.SetFilePointer(toHandle, new WinDef.LONG(fileOffset.getLow().longValue()), new LongByReference(fileOffset.getHigh().longValue()), new WinDef.DWORD(0L));
        IntByReference bytesWritten = new IntByReference();
        int bytesToWrite = numSectors * sectorSize;
        boolean success = instance.WriteFile(toHandle, buffer, bytesToWrite, bytesWritten, null);
        if (!success) {
            int error = instance.GetLastError();
            System.out.println(String.format("\nFailed to Write sectors - %d", error));
        }
        return success;
    }

    public static byte[] readSectorsFromFile(WinNT.HANDLE fromHandle, int startSector, int numSectors, int sectorSize) {
        WinNT.LARGE_INTEGER fileOffset = new WinNT.LARGE_INTEGER((long)startSector * (long)sectorSize);
        instance.SetFilePointer(fromHandle, new WinDef.LONG(fileOffset.getLow().longValue()), new LongByReference(fileOffset.getHigh().longValue()), new WinDef.DWORD(0L));
        IntByReference bytesReturned = new IntByReference();
        int bytesToRead = numSectors * sectorSize;
        byte[] buffer = new byte[bytesToRead];
        boolean success = instance.ReadFile(fromHandle, buffer, bytesToRead, bytesReturned, null);
        if (!success) {
            int error = instance.GetLastError();
            System.out.println(String.format("\nFailed to Read sectors - %d", error));
            return null;
        }
        for (int i = bytesReturned.getValue(); i < bytesToRead; ++i) {
            buffer[i] = 0;
        }
        return buffer;
    }

    private static long bytesToLong(byte[] bytes) {
        return ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN).getLong();
    }

    private static int getNumSectorsOfFile(WinNT.HANDLE fileHandle, int sectorSize) {
        byte[] fileSizeArray = new byte[8];
        Memory ptr = new Memory((long)fileSizeArray.length);
        ptr.write(0L, fileSizeArray, 0, fileSizeArray.length);
        WinDef.BOOL success = instance.GetFileSizeEx(fileHandle, (Pointer)ptr);
        if (!success.booleanValue()) {
            int error = instance.GetLastError();
            System.out.println(String.format("\nFailed to get file size - %d", error));
            return 0;
        }
        ptr.read(0L, fileSizeArray, 0, fileSizeArray.length);
        for (int i = 0; i < fileSizeArray.length; ++i) {
            System.out.print(String.format("%02x ", fileSizeArray[i]));
        }
        System.out.println();
        long numBytes = WinUtils.bytesToLong(fileSizeArray);
        System.out.println();
        int numSectors = (int)(numBytes / (long)sectorSize + (long)(numBytes % (long)sectorSize == 0L ? 0 : 1));
        return numSectors;
    }

    public static void printBootRecord(byte[] buffer) {
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 16; ++j) {
                System.out.print(String.format("%02X ", buffer[i * 16 + j]));
            }
            System.out.println("");
        }
        System.out.println("");
        System.out.println("");
    }

    public static boolean copySectorDataFromFileToPartition(WinNT.HANDLE fileHandle, WinNT.HANDLE diskHandle, int partitionOffset, int numPartitionSectors, int sectorSize) {
        if (fileHandle == null || fileHandle == Kernel32.INVALID_HANDLE_VALUE) {
            System.err.println("Invalid File handle!!!");
            return false;
        }
        if (diskHandle == null || diskHandle == Kernel32.INVALID_HANDLE_VALUE) {
            System.err.println("Invalid Disk handle!!!");
            return false;
        }
        int numFileSectors = WinUtils.getNumSectorsOfFile(fileHandle, sectorSize);
        if (numFileSectors == 0) {
            System.err.println("Error - File Size is zero !!!");
            return false;
        }
        System.out.println(String.format("FileSectors: %d -- PartitionSectors: %d", numFileSectors, numPartitionSectors));
        if (numFileSectors > numPartitionSectors) {
            System.err.println("Disk Image is larger than the size of partition!!!");
            return false;
        }
        System.out.println("Starting to copy sectors....");
        boolean copySucceeded = true;
        int numSectorsToCopy = 0;
        for (int sector = 0; sector < numFileSectors; sector += 1024) {
            numSectorsToCopy = numFileSectors - sector > 1024 ? 1024 : numFileSectors - sector;
            byte[] sectorData = WinUtils.readSectorsFromFile(fileHandle, sector, numSectorsToCopy, sectorSize);
            if (sectorData == null) {
                System.out.println(String.format("\nFailed to Read sectors. Halting!!!", new Object[0]));
                copySucceeded = false;
                break;
            }
            boolean success = WinUtils.writeSectorsToFile(diskHandle, sectorData, partitionOffset + sector, numSectorsToCopy, sectorSize);
            if (success) continue;
            System.out.println(String.format("\nFailed to Write sectors. Halting!!!", new Object[0]));
            copySucceeded = false;
            break;
        }
        if (copySucceeded) {
            System.out.println(String.format("Successfuly copied %d sectors of data", numFileSectors));
        }
        return copySucceeded;
    }

    private static boolean extractGzFile(String sourcePath, String destinationPath) {
        GzipCompressorInputStream gzIn;
        OutputStream out;
        InputStream fin;
        try {
            fin = Files.newInputStream(Paths.get(sourcePath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        BufferedInputStream in = new BufferedInputStream(fin);
        try {
            out = Files.newOutputStream(Paths.get(destinationPath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                fin.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        try {
            gzIn = new GzipCompressorInputStream((InputStream)in);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                fin.close();
                out.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        byte[] buffer = new byte[2048];
        int n = 0;
        try {
            while (-1 != (n = gzIn.read(buffer))) {
                out.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                fin.close();
                out.close();
                gzIn.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        try {
            fin.close();
            out.close();
            gzIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static boolean extractTarFile(String sourcePath, String destinationDirectory) {
        InputStream fin;
        try {
            fin = Files.newInputStream(Paths.get(sourcePath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        BufferedInputStream in = new BufferedInputStream(fin);
        TarArchiveInputStream tin = new TarArchiveInputStream((InputStream)in);
        TarArchiveEntry entry = null;
        boolean retVal = true;
        block14: while (true) {
            try {
                while ((entry = tin.getNextTarEntry()) != null) {
                    OutputStream out;
                    String fileName = entry.getName();
                    byte[] buffer = new byte[2048];
                    try {
                        out = Files.newOutputStream(Paths.get(destinationDirectory + fileName, new String[0]), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            fin.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        return false;
                    }
                    int n = 0;
                    try {
                        while (-1 != (n = tin.read(buffer, 0, 2048))) {
                            out.write(buffer, 0, n);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break block14;
                    }
                    try {
                        out.close();
                        continue block14;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                retVal = false;
                break;
            }
        }
        try {
            tin.close();
            in.close();
            fin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    public static boolean extractTarGzFile(String sourcePath, String destinationDirectory) {
        try {
            Files.createDirectories(Paths.get(destinationDirectory, new String[0]), new FileAttribute[0]);
        }
        catch (IOException e2) {
            e2.printStackTrace();
            return false;
        }
        String tempFilePath = destinationDirectory + "temp_file.tar";
        if (!WinUtils.extractGzFile(sourcePath, tempFilePath)) {
            System.err.println("Failed to uncompress GZip file!!! " + sourcePath);
            return false;
        }
        if (!WinUtils.extractTarFile(tempFilePath, destinationDirectory)) {
            System.err.println("Failed to extract Tar file!!!");
            return false;
        }
        try {
            Files.delete(Paths.get(tempFilePath, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static boolean extractXzFile(String sourcePath, String destinationPath) {
        XZCompressorInputStream xzIn;
        OutputStream out;
        InputStream fin;
        try {
            fin = Files.newInputStream(Paths.get(sourcePath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        BufferedInputStream in = new BufferedInputStream(fin);
        try {
            out = Files.newOutputStream(Paths.get(destinationPath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                fin.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        try {
            xzIn = new XZCompressorInputStream((InputStream)in);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                fin.close();
                out.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        byte[] buffer = new byte[2048];
        int n = 0;
        try {
            while (-1 != (n = xzIn.read(buffer))) {
                out.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                fin.close();
                out.close();
                xzIn.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        try {
            fin.close();
            out.close();
            xzIn.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    private static boolean extractCpioFile(String sourcePath, String destinationDirectory, HashMap<String, Integer> modeMap) {
        InputStream fin;
        try {
            fin = Files.newInputStream(Paths.get(sourcePath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        BufferedInputStream in = new BufferedInputStream(fin);
        CpioArchiveInputStream cin = new CpioArchiveInputStream((InputStream)in);
        CpioArchiveEntry entry = null;
        boolean retVal = true;
        block14: while (true) {
            try {
                while ((entry = cin.getNextCPIOEntry()) != null) {
                    OutputStream out;
                    System.out.println(String.format("Extracting file [%s]", entry.getName()));
                    if (entry.isDirectory()) {
                        System.out.println("File is a directory... Skipping");
                        continue;
                    }
                    System.out.println(String.format("File mode is: %02X", entry.getMode()));
                    if (modeMap != null) {
                        modeMap.put(entry.getName().substring(2), WinUtils.getModeFromHex(entry.getMode()));
                    }
                    String fileName = entry.getName();
                    byte[] buffer = new byte[2048];
                    try {
                        File tf = new File(destinationDirectory + fileName).getParentFile();
                        if (tf != null && !tf.exists()) {
                            Files.createDirectories(Paths.get(tf.getPath(), new String[0]), new FileAttribute[0]);
                        }
                        out = Files.newOutputStream(Paths.get(destinationDirectory + fileName.substring(2), new String[0]), new OpenOption[0]);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        try {
                            fin.close();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        return false;
                    }
                    int n = 0;
                    try {
                        while (-1 != (n = cin.read(buffer, 0, 2048))) {
                            out.write(buffer, 0, n);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        break block14;
                    }
                    try {
                        out.close();
                        continue block14;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                break;
            }
            catch (IOException e1) {
                e1.printStackTrace();
                retVal = false;
                break;
            }
        }
        try {
            cin.close();
            in.close();
            fin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    private static void reset() {
        flag6 = false;
        flag5 = false;
        flag4 = false;
        flag3 = false;
        flag2 = false;
        flag1 = false;
    }

    private static boolean matchGZMagic(byte input) {
        boolean found = false;
        switch (input) {
            case 31: {
                flag6 = true;
                break;
            }
            case -117: {
                if (flag6) {
                    found = true;
                    break;
                }
                flag6 = false;
                break;
            }
            default: {
                flag6 = false;
            }
        }
        if (found) {
            flag6 = false;
        }
        return found;
    }

    private static boolean matchXZMagic(byte input) {
        boolean found = false;
        switch (input) {
            case -3: {
                flag1 = true;
                break;
            }
            case 55: {
                if (flag1) {
                    flag2 = true;
                    break;
                }
                flag5 = false;
                flag4 = false;
                flag3 = false;
                flag2 = false;
                flag1 = false;
                break;
            }
            case 122: {
                if (flag2) {
                    flag3 = true;
                    break;
                }
                flag5 = false;
                flag4 = false;
                flag3 = false;
                flag2 = false;
                flag1 = false;
                break;
            }
            case 88: {
                if (flag3) {
                    flag4 = true;
                    break;
                }
                flag5 = false;
                flag4 = false;
                flag3 = false;
                flag2 = false;
                flag1 = false;
                break;
            }
            case 90: {
                if (flag4) {
                    flag5 = true;
                    break;
                }
                flag5 = false;
                flag4 = false;
                flag3 = false;
                flag2 = false;
                flag1 = false;
                break;
            }
            case 0: {
                if (flag5) {
                    found = true;
                    break;
                }
                flag5 = false;
                flag4 = false;
                flag3 = false;
                flag2 = false;
                flag1 = false;
                break;
            }
            default: {
                flag5 = false;
                flag4 = false;
                flag3 = false;
                flag2 = false;
                flag1 = false;
            }
        }
        if (found) {
            flag5 = false;
            flag4 = false;
            flag3 = false;
            flag2 = false;
            flag1 = false;
        }
        return found;
    }

    public static boolean extractRPMPayload(String sourcePath, String destinationDirectory, HashMap<String, Integer> modeMap) {
        OutputStream out;
        boolean foundGZ;
        boolean foundXZ;
        int off;
        byte[] buffer;
        InputStream fin;
        block34: {
            try {
                Files.createDirectories(Paths.get(destinationDirectory, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e2) {
                e2.printStackTrace();
                return false;
            }
            try {
                fin = Files.newInputStream(Paths.get(sourcePath, new String[0]), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
            byte[] header = new byte[96];
            buffer = new byte[2048];
            off = 2;
            foundXZ = false;
            foundGZ = false;
            try {
                int b;
                int n = fin.read(header, 0, 96);
                if (n == -1) {
                    System.out.println("Error!!! Cannot read rpm file");
                    try {
                        fin.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    return false;
                }
                fin.mark(Integer.MAX_VALUE);
                WinUtils.reset();
                while ((b = fin.read()) != -1) {
                    if (!WinUtils.matchXZMagic((byte)b)) continue;
                    System.out.println("Found XZ magic");
                    foundXZ = true;
                    break;
                }
                if (!foundXZ) {
                    WinUtils.reset();
                    fin.reset();
                    while ((b = fin.read()) != -1) {
                        if (!WinUtils.matchGZMagic((byte)b)) continue;
                        System.out.println("Found GZ magic");
                        foundGZ = true;
                        break;
                    }
                }
                if (foundXZ) {
                    buffer[0] = -3;
                    buffer[1] = 55;
                    buffer[2] = 122;
                    buffer[3] = 88;
                    buffer[4] = 90;
                    buffer[5] = 0;
                    off = 6;
                    break block34;
                }
                if (foundGZ) {
                    buffer[0] = 31;
                    buffer[1] = -117;
                    off = 2;
                    break block34;
                }
                System.err.println("No GZ or XZ magic found in RPM file");
                fin.close();
                return false;
            }
            catch (IOException e2) {
                e2.printStackTrace();
                try {
                    fin.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                return false;
            }
        }
        String tempZipFilePath = destinationDirectory + "temp1234.gz.xz.temp";
        String tempCpioFilePath = destinationDirectory + "temp1234.cpio.temp";
        try {
            out = Files.newOutputStream(Paths.get(tempZipFilePath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                fin.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return false;
        }
        int n = 0;
        try {
            n = fin.read(buffer, off, 2048 - off);
            System.out.println(n);
            out.write(buffer, 0, n + off);
            while (-1 != (n = fin.read(buffer))) {
                out.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            try {
                out.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        try {
            fin.close();
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (foundGZ) {
            WinUtils.extractGzFile(tempZipFilePath, tempCpioFilePath);
        } else if (foundXZ) {
            WinUtils.extractXzFile(tempZipFilePath, tempCpioFilePath);
        }
        WinUtils.extractCpioFile(tempCpioFilePath, destinationDirectory, modeMap);
        try {
            Files.delete(Paths.get(tempZipFilePath, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            Files.delete(Paths.get(tempCpioFilePath, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public static int getModeFromHex(long modeHex) {
        return (int)modeHex & 0x1FF;
    }
}

