/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.windows.tasks;

import java.io.File;
import org.tizen.iotsetupmanager.AbstractFlashingTask;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.Reporter;
import org.tizen.iotsetupmanager.TargetDeviceInfo;
import org.tizen.iotsetupmanager.windows.FlashUtils;
import org.tizen.iotsetupmanager.windows.WinUtils;

public class TaskExtractImageFilesCommon
extends AbstractFlashingTask {
    public TaskExtractImageFilesCommon(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        super(flashProfile, targetDevice, reporter);
    }

    @Override
    public Boolean call() throws Exception {
        File informImg;
        this.reporter.startStep("Extracting disk images...");
        if (!this.flashProfile.bootImageFileExists() || !this.flashProfile.platformImageFileExists()) {
            System.err.println("Check the paths for boot image and platform image!!!");
            this.reporter.failedStep(String.format("Image not found - %s!!!", !this.flashProfile.bootImageFileExists() ? this.flashProfile.bootPath : this.flashProfile.platformPath));
            return false;
        }
        if (!WinUtils.extractTarGzFile(this.flashProfile.bootPath, ".\\ism\\images\\")) {
            System.err.println("Failed to extract image files from boot image path");
            this.reporter.failedStep("Failed to extract boot images!!!");
            return false;
        }
        if (!WinUtils.extractTarGzFile(this.flashProfile.platformPath, ".\\ism\\images\\")) {
            System.err.println("Failed to extract image files from boot image path");
            this.reporter.failedStep("Failed to extract platform images!!!");
            return false;
        }
        File userImg = new File(".\\ism\\images\\user.img");
        if (!userImg.exists()) {
            System.out.println("User Image not provided. Using empty user image...");
            FlashUtils.copyResourceFile("windows/", "user.img", ".\\ism\\images\\");
        }
        if (this.flashProfile.deviceType == FlashProfile.DeviceTYPE.RPI3_HEADLESS && !(informImg = new File(".\\ism\\images\\inform.img")).exists()) {
            System.out.println("Inform Image not provided. Using empty inform image...");
            FlashUtils.copyResourceFile("windows/", "inform.img", ".\\ism\\images\\");
        }
        this.reporter.finishStep("Disk Images extracted");
        return true;
    }
}

