/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.iotsetupmanager.windows.tasks;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.tizen.iotsetupmanager.AbstractFlashingTask;
import org.tizen.iotsetupmanager.FlashProfile;
import org.tizen.iotsetupmanager.Reporter;
import org.tizen.iotsetupmanager.TargetDeviceInfo;
import org.tizen.iotsetupmanager.windows.DiskInfoWindows;
import org.tizen.iotsetupmanager.windows.Ext4FileSystemUtils;
import org.tizen.iotsetupmanager.windows.WinUtils;

public class TaskInstallRPMCommon
extends AbstractFlashingTask {
    public TaskInstallRPMCommon(FlashProfile flashProfile, TargetDeviceInfo targetDevice, Reporter reporter) {
        super(flashProfile, targetDevice, reporter);
        if (!DiskInfoWindows.class.isInstance(targetDevice)) {
            throw new IllegalArgumentException("Target Device is not an instance of DiskInfoWindows!!!");
        }
    }

    @Override
    public Boolean call() throws Exception {
        this.reporter.startStep("Installing RPMs...");
        if (StringUtils.isEmpty((CharSequence)this.flashProfile.rpmPath)) {
            this.reporter.finishStep("RPM dir empty. Skipping..");
            return true;
        }
        if (!this.flashProfile.rpmDirExists()) {
            this.reporter.finishStep("RPM dir does not exist. Skipping..");
            return true;
        }
        String tempDirPath = "ism/tempdir/";
        File tempMountDir = new File(tempDirPath);
        FileUtils.forceMkdir(tempMountDir);
        String rpmDirPath = "ism/temprpmdir/";
        File tempRpmDir = new File(rpmDirPath);
        FileUtils.forceMkdir(tempRpmDir);
        Ext4FileSystemUtils fsutils = new Ext4FileSystemUtils();
        if (!fsutils.mountDiskImage(".\\ism\\images\\rootfs.img", tempDirPath)) {
            System.err.println("Failed to mount rootfs image!!");
            FileUtils.deleteDirectory(tempMountDir);
            FileUtils.deleteDirectory(tempRpmDir);
            this.reporter.failedStep("RPM installation failed");
            return false;
        }
        Collection files = FileUtils.listFiles(new File(this.flashProfile.rpmPath), new String[]{"rpm"}, true);
        for (File file : files) {
            FileUtils.cleanDirectory(tempRpmDir);
            System.out.println(String.format("Extracting file: [%s]", file.getAbsolutePath()));
            HashMap<String, Integer> modeMap = new HashMap<String, Integer>();
            WinUtils.extractRPMPayload(file.getAbsolutePath(), rpmDirPath, modeMap);
            for (String fileName : modeMap.keySet()) {
                System.out.println(String.format("[%s] - [%o]", fileName, modeMap.get(fileName)));
            }
            fsutils.copyAllFiles(rpmDirPath, tempDirPath, modeMap);
        }
        if (this.flashProfile.deviceType != FlashProfile.DeviceTYPE.RPI3_HEADLESS) {
            if (fsutils.doesFileExist(tempDirPath + "usr/bin/wifi-loader")) {
                System.err.println("Setting Capability");
                byte[] capabilityBytes = new byte[]{1, 0, 0, 2, 2, 0, 21, 0, 2, 0, 21, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                fsutils.setCapability(tempDirPath + "usr/bin/wifi-loader", capabilityBytes);
            } else {
                System.err.println("Skipping capability setting. File does not exist");
            }
            if (fsutils.doesFileExist(tempDirPath + "usr/bin/wlan.sh")) {
                System.err.println("Setting mode");
                fsutils.setMode(tempDirPath + "usr/bin/wlan.sh", 493);
            } else {
                System.err.println("Skipping filemode setting. File does not exist");
            }
        }
        fsutils.unMountPath(tempDirPath);
        fsutils.clearAllDevices();
        FileUtils.deleteDirectory(tempRpmDir);
        FileUtils.deleteDirectory(tempMountDir);
        Ext4FileSystemUtils.unLoadLibrary();
        this.reporter.finishStep("RPM installation done...");
        return true;
    }
}

