#!/bin/sh

## User Define for desktop menu
desktoppath=~/.local/share/applications

## Do not modify the followings (Make desktop menu)
TIZEN_SDK_INSTALL_PATH=${INSTALLED_PATH}
if [ -z "$TIZEN_SDK_INSTALL_PATH" ]
then
   exit 2;
fi

## ism shortcut
ism_desktopfile=${desktoppath}/tizen-studio-ism.desktop
ism_iconfile=ism_128.ico
ism_iconpath=${TIZEN_SDK_INSTALL_PATH}/tools/iot-setup-manager/icons
ism_exefile=tools/iot-setup-manager/ism-launcher-jar
ism_exepath=${TIZEN_SDK_INSTALL_PATH}/$ism_exefile
ism_comment="IoT Setup Manager"
ism_name="IoT Setup Manager"

if [ -e "${MAKESHORTCUT_PATH}" ]
then
	"${MAKESHORTCUT_PATH}" \
		-f "${ism_desktopfile}" \
		-e "${ism_exepath}" \
    -i "${ism_iconpath}/$ism_iconfile" \
		-n "${ism_name}" \
		-c "${ism_comment}"
else
	echo ${MAKESHORTCUT_PATH} does not exist
fi

## make $USERNAME.lock file
echo ${SDK_DATA_PATH} > "${TIZEN_SDK_INSTALL_PATH}/tools/iot-setup-manager/.$USER.lock"
exit 0
