/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.common.plugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.tizen.common.ITizenProject;
import org.tizen.common.TizenProjectType;
import org.tizen.common.util.ProjectUtil;

public class ProjectUtils {
    public static void addReferencedProjects(IProject project, IProject[] referencedProjects, IProgressMonitor monitor) {
        try {
            IProjectDescription projectDescription = project.getDescription();
            IProject[] oldReferences = projectDescription.getReferencedProjects();
            IProject[] newReferences = Arrays.copyOf(oldReferences, oldReferences.length + referencedProjects.length);
            System.arraycopy(referencedProjects, 0, newReferences, oldReferences.length, referencedProjects.length);
            projectDescription.setReferencedProjects(newReferences);
            project.setDescription(projectDescription, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public static boolean existsProject(String projectName) {
        return ProjectUtils.getProjectByName(projectName) != null;
    }

    public static IProject getCurrentProject() {
        IProject project = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        project = ProjectUtils.getCurrentProject(selection);
        if (project == null) {
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return null;
            }
            IEditorPart editor = page.getActiveEditor();
            project = ProjectUtils.getCurrentProject(editor);
        }
        return project;
    }

    public static IProject getCurrentProject(IEditorPart editor) {
        IFile file;
        if (editor == null) {
            return null;
        }
        IProject project = null;
        IEditorInput input = editor.getEditorInput();
        if (input instanceof IFileEditorInput && (file = ((IFileEditorInput)input).getFile()) != null) {
            project = file.getProject();
        }
        return project;
    }

    public static IProject getCurrentProject(ISelection selection) {
        IResource resource;
        Object element;
        IProject project = null;
        if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (resource = (IResource)((IAdaptable)element).getAdapter(IResource.class)) != null) {
            project = resource.getProject();
        }
        return project;
    }

    public static IProject getProjectByName(String projectName) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (Objects.equals(project.getName(), projectName)) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isNaClProject(IProject project) {
        boolean isNaclProject = false;
        try {
            isNaclProject = project.hasNature("org.tizen.web.tv.sec.nacl.common.plugin.PNaClProjectNature");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return isNaclProject;
    }

    public static boolean isWebTvTizenProject(IProject project) {
        ITizenProject tizenProject = ProjectUtil.getTizenProject((IProject)project);
        if (tizenProject == null) {
            return false;
        }
        return tizenProject.getTizenProjectType() == TizenProjectType.TIZEN_WEB_APPLICATION;
    }

    public static IProject[] listNaclProjects() {
        IProject[] projects;
        ArrayList<IProject> naclProjects = new ArrayList<IProject>();
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.isAccessible() && !project.isHidden() && project.hasNature("org.tizen.web.tv.sec.nacl.common.plugin.PNaClProjectNature")) {
                    naclProjects.add(project);
                }
            }
            catch (CoreException ex) {
                ex.printStackTrace();
            }
            ++n2;
        }
        return naclProjects.toArray(new IProject[naclProjects.size()]);
    }

    public static void toggleNature(IProject project, ActionOnProject action, String natureId) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        ArrayList<String> tempNatures = new ArrayList<String>(Arrays.asList(natures));
        if (tempNatures.contains(natureId)) {
            tempNatures.remove(natureId);
        } else {
            if (action != null && !action.doAction(project)) {
                return;
            }
            tempNatures.add(natureId);
        }
        description.setNatureIds(tempNatures.toArray(new String[0]));
        project.setDescription(description, null);
    }

    public static void toggleTizenProjectNaClNature(IProject project, ActionOnProject action) throws CoreException {
        ProjectUtils.toggleNature(project, action, "org.tizen.web.tv.sec.nacl.common.plugin.TizenProjectPNaClNature");
    }

    public static interface ActionOnProject {
        public boolean doAction(IProject var1);
    }
}

