/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.launch;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.tizen.web.tv.sec.nacl.launch.ChromeLaunchInitializer;
import org.tizen.web.tv.sec.nacl.launch.Messages;
import org.tizen.web.tv.sec.nacl.launch.NaclLaunchShortcut;

public class ChromeLaunchShortcut
extends NaclLaunchShortcut {
    @Override
    protected void launch(IProject project, String mode) {
        NaclLaunchShortcut.BuildConfigData activeConfigData = this.getCurrentBuildConfigData(project);
        if (activeConfigData == null) {
            this.showError(Messages.ChromeLaunchShortcut_FailedToGetActiveBuildConfig, Messages.ChromeLaunchShortcut_CouldNotDetermineActiveBuildConfigOrToolchain);
            return;
        }
        if (activeConfigData.getToolchainType() == NaclLaunchShortcut.BuildConfigData.ToolchainType.PNACL) {
            super.launch(project, mode);
        } else {
            this.showError(String.valueOf(Messages.ChromeLaunchShortcut_CannotRunInChrome) + activeConfigData.getName() + ".", Messages.ChromeLaunchShortcut_RunningInChromeSupportedWithPNaClConfig);
        }
    }

    @Override
    protected ILaunchConfigurationType getLaunchConfigurationType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.tizen.web.tv.sec.nacl.launch.chromeLaunchConfigurationType");
    }

    @Override
    protected ILaunchConfiguration createLaunchConfiguration(IProject project, boolean isDebug) throws CoreException {
        ILaunchConfigurationType type = this.getLaunchConfigurationType();
        String name = DebugPlugin.getDefault().getLaunchManager().generateLaunchConfigurationName(project.getName());
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, name);
        ChromeLaunchInitializer initializer = new ChromeLaunchInitializer(project);
        initializer.setProjectName(wc);
        initializer.setDefaultChromeCommand(wc);
        initializer.setDefaultChromeArguments(wc);
        if (!initializer.setDefaultHtmlFile(wc)) {
            throw new CoreException((IStatus)new Status(4, "org.tizen.web.tv.sec.nacl.launch", Messages.ChromeLaunchShortcut_errorLocatingHtml));
        }
        return wc.doSave();
    }
}

