/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.launch;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.web.tv.sec.nacl.launch.ChromeLaunchInitializer;
import org.tizen.web.tv.sec.nacl.launch.Messages;
import org.tizen.web.tv.sec.nacl.launch.NaclMainTab;

public class ChromeMainTab
extends NaclMainTab {
    private static final String[] HTML_EXTENSIONS = new String[]{"*.html;*.htm"};
    private Text chromePath;
    private Text chromeArg;
    private Text indexHtml;
    private org.eclipse.swt.widgets.List chromeArgsList;
    private Button chromeBrowseButton;
    private Button addArgButton;
    private Button updateArgButton;
    private Button removeArgButton;
    private Button indexBrowseButton;

    @Override
    public void createControl(Composite parent, ModifyListener listener) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout layout = new GridLayout(3, false);
        comp.setLayout((Layout)layout);
        this.createProjectNameControls(comp, listener);
        this.createChromeCommandControls(comp, listener);
        this.createChromeArgsControls(comp, listener);
        this.createMainHtmlControls(comp, listener);
    }

    private void createChromeCommandControls(Composite comp, ModifyListener listener) {
        Label label = new Label(comp, 0);
        label.setText(Messages.ChromeMainTab_chromePath);
        this.chromePath = new Text(comp, 2052);
        this.chromePath.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.chromePath.addModifyListener(listener);
        this.chromeBrowseButton = new Button(comp, 0);
        this.chromeBrowseButton.setText(Messages.ChromeMainTab_browseButtonLabel);
        this.chromeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                FileDialog dialog = new FileDialog(ChromeMainTab.this.getShell(), 0);
                ChromeMainTab.this.setChromePath(dialog.open());
            }
        });
    }

    private void setChromePath(String path) {
        if (path != null) {
            this.chromePath.setText(path);
        }
    }

    private void createChromeArgsControls(Composite comp, ModifyListener listener) {
        Label label = new Label(comp, 0);
        label.setText(Messages.ChromeMainTab_chromeArgs);
        this.chromeArg = new Text(comp, 2052);
        this.chromeArg.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.chromeArg.addModifyListener(listener);
        this.addArgButton = new Button(comp, 0);
        this.addArgButton.setText(Messages.ChromeMainTab_chromeArgumentAdd);
        this.addArgButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.addArgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ChromeMainTab.this.addChromeArgument();
                ChromeMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(comp, 0);
        this.chromeArgsList = new org.eclipse.swt.widgets.List(comp, 2564);
        this.chromeArgsList.setLayoutData((Object)new GridData(4, 4, true, false, 1, 2));
        this.chromeArgsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ChromeMainTab.this.handleArgumentSelection();
                ChromeMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.updateArgButton = new Button(comp, 0);
        this.updateArgButton.setText(Messages.ChromeMainTab_chromeArgumentUpdate);
        this.updateArgButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.updateArgButton.setEnabled(false);
        this.updateArgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ChromeMainTab.this.updateChromeArgument();
                ChromeMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        new Label(comp, 0);
        this.removeArgButton = new Button(comp, 0);
        this.removeArgButton.setText(Messages.ChromeMainTab_chromeArgumentRemove);
        this.removeArgButton.setLayoutData((Object)new GridData(4, 1, false, false));
        this.removeArgButton.setEnabled(false);
        this.removeArgButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                ChromeMainTab.this.removeChromeArgument();
                ChromeMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void addChromeArgument() {
        String argument = this.chromeArg.getText();
        if (!argument.isEmpty()) {
            this.chromeArgsList.add(argument);
        }
    }

    private void handleArgumentSelection() {
        int selection = this.chromeArgsList.getSelectionIndex();
        boolean buttonsEnabled = false;
        if (selection >= 0) {
            buttonsEnabled = true;
            String argument = this.chromeArgsList.getItem(selection);
            this.chromeArg.setText(argument);
        }
        this.updateArgButton.setEnabled(buttonsEnabled);
        this.removeArgButton.setEnabled(buttonsEnabled);
    }

    private void updateChromeArgument() {
        String argument = this.chromeArg.getText();
        if (!argument.isEmpty()) {
            int selection = this.chromeArgsList.getSelectionIndex();
            this.chromeArgsList.setItem(selection, argument);
        }
    }

    private void removeChromeArgument() {
        int count;
        int selection = this.chromeArgsList.getSelectionIndex();
        if (selection >= 0) {
            this.chromeArgsList.remove(selection);
        }
        if ((count = this.chromeArgsList.getItemCount()) == 0) {
            this.updateArgButton.setEnabled(false);
            this.removeArgButton.setEnabled(false);
        } else {
            selection = Math.min(selection, count - 1);
            this.chromeArgsList.select(selection);
        }
    }

    private void createMainHtmlControls(Composite comp, ModifyListener listener) {
        Label label = new Label(comp, 0);
        label.setText(Messages.ChromeMainTab_mainHtmlFile);
        this.indexHtml = new Text(comp, 2052);
        this.indexHtml.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.indexHtml.addModifyListener(listener);
        this.indexBrowseButton = new Button(comp, 0);
        this.indexBrowseButton.setText(Messages.ChromeMainTab_browseButtonLabel);
        this.indexBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IProject project;
                FileDialog dialog = new FileDialog(ChromeMainTab.this.getShell(), 0);
                dialog.setFilterExtensions(HTML_EXTENSIONS);
                String projectNameStr = ChromeMainTab.this.projName.getText();
                if (!projectNameStr.isEmpty() && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectNameStr)) != null && project.exists()) {
                    dialog.setFilterPath(project.getLocation().toString());
                }
                ChromeMainTab.this.setIndexHtml(dialog.open());
            }
        });
    }

    private void setIndexHtml(String location) {
        if (location != null) {
            this.indexHtml.setText(location);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        IProject selectedProject = this.getSelectedProject();
        String projectName = selectedProject != null ? selectedProject.getName() : "";
        configuration.setAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", projectName);
        ChromeLaunchInitializer initializer = new ChromeLaunchInitializer(selectedProject);
        initializer.setDefaultChromeCommand(configuration);
        initializer.setDefaultChromeArguments(configuration);
        initializer.setDefaultHtmlFile(configuration);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.projName.setText(configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", ""));
            this.chromePath.setText(configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.CHROME_PATH", ""));
            List arguments = configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.CHROME_ARGS", new ArrayList());
            if (!arguments.isEmpty()) {
                this.chromeArgsList.setItems(arguments.toArray(new String[arguments.size()]));
            } else {
                this.chromeArgsList.removeAll();
            }
            this.chromeArg.setText("");
            this.indexHtml.setText(configuration.getAttribute("org.tizen.web.tv.sec.nacl.launch.INDEX_HTML", ""));
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", this.projName.getText());
        configuration.setAttribute("org.tizen.web.tv.sec.nacl.launch.CHROME_PATH", this.chromePath.getText());
        configuration.setAttribute("org.tizen.web.tv.sec.nacl.launch.CHROME_ARGS", Arrays.asList(this.chromeArgsList.getItems()));
        configuration.setAttribute("org.tizen.web.tv.sec.nacl.launch.INDEX_HTML", this.indexHtml.getText());
    }

    public boolean isValid(ILaunchConfiguration config) {
        String htmlPath;
        block6: {
            block5: {
                this.setErrorMessage(null);
                try {
                    if (this.isProjectNameValid(config)) break block5;
                    return false;
                }
                catch (CoreException e) {
                    this.setErrorMessage(Messages.ChromeMainTab_unknownError);
                    e.printStackTrace();
                    return false;
                }
            }
            htmlPath = config.getAttribute("org.tizen.web.tv.sec.nacl.launch.INDEX_HTML", "");
            if (!htmlPath.isEmpty()) break block6;
            this.setErrorMessage(Messages.ChromeMainTab_htmlPathEmpty);
            return false;
        }
        if (!Files.exists(Paths.get(htmlPath, new String[0]), new LinkOption[0])) {
            this.setErrorMessage(Messages.ChromeMainTab_invalidHtmlPath);
            return false;
        }
        return true;
    }
}

