/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.launch;

import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.tizen.web.tv.sec.nacl.adapter.launch.Emulator;
import org.tizen.web.tv.sec.nacl.launch.Messages;

public class DeviceSelectionDialog
extends Dialog {
    private static final int EMU_TABLE_SERIAL_COLUMN = 0;
    private static final int EMU_TABLE_NAME_COLUMN = 1;
    private String selectedDevice = "";
    private Table emuTable;
    private TableColumn emuSerialColumn;

    public DeviceSelectionDialog(Shell parentShell) {
        super(parentShell);
    }

    public String openDialog() {
        if (this.open() == 0) {
            return this.selectedDevice;
        }
        return "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        Label lblNewLabel = new Label(container, 0);
        lblNewLabel.setText(Messages.DeviceSelectionDialog_selectEmulator);
        this.emuTable = new Table(container, 67584);
        this.emuTable.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.emuTable.setHeaderVisible(true);
        this.emuTable.setLinesVisible(true);
        this.emuSerialColumn = new TableColumn(this.emuTable, 0);
        this.emuSerialColumn.setWidth(100);
        this.emuSerialColumn.setText(Messages.DeviceSelectionDialog_tblclmnNewColumn_text);
        TableColumn emuNameColumn = new TableColumn(this.emuTable, 0);
        emuNameColumn.setWidth(100);
        emuNameColumn.setText(Messages.DeviceSelectionDialog_tblclmnNewColumn_1_text);
        this.emuTable.addSelectionListener(new SelectionListener(){

            private void handleEmulatorSelection() {
                int index = DeviceSelectionDialog.this.emuTable.getSelectionIndex();
                if (index >= 0) {
                    DeviceSelectionDialog.this.selectedDevice = DeviceSelectionDialog.this.emuTable.getItem(index).getText(0);
                    DeviceSelectionDialog.this.getButton(0).setEnabled(true);
                } else {
                    DeviceSelectionDialog.this.selectedDevice = "";
                    DeviceSelectionDialog.this.getButton(0).setEnabled(false);
                }
            }

            public void widgetSelected(SelectionEvent ev) {
                this.handleEmulatorSelection();
            }

            public void widgetDefaultSelected(SelectionEvent ev) {
                this.handleEmulatorSelection();
            }
        });
        Button refreshButton = new Button(container, 2048);
        refreshButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        refreshButton.setText(Messages.DeviceSelectionDialog_refresh);
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                DeviceSelectionDialog.this.refreshEmulators();
            }
        });
        this.refreshEmulators();
        return container;
    }

    private void refreshEmulators() {
        List emulators = Emulator.list();
        int selection = this.emuTable.getSelectionIndex();
        String previous = "";
        if (selection > -1) {
            previous = this.emuTable.getItem(selection).getText(0);
        }
        this.emuTable.removeAll();
        selection = -1;
        int idx = 0;
        for (Emulator.EmulatorInfo info : emulators) {
            TableItem ti = new TableItem(this.emuTable, 0);
            ti.setText(0, info.serial);
            ti.setText(1, info.name);
            if (info.serial.equals(previous)) {
                selection = idx;
            }
            ++idx;
        }
        if (selection > -1) {
            this.emuTable.setSelection(selection);
        }
        this.emuSerialColumn.pack();
    }

    protected void configureShell(Shell newShell) {
        newShell.setText(Messages.DeviceSelectionDialog_chooseDevice);
        super.configureShell(newShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button button = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        button.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Point getInitialSize() {
        return new Point(276, 300);
    }
}

