/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.launch;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.nacl.common.plugin.TargetListener;
import org.tizen.web.tv.sec.nacl.launch.Messages;

public abstract class NaclMainTab
extends AbstractLaunchConfigurationTab {
    protected Text projName;
    private List<TargetListener> listeners = new ArrayList<TargetListener>();

    public void addListener(TargetListener toAdd) {
        this.listeners.add(toAdd);
    }

    public void notifyTargetChanged(String targetName) {
        for (TargetListener hl : this.listeners) {
            hl.targetChanged(targetName);
        }
    }

    public String getName() {
        return Messages.NaclMainTab_tabName;
    }

    public void createControl(Composite parent) {
        ModifyListener listener = new ModifyListener(){

            public void modifyText(ModifyEvent evt) {
                NaclMainTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.createControl(parent, listener);
    }

    public abstract void createControl(Composite var1, ModifyListener var2);

    protected void createProjectNameControls(Composite comp, ModifyListener listener) {
        GridLayout layout = (GridLayout)comp.getLayout();
        int span = Math.min(layout.numColumns - 2, 1);
        Label label = new Label(comp, 0);
        label.setText(Messages.NaclMainTab_projectName);
        this.projName = new Text(comp, 2052);
        this.projName.setLayoutData((Object)new GridData(4, 0x1000000, true, false, span, 1));
        this.projName.addModifyListener(listener);
        Button selectButton = new Button(comp, 8);
        selectButton.setText(Messages.General_select);
        selectButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        selectButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                LabelProvider provider = new LabelProvider(){

                    public String getText(Object element) {
                        if (element == null) {
                            return "";
                        }
                        if (element instanceof IProject) {
                            return ((IProject)element).getName();
                        }
                        return element.toString();
                    }
                };
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(NaclMainTab.this.getShell(), (ILabelProvider)provider);
                Object[] projects = ProjectUtils.listNaclProjects();
                dialog.setElements(projects);
                dialog.setMultipleSelection(false);
                dialog.setTitle(Messages.General_projectSelectTitle);
                dialog.setMessage(Messages.General_projectSelectMessage);
                String selectedProject = dialog.open() == 0 ? provider.getText(dialog.getFirstResult()) : "";
                provider.dispose();
                if (!selectedProject.isEmpty()) {
                    NaclMainTab.this.projName.setText(selectedProject);
                }
            }
        });
    }

    protected boolean isProjectNameValid(ILaunchConfiguration config) throws CoreException {
        String projectName = config.getAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", "");
        if (projectName.isEmpty()) {
            this.setErrorMessage(Messages.NaclMainTab_emptyProjectName);
            return false;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project == null || !project.exists()) {
            this.setErrorMessage(Messages.NaclMainTab_invalidProjectName);
            return false;
        }
        if (!project.hasNature("org.tizen.web.tv.sec.nacl.common.plugin.PNaClProjectNature")) {
            this.setErrorMessage(Messages.NaclMainTab_notANaclProject);
            return false;
        }
        return true;
    }

    protected IProject getSelectedProject() {
        IProject project = ProjectUtils.getCurrentProject();
        if (project == null) {
            return null;
        }
        try {
            if (project.hasNature("org.tizen.web.tv.sec.nacl.common.plugin.PNaClProjectNature")) {
                return project;
            }
        }
        catch (CoreException ex) {
            ex.printStackTrace();
            return null;
        }
        return null;
    }

    public void updateLaunchConfigurationDialog() {
        super.updateLaunchConfigurationDialog();
    }

    public void setErrorMessage(String errorMessage) {
        super.setErrorMessage(errorMessage);
    }
}

