/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.tizenwizardadditions;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.common.ui.wizards.project.template.IToolChainExtension;
import org.tizen.web.tv.sec.nacl.common.plugin.UiUtils;
import org.tizen.web.tv.sec.nacl.tizenwizardadditions.IToolchainPageSettings;
import org.tizen.web.tv.sec.nacl.tizenwizardadditions.TVSupportContainer;
import org.tizen.web.tv.sec.nacl.tizenwizardadditions.ToolchainWizardPage;

public class ToolchainExtension
implements IToolChainExtension {
    private static final boolean IS_NACL_AVAILABLE_SAMPLE = true;
    private static final boolean IS_WASM_AVAILABLE_SAMPLE;
    private static final boolean IS_NACL_AVAILABLE_TEMPLATE = true;
    private static final boolean IS_WASM_AVAILABLE_TEMPLATE;
    private static ToolchainWizardPage samplePage;
    private static ToolchainWizardPage templatePage;
    private static IToolchainPageSettings sampleSettings;
    private static IToolchainPageSettings templateSettings;
    private static TVSupportContainer tvSampleSupportContainer;
    private static TVSupportContainer tvTemplateSupportContainer;

    static {
        IS_WASM_AVAILABLE_TEMPLATE = IS_WASM_AVAILABLE_SAMPLE = UiUtils.isPluginInstalled((String)"org.tizen.web.tv.sec.wasm.supportenabler");
        samplePage = null;
        templatePage = null;
        sampleSettings = new IToolchainPageSettings(){

            @Override
            public boolean isNaClEnabled() {
                if (tvSampleSupportContainer == null) {
                    Logger.getGlobal().warning("TV sample support container is missing in toolchain wizard page");
                    return false;
                }
                return tvSampleSupportContainer.isNaclSelected();
            }

            @Override
            public boolean isWASMEnabled() {
                if (tvSampleSupportContainer == null) {
                    Logger.getGlobal().warning("TV sample support container is missing in toolchain wizard page");
                    return false;
                }
                return tvSampleSupportContainer.isWasmSelected();
            }

            @Override
            public void setNaClEnabled(boolean enabled) {
                if (samplePage == null) {
                    Logger.getGlobal().warning("Sample page is missing in toolchain wizard page");
                    return;
                }
                samplePage.updatePage(this);
            }

            @Override
            public void setWASMEnabled(boolean enabled) {
                if (samplePage == null) {
                    Logger.getGlobal().warning("Sample page is missing in toolchain wizard page");
                    return;
                }
                samplePage.updatePage(this);
            }
        };
        templateSettings = new IToolchainPageSettings(){

            @Override
            public boolean isNaClEnabled() {
                if (tvTemplateSupportContainer == null) {
                    Logger.getGlobal().warning("TV template support container is missing in toolchain wizard page");
                    return false;
                }
                return tvTemplateSupportContainer.isNaclSelected();
            }

            @Override
            public boolean isWASMEnabled() {
                if (tvTemplateSupportContainer == null) {
                    Logger.getGlobal().warning("TV template support container is missing in toolchain wizard page");
                    return false;
                }
                return tvTemplateSupportContainer.isWasmSelected();
            }

            @Override
            public void setNaClEnabled(boolean enabled) {
                if (templatePage == null) {
                    Logger.getGlobal().warning("Template page is missing in toolchain wizard page");
                    return;
                }
                templatePage.updatePage(this);
            }

            @Override
            public void setWASMEnabled(boolean enabled) {
                if (templatePage == null) {
                    Logger.getGlobal().warning("Template page is missing in toolchain wizard page");
                    return;
                }
                templatePage.updatePage(this);
            }
        };
        tvSampleSupportContainer = null;
        tvTemplateSupportContainer = null;
    }

    public org.tizen.common.ui.wizards.project.template.ToolchainWizardPage getToolchainPage(IToolChainExtension.TizenProjectType type) {
        switch (type) {
            case SAMPLE: {
                samplePage = new ToolchainWizardPage();
                return samplePage;
            }
            case TEMPLATE: {
                templatePage = new ToolchainWizardPage();
                return templatePage;
            }
        }
        Logger.getGlobal().warning("Received unknown tizen project type");
        return null;
    }

    public boolean getToolchainPageEnabled(IToolChainExtension.TizenProjectType type) {
        switch (type) {
            case SAMPLE: {
                return sampleSettings.isNaClEnabled() || sampleSettings.isWASMEnabled();
            }
            case TEMPLATE: {
                return templateSettings.isNaClEnabled() || templateSettings.isWASMEnabled();
            }
        }
        Logger.getGlobal().warning("Received unknown tizen project type");
        return false;
    }

    public void implementTVContainer(Composite container, IToolChainExtension.TizenProjectType type) {
        switch (type) {
            case SAMPLE: {
                tvSampleSupportContainer = new TVSupportContainer(container, sampleSettings, true, IS_WASM_AVAILABLE_SAMPLE);
                break;
            }
            case TEMPLATE: {
                tvTemplateSupportContainer = new TVSupportContainer(container, templateSettings, true, IS_WASM_AVAILABLE_TEMPLATE);
                break;
            }
            default: {
                Logger.getGlobal().warning("Received unknown tizen project type");
            }
        }
    }

    public Map<IFile, Boolean> performFinish(IProject project, IProgressMonitor monitor, IToolChainExtension.TizenProjectType type) {
        switch (type) {
            case SAMPLE: {
                if (sampleSettings.isNaClEnabled()) {
                    samplePage.performNaClFinish(project);
                }
                if (!sampleSettings.isWASMEnabled()) break;
                samplePage.performWasmFinish(project);
                break;
            }
            case TEMPLATE: {
                if (templateSettings.isNaClEnabled()) {
                    templatePage.performNaClFinish(project);
                }
                if (!templateSettings.isWASMEnabled()) break;
                templatePage.performWasmFinish(project);
                break;
            }
            default: {
                Logger.getGlobal().warning("Received unknown tizen project type");
            }
        }
        return new HashMap<IFile, Boolean>();
    }
}

