/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.adapter.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.runtime.CoreException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.file.Resource;
import org.tizen.common.file.StandardFileHandler;

public class WidgetResourcesCollector
implements IResourceProxyVisitor {
    private static final String[] DEFAULT_IGNORED_EXTENSIONS = new String[]{".wgt", ".mk", ".c", ".cpp", ".cc", ".h", ".hpp"};
    private final Collection<IResource> resources = new ArrayList<IResource>();
    private final Collection<String> ignoredDirs;
    private final Collection<String> ignoredExtensions;
    private final FileHandler handler;

    public static List<String> getDefaultIgnoredExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(DEFAULT_IGNORED_EXTENSIONS.length);
        String[] stringArray = DEFAULT_IGNORED_EXTENSIONS;
        int n = DEFAULT_IGNORED_EXTENSIONS.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            extensions.add(ext);
            ++n2;
        }
        return extensions;
    }

    public WidgetResourcesCollector(String projectRoot, Collection<String> ignoredDirs, Collection<String> ignoredExtensions) {
        this.ignoredDirs = ignoredDirs == null ? new ArrayList<String>() : ignoredDirs;
        this.ignoredExtensions = ignoredExtensions == null ? WidgetResourcesCollector.getDefaultIgnoredExtensions() : ignoredExtensions;
        this.handler = new StandardFileHandler(projectRoot);
    }

    public Collection<IResource> getCollectedResources() {
        return this.resources;
    }

    public boolean visit(IResourceProxy proxy) throws CoreException {
        String name = proxy.getName();
        if (name.startsWith(".")) {
            return false;
        }
        switch (proxy.getType()) {
            case 2: {
                return !this.ignoredDirs.contains(proxy.getName());
            }
            case 1: {
                int extensionIdx = name.lastIndexOf(".");
                String extension = extensionIdx >= 0 ? name.substring(extensionIdx) : "";
                if (name.equalsIgnoreCase("makefile") || this.ignoredExtensions.contains(extension)) {
                    return false;
                }
                String path = proxy.requestResource().getProjectRelativePath().toString();
                this.resources.add((IResource)new Resource(this.handler, path));
                break;
            }
        }
        return true;
    }
}

