/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.debug;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.tizen.web.tv.sec.nacl.common.SystemInfo;
import org.tizen.web.tv.sec.nacl.debug.NaclDebugMainTab;
import org.tizen.web.tv.sec.nacl.debug.NaclMainTabMixin;
import org.tizen.web.tv.sec.nacl.launch.ChromeMainTab;
import org.tizen.web.tv.sec.nacl.launch.NaclMainTab;

public class ChromeDebugMainTab
extends NaclMainTabMixin {
    public ChromeDebugMainTab() {
        super((NaclMainTab)new ChromeMainTab());
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        try {
            List arguments = config.getAttribute("org.tizen.web.tv.sec.nacl.launch.CHROME_ARGS", new ArrayList());
            arguments.add("--enable-nacl-debug");
            arguments.add("--disable-hang-monitor");
            config.setAttribute("org.tizen.web.tv.sec.nacl.launch.CHROME_ARGS", arguments);
            NaclDebugMainTab.setDefaultValuesForGDB(config);
        }
        catch (CoreException ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public String genDefaultProgramFileName(String projectName, ILaunchConfiguration config) {
        ICProjectDescription projectDescription;
        String arch = "";
        if (projectName.isEmpty()) {
            return "";
        }
        if (SystemInfo.is64Bit()) {
            arch = "_x86-64";
        } else if (SystemInfo.is32Bit()) {
            arch = "_i686";
        }
        String buildConfigName = "Debug";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (project != null && (projectDescription = CoreModel.getDefault().getProjectDescription(project)) != null) {
            buildConfigName = projectDescription.getActiveConfiguration().getName();
        }
        return String.valueOf(buildConfigName) + File.separator + projectName + arch + ".nexe";
    }

    @Override
    public void updateNexePath(String targetName) {
    }

    public void targetChanged(String targetName) {
    }
}

