/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.debug;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.tizen.web.tv.sec.nacl.common.plugin.NaClModuleUtils;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.nacl.common.plugin.UiUtils;
import org.tizen.web.tv.sec.nacl.debug.DeviceDebugMainTab;
import org.tizen.web.tv.sec.nacl.debug.Messages;
import org.tizen.web.tv.sec.nacl.debug.NaClModuleSelector;
import org.tizen.web.tv.sec.nacl.debug.NaclDebugLaunchTab;
import org.tizen.web.tv.sec.nacl.launch.DeviceLaunchShortcut;
import org.tizen.web.tv.sec.nacl.launch.NaclLaunchShortcut;

public class DeviceDebugShortcut
extends DeviceLaunchShortcut {
    private static final String DEVICE_DEBUG_LAUNCH_CONFIGURATION = "org.tizen.web.tv.sec.nacl.debug.DeviceDebugLaunchConfiguration";

    private String[] getNaClProjectsNames(IProject[] naclProjects) {
        String[] naclModulesList = new String[naclProjects.length];
        int index = 0;
        IProject[] iProjectArray = naclProjects;
        int n = naclProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject naclProject = iProjectArray[n2];
            naclModulesList[index++] = naclProject.getName();
            ++n2;
        }
        return naclModulesList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IProject getNaClProjectToLaunch(IProject project) {
        IProject projectToLaunch = project;
        if (!ProjectUtils.isWebTvTizenProject((IProject)project)) return projectToLaunch;
        IProject[] naclProjects = NaClModuleUtils.getNaClModules((IProject)project);
        if (naclProjects.length == 1) {
            return naclProjects[0];
        }
        if (naclProjects.length > 1) {
            NaClModuleSelector.Data naclModuleSelectorData = new NaClModuleSelector.Data();
            NaClModuleSelector naclModuleSelector = new NaClModuleSelector(UiUtils.getShell(), this.getNaClProjectsNames(naclProjects), naclModuleSelectorData);
            if (naclModuleSelector.open() != 0) return null;
            return naclProjects[naclModuleSelectorData.getSelectedIndex()];
        }
        this.showError(Messages.DeviceDebugShortcut_FailedToStartDebugging, Messages.DeviceDebugShortcut_NoNaClModulesPresent);
        return null;
    }

    void launchNaClProjectIfValid(IProject naclProject, String mode) {
        NaclLaunchShortcut.BuildConfigData activeConfigData = this.getCurrentBuildConfigData(naclProject);
        if (activeConfigData == null) {
            this.showError(Messages.DeviceDebugShortcut_FailedToGetActiveBuildConfig, Messages.DeviceDebugShortcut_CouldNotDetermineActiveBuildConfigOrToolchain);
            return;
        }
        if (activeConfigData.getToolchainType() == NaclLaunchShortcut.BuildConfigData.ToolchainType.PNACL && activeConfigData.isDebug()) {
            super.launch(naclProject, mode);
        } else {
            this.showError(String.valueOf(Messages.DeviceDebugShortcut_CannotDebugOnTizenDevice) + activeConfigData.getName() + ".", Messages.DeviceDebugShortcut_DebuggingOnTizenDeviceSupportedWithDebugPNaClConfig);
        }
    }

    protected void launch(IProject project, String mode) {
        IProject projectToLaunch = this.getNaClProjectToLaunch(project);
        if (projectToLaunch == null) {
            return;
        }
        this.launchNaClProjectIfValid(projectToLaunch, mode);
    }

    protected ILaunchConfigurationType getLaunchConfigurationType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(DEVICE_DEBUG_LAUNCH_CONFIGURATION);
    }

    protected ILaunchConfiguration createLaunchConfiguration(IProject project, boolean isDebug) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = super.createLaunchConfiguration(project, isDebug).getWorkingCopy();
        DeviceDebugMainTab deviceDebugMainTab = new DeviceDebugMainTab();
        deviceDebugMainTab.setDefaults(wc);
        NaclDebugLaunchTab naclMainTab = new NaclDebugLaunchTab();
        naclMainTab.setDefaults(wc);
        return wc.doSave();
    }
}

