/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.debug;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.cdt.dsf.gdb.internal.ui.launching.RemoteApplicationCDebuggerTab;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.osgi.service.prefs.Preferences;
import org.tizen.web.tv.sec.nacl.builder.toolchain.NaclVariableSupplier;
import org.tizen.web.tv.sec.nacl.common.SystemInfo;
import org.tizen.web.tv.sec.nacl.debug.NaclDebugMainTab;
import org.tizen.web.tv.sec.nacl.preferences.INaclPreferences;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;

public class NaclDebugLaunchTab
extends RemoteApplicationCDebuggerTab {
    private static final String GDB_NAME = SystemInfo.is32Bit() ? "i686-nacl-gdb" : "x86_64-nacl-gdb";
    static final String GDB_HOST = "localhost";
    static final String PORT_NUM = "4014";
    private static final String WINDOWS_EXE = ".exe";
    private static final String MAIN_SYMBOL_C = "Instance_DidCreate";
    private static final String MAIN_SYMBOL_CPP = "pp::CreateModule()";
    private String gdbPath = "";

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        super.setDefaults(config);
        NaclDebugMainTab.setDefaultValuesForGDB(config);
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN", true);
        String mainSymbol = MAIN_SYMBOL_CPP;
        try {
            String projectName = config.getAttribute("org.tizen.web.tv.sec.nacl.launch.NACL_PROJECT_NAME", "");
            IProject naclProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            this.gdbPath = NaclDebugLaunchTab.genNaclDebugPath(naclProject);
            if (!naclProject.hasNature("org.eclipse.cdt.core.ccnature")) {
                mainSymbol = MAIN_SYMBOL_C;
            }
        }
        catch (Exception ex) {
            Logger.getGlobal().log(Level.WARNING, "GDB path or project language detection failed. C++ project language assumed.", ex);
        }
        String emulatorInstance = "";
        try {
            emulatorInstance = config.getAttribute("org.tizen.web.tv.sec.nacl.launch.EMULATOR_INSTANCE", "");
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (emulatorInstance.contains(":")) {
            String host = "";
            host = emulatorInstance.substring(0, emulatorInstance.indexOf(":"));
            config.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", host);
            config.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", PORT_NUM);
        } else {
            config.setAttribute("org.eclipse.cdt.dsf.gdb.HOST", GDB_HOST);
            config.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", PORT_NUM);
        }
        config.setAttribute("org.eclipse.cdt.launch.DEBUGGER_STOP_AT_MAIN_SYMBOL", mainSymbol);
        config.setAttribute("org.eclipse.cdt.dsf.gdb.UPDATE_THREADLIST_ON_SUSPEND", true);
        config.setAttribute("org.eclipse.cdt.dsf.gdb.DEBUG_NAME", this.gdbPath);
    }

    private static boolean canExecuteBinary(String[] binaryWithArgs) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(binaryWithArgs);
            if (!process.waitFor(1L, TimeUnit.SECONDS)) {
                process.destroyForcibly();
            }
            return process.exitValue() == 0;
        }
        catch (IOException | InterruptedException exception) {
            return false;
        }
    }

    private static String genNaclDebugPath(IProject project) {
        INaclPreferences preferences = NaclPreferenceActivator.getDefault().getNaclPreferences();
        Preferences node = preferences.getProjectPreferences(project);
        String pepperVersion = node.get("pepperVersion", "");
        Path pepperPath = null;
        File pepperLocation = new File(pepperVersion);
        if (pepperLocation.canRead()) {
            pepperPath = pepperLocation.toPath();
        } else {
            Map pepperMap = preferences.getPepperVersions();
            pepperPath = (Path)pepperMap.get(pepperVersion);
            if (pepperPath == null) {
                pepperPath = (Path)pepperMap.get(NaclVariableSupplier.getDefaultPepper((Map)pepperMap));
            }
            if (pepperPath == null || !pepperPath.toFile().canRead()) {
                return "";
            }
        }
        String debuggerPath = GDB_NAME;
        if (SystemInfo.isWindowsOs()) {
            debuggerPath = String.valueOf(debuggerPath) + WINDOWS_EXE;
        }
        Path toolchainPath = null;
        String[] stringArray = new String[]{"_x86_newlib", "_x86_glibc"};
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String toolchainArchPostfix = stringArray[n2];
            toolchainPath = FileSystems.getDefault().getPath(pepperPath.toString(), "toolchain", String.valueOf(SystemInfo.getOsName()) + toolchainArchPostfix, "bin", debuggerPath);
            if (NaclDebugLaunchTab.canExecuteBinary(new String[]{toolchainPath.toString(), "--version"})) break;
            ++n2;
        }
        return toolchainPath.toString();
    }
}

