/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.builder.toolchain;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;

public class TranslatorCommandGenerator
implements IManagedCommandLineGenerator {
    public IManagedCommandLineInfo generateCommandLineInfo(ITool tool, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources, String commandLinePattern) {
        String[] passedFlags;
        String configuration = tool.getParentResourceInfo().getParent().getId();
        if (configuration.startsWith("org.tizen.web.tv.sec.nacl.builder.toolchain.debug")) {
            passedFlags = Arrays.copyOf(flags, flags.length + 1);
            String baseName = tool.getParentResourceInfo().getParent().getManagedProject().getOwner().getName();
            StringBuilder sb = new StringBuilder("-arch ");
            sb.append("$(patsubst ").append(baseName).append("_%.nexe,%,").append("$(notdir $@))");
            passedFlags[passedFlags.length - 1] = sb.toString();
        } else {
            passedFlags = Arrays.copyOf(flags, flags.length);
        }
        return new CommandLineInfo(commandLinePattern, commandName, passedFlags, outputFlag, outputPrefix, "$@", inputResources);
    }

    private static class CommandLineInfo
    implements IManagedCommandLineInfo {
        private final String commandPattern;
        private final String commandName;
        private final String flags;
        private final String outputFlag;
        private final String outputPrefix;
        private final String outputName;
        private final String inputResources;
        private final String command;

        public CommandLineInfo(String commandPattern, String commandName, String[] flags, String outputFlag, String outputPrefix, String outputName, String[] inputResources) {
            int n;
            int n2;
            String[] stringArray;
            this.commandPattern = commandPattern;
            this.commandName = commandName;
            StringBuilder sb = new StringBuilder();
            if (flags != null) {
                stringArray = flags;
                n2 = flags.length;
                n = 0;
                while (n < n2) {
                    String flag = stringArray[n];
                    sb.append(flag).append(" ");
                    ++n;
                }
            }
            this.flags = sb.toString();
            this.outputFlag = outputFlag;
            this.outputPrefix = outputPrefix;
            this.outputName = outputName;
            sb.setLength(0);
            if (inputResources != null) {
                stringArray = inputResources;
                n2 = inputResources.length;
                n = 0;
                while (n < n2) {
                    String input = stringArray[n];
                    sb.append(input).append(" ");
                    ++n;
                }
            }
            this.inputResources = sb.toString();
            this.command = this.constructCommand();
        }

        private String constructCommand() {
            StringBuffer sb = new StringBuffer();
            Matcher matcher = Pattern.compile("\\$\\{[\\p{Alpha}_]+?\\}").matcher(this.commandPattern);
            while (matcher.find()) {
                String part = matcher.group();
                String replacement = null;
                switch (part) {
                    case "${COMMAND}": {
                        replacement = this.commandName;
                        break;
                    }
                    case "${FLAGS}": {
                        replacement = this.flags;
                        break;
                    }
                    case "${OUTPUT_FLAG}": {
                        replacement = this.outputFlag;
                        break;
                    }
                    case "${OUTPUT_PREFIX}": {
                        replacement = this.outputPrefix;
                        break;
                    }
                    case "${OUTPUT}": {
                        replacement = this.outputName;
                        break;
                    }
                    case "${INPUTS}": {
                        replacement = this.inputResources;
                        break;
                    }
                    default: {
                        replacement = part;
                    }
                }
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        public String getCommandLine() {
            return this.command;
        }

        public String getCommandLinePattern() {
            return this.commandPattern;
        }

        public String getCommandName() {
            return this.commandName;
        }

        public String getFlags() {
            return this.flags;
        }

        public String getInputs() {
            return this.inputResources;
        }

        public String getOutput() {
            return this.outputName;
        }

        public String getOutputFlag() {
            return this.outputFlag;
        }

        public String getOutputPrefix() {
            return this.outputPrefix;
        }
    }
}

