/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.preferences.toolchainmgr;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.function.Consumer;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.x500.X500Principal;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.NaClToolchainsManager;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.ToolchainMgrJob;

public class ShsHandler {
    private static final String ENCODING = "UTF-8";
    private static final String HMAC_ALGORITHM = "HmacSHA1";
    private static final String SERVICE_URL = "https://storage.samsungcloudsolution.com";
    private static final String ACCESS_KEY_NAME = "d402e58084aceab4";
    private static final String ACCESS_KEY_VALUE = "84126f70d70af4e";
    private static final String CONTENTS_ID = "";
    private static final String OPENAPI_PATH = "/openapi/cloud/download/";
    private static final X500Principal SAMSUNG_HUBSITE_CA = new X500Principal("L=Suwon, ST=Kyong-gi, C=KR, O=Samsung Electronics, CN=Samsung Hubsite CA");
    private static final int CONNECTION_TIMEOUT_MS = 5000;

    private static void turnOffCertificateValidation() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustSamsungHubsiteIssued = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
                X509Certificate[] x509CertificateArray = certs;
                int n = certs.length;
                int n2 = 0;
                while (n2 < n) {
                    X509Certificate cert = x509CertificateArray[n2];
                    if (!SAMSUNG_HUBSITE_CA.equals(cert.getIssuerX500Principal())) {
                        throw new CertificateException("Server certificate check failed");
                    }
                    ++n2;
                }
            }
        }};
        SSLContext sc = SSLContext.getInstance("TLS");
        sc.init(null, trustSamsungHubsiteIssued, new SecureRandom());
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static URL getShsFileUrl(String fileName) throws NoSuchAlgorithmException, InvalidKeyException, IOException, KeyManagementException, NaClToolchainsManager.JsonNodeNotFound {
        String authDate = ZonedDateTime.now(ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyyMMdd-HHmmss"));
        StringBuilder request = new StringBuilder();
        request.append("GET\n");
        request.append(OPENAPI_PATH + fileName + "\n");
        request.append("\n");
        request.append(authDate);
        SecretKeySpec keySpec = new SecretKeySpec(ACCESS_KEY_VALUE.getBytes(Charset.forName(ENCODING)), HMAC_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_ALGORITHM);
        mac.init(keySpec);
        mac.update(request.toString().getBytes(Charset.forName(ENCODING)));
        byte[] macBytes = mac.doFinal();
        String macStr = Base64.getEncoder().encodeToString(macBytes);
        String authorization = "SHS d402e58084aceab4:" + macStr;
        Throwable throwable = null;
        Object var9_10 = null;
        try {
            InputStream stream = ShsHandler.openShsRequest("https://storage.samsungcloudsolution.com/openapi/cloud/download/" + fileName, authorization, authDate);
            try {
                if (stream == null) {
                    return null;
                }
                return ShsHandler.getUrlFromShsJsonStream(stream);
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (stream == null) return null;
                stream.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public static void requestGetShsFileUrl(final String fileName, final Consumer<URL> onComplete) throws InvalidKeyException, KeyManagementException, NoSuchAlgorithmException, IOException, NaClToolchainsManager.JsonNodeNotFound {
        ToolchainMgrJob job = new ToolchainMgrJob("Get file URL from SHS service"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    URL url = ShsHandler.getShsFileUrl(fileName);
                    onComplete.accept(url);
                }
                catch (IOException | InvalidKeyException | KeyManagementException | NoSuchAlgorithmException | NaClToolchainsManager.JsonNodeNotFound e) {
                    System.err.println("Failed to request the file URL from SHS");
                    e.printStackTrace();
                    onComplete.accept(null);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    private static InputStream openShsRequest(String apiPath, String authorization, String authorizationDate) throws KeyManagementException, NoSuchAlgorithmException, IOException {
        URL apiUrl = new URL(apiPath);
        ShsHandler.turnOffCertificateValidation();
        HttpsURLConnection connection = (HttpsURLConnection)apiUrl.openConnection();
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod("GET");
        connection.addRequestProperty("Authorization", authorization);
        connection.addRequestProperty("AuthDate", authorizationDate);
        connection.addRequestProperty("Redirect", "false");
        connection.addRequestProperty("ReturnFormat", "JSON");
        connection.connect();
        int retCode = connection.getResponseCode();
        if (retCode != 200) {
            System.err.println("HTTP Error( " + retCode + "): " + connection.getResponseMessage());
            return null;
        }
        return connection.getInputStream();
    }

    private static URL getUrlFromShsJsonStream(InputStream stream) throws JsonProcessingException, IOException, NaClToolchainsManager.JsonNodeNotFound {
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = null;
        root = mapper.readTree(stream);
        if (root == null) {
            System.err.println("JSON root node not found in the SHS response");
            return null;
        }
        JsonNode rspNode = root.get("rsp");
        if (rspNode == null) {
            System.err.println("JSON rsp node not found in the SHS response");
            return null;
        }
        return new URL(NaClToolchainsManager.getJsonNodeValue(rspNode, "URL"));
    }
}

