/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.preferences.toolchainmgr;

import java.util.ArrayDeque;
import java.util.Deque;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Label;

public class ErrorStack {
    private final Deque<Error> errors = new ArrayDeque<Error>();
    private final Label label;

    public ErrorStack(Label label) {
        this.label = label;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setLabelText(Error error) {
        try {
            Label label = this.label;
            synchronized (label) {
                this.label.setText(error != null ? error.toString() : "");
            }
        }
        catch (IllegalArgumentException | SWTException throwable) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushError(Error error) {
        Deque<Error> deque = this.errors;
        synchronized (deque) {
            this.errors.push(error);
        }
        this.setLabelText(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearError(Error error) {
        Error topError;
        Deque<Error> deque = this.errors;
        synchronized (deque) {
            while (this.errors.remove(error)) {
            }
        }
        Deque<Error> deque2 = this.errors;
        synchronized (deque2) {
            topError = this.errors.peek();
        }
        this.setLabelText(topError);
    }

    public static class Error {
        private final String message;

        public Error(String message) {
            this.message = message;
        }

        public String toString() {
            return this.message;
        }

        public boolean equals(Object other) {
            if (other instanceof Error) {
                return this.message.equals(((Error)other).message);
            }
            return false;
        }

        public int hashCode() {
            return this.message.hashCode();
        }
    }
}

