/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.preferences.toolchainmgr;

import java.io.IOException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringButtonFieldEditor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.wb.swt.SWTResourceManager;
import org.tizen.web.tv.sec.nacl.common.plugin.UiUtils;
import org.tizen.web.tv.sec.nacl.preferences.Messages;
import org.tizen.web.tv.sec.nacl.preferences.NaclPreferenceActivator;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.DownloadManager;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.ErrorStack;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.IToolchain;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.NaClToolchain;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.NaClToolchainsManager;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.ShsHandler;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.ToolchainMgrJob;
import org.tizen.web.tv.sec.nacl.preferences.toolchainmgr.ToolchainMgrVerificationJob;

public class ToolchainManagerUi {
    private static final String NACL_TOOLCHAINS_LIST_FILE_NAME = "NaClToolchains.json";
    private static URL NACL_TOOLCHAINS_LIST_URL = null;
    private static final int NACL_SDK_ROOT_EDIT_TIMEOUT = 1000;
    private DirectoryFieldEditor naclSdkDir;
    private Table table;
    private Button downloadButton;
    private Button updateButton;
    private Button removeButton;
    private Button cancelDownloadButton;
    private Button reloadButton;
    private Composite naclSdkDirParent;
    private static final Function<IProgressMonitor, IStatus> removeToolchain = new Function<IProgressMonitor, IStatus>(){

        @Override
        public IStatus apply(IProgressMonitor monitor) {
            IToolchain toolchain = NaclPreferenceActivator.getDefault().getNaClToolchainsManager().getSelectedToolchain();
            if (toolchain != null && ToolchainManagerUi.userConfirmedRemoval(toolchain)) {
                return toolchain.remove(monitor);
            }
            return Status.CANCEL_STATUS;
        }
    };
    private static final Function<IProgressMonitor, IStatus> downloadToolchain = new Function<IProgressMonitor, IStatus>(){

        @Override
        public IStatus apply(IProgressMonitor monitor) {
            return ToolchainManagerUi.handleDownload(monitor, false, true);
        }
    };
    private static final Function<IProgressMonitor, IStatus> updateToolchain = new Function<IProgressMonitor, IStatus>(){

        @Override
        public IStatus apply(IProgressMonitor monitor) {
            return ToolchainManagerUi.handleDownload(monitor, true, true);
        }
    };
    private static final int INITIAL_TABLE_ROWS_COUNT = 8;
    private Timer naclSdkRootChangeTimer = null;
    private ErrorStack errorStack;
    private Consumer<Boolean> enableToolchainConfirmation = null;

    public void setEnableToolchainConfirmation(Consumer<Boolean> consumer) {
        this.enableToolchainConfirmation = consumer;
    }

    public void loadDefaultRootDir() {
        if (this.naclSdkDir != null) {
            this.naclSdkDir.loadDefault();
        }
    }

    public void storeRootDirToPreferences() {
        if (this.naclSdkDir != null) {
            this.naclSdkDir.store();
        }
    }

    public Control createContents(Composite parent) {
        String homeDir;
        Composite naclGroup = new Composite(parent, 0);
        naclGroup.setBounds(parent.getBounds());
        naclGroup.setLayout((Layout)new GridLayout(1, false));
        naclGroup.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label infoLabel = new Label(naclGroup, 64);
        GridData gd_infoLabel = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_infoLabel.heightHint = 23;
        infoLabel.setLayoutData((Object)gd_infoLabel);
        infoLabel.setText(Messages.NaclPreferencePage_PageDescription);
        Composite composite = new Composite(naclGroup, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.naclSdkDir = new DirectoryFieldEditor("nacl.sdk_root", Messages.NaclPreferencePage_sdkRootField, composite);
        this.naclSdkDirParent = composite;
        IPreferenceStore preferenceStore = NaclPreferenceActivator.getDefault().getPreferenceStore();
        this.naclSdkDir.setPreferenceStore(preferenceStore);
        Label errorLabel = new Label(naclGroup, 0);
        errorLabel.setForeground(SWTResourceManager.getColor((int)3));
        errorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.errorStack = new ErrorStack(errorLabel);
        this.table = new Table(naclGroup, 67584);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        TableColumn nameColumn = new TableColumn(this.table, 0);
        nameColumn.setWidth(100);
        nameColumn.setText(Messages.NaclPreferencePage_nameColumnTitle_text);
        TableColumn statusColumn = new TableColumn(this.table, 0);
        statusColumn.setWidth(250);
        statusColumn.setText(Messages.NaclPreferencePage_statusColumnTitle_text);
        TableColumn pathColumn = new TableColumn(this.table, 0);
        pathColumn.setWidth(250);
        pathColumn.setText(Messages.NaclPreferencePage_pathColumnTitle_text);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent event) {
                TableItem item = (TableItem)event.item;
                IToolchain toolchain = NaclPreferenceActivator.getDefault().getNaClToolchainsManager().getToolchains().get(item.getText(0));
                if (toolchain != null) {
                    ToolchainManagerUi.this.updateButtons(toolchain);
                    NaclPreferenceActivator.getDefault().getNaClToolchainsManager().setSelectedToolchain(toolchain);
                    ToolchainManagerUi.this.checkEnableToolchain();
                }
            }
        });
        this.table.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                event.widget.removeListener(9, (Listener)this);
                ToolchainManagerUi.this.requestListUrl();
                try {
                    ToolchainManagerUi.this.refreshTable(ToolchainManagerUi.this.table);
                    ToolchainManagerUi.this.checkEnableToolchain();
                }
                catch (NaClToolchain.UpdateFailure e) {
                    ToolchainManagerUi.this.reportListUpdateFailure(e);
                }
            }
        });
        int i = 0;
        while (i < 8) {
            new TableItem(this.table, 0);
            ++i;
        }
        Composite composite_1 = new Composite(naclGroup, 0);
        composite_1.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        GridLayout gl_composite_1 = new GridLayout(7, false);
        gl_composite_1.marginWidth = 0;
        gl_composite_1.horizontalSpacing = 0;
        composite_1.setLayout((Layout)gl_composite_1);
        this.downloadButton = new Button(composite_1, 0x800000);
        this.downloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ToolchainManagerUi.this.executeJobOnCurrentToolchain(Messages.ToolchainManagerUi_DownloadNaClToolchain, downloadToolchain);
            }
        });
        this.downloadButton.setEnabled(false);
        this.downloadButton.setText(Messages.NaclPreferencePage_downloadButton_text);
        this.updateButton = new Button(composite_1, 0x800000);
        this.updateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ToolchainManagerUi.this.executeJobOnCurrentToolchain(Messages.ToolchainManagerUi_UpdatingToolchain, updateToolchain);
            }
        });
        this.updateButton.setEnabled(false);
        this.updateButton.setText(Messages.NaclPreferencePage_updateButton_text);
        this.removeButton = new Button(composite_1, 0x800000);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                ToolchainManagerUi.this.executeJobOnCurrentToolchain(Messages.ToolchainManagerUi_RemovingToolchain, removeToolchain);
            }
        });
        this.removeButton.setEnabled(false);
        this.removeButton.setText(Messages.NaclPreferencePage_removeButton_text);
        this.cancelDownloadButton = new Button(composite_1, 0x800000);
        this.cancelDownloadButton.setEnabled(false);
        this.cancelDownloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                IToolchain toolchain = NaclPreferenceActivator.getDefault().getNaClToolchainsManager().getSelectedToolchain();
                if (toolchain != null) {
                    toolchain.cancelOperation();
                }
            }
        });
        this.cancelDownloadButton.setText(Messages.NaclPreferencePage_cancelDownloadButton_text);
        Label spacerLabel = new Label(composite_1, 0);
        spacerLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        spacerLabel.setText(Messages.NaclPreferencePage_spacerLabel_text);
        new Label(composite_1, 0);
        this.reloadButton = new Button(composite_1, 0x800000);
        this.reloadButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent ev) {
                try {
                    ToolchainManagerUi.this.refreshTable(ToolchainManagerUi.this.table);
                    ToolchainManagerUi.this.checkEnableToolchain();
                }
                catch (NaClToolchain.UpdateFailure e) {
                    ToolchainManagerUi.this.reportListUpdateFailure(e);
                }
            }
        });
        this.reloadButton.setText(Messages.NaclPreferencePage_reloadButton_text);
        this.naclSdkDir.load();
        if (this.naclSdkDir.getStringValue().isEmpty() && (homeDir = System.getProperty("user.home")) != null && !homeDir.isEmpty()) {
            this.naclSdkDir.setStringValue(homeDir);
        }
        this.naclSdkDir.getTextControl(composite).addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                if (ToolchainManagerUi.this.naclSdkRootChangeTimer != null) {
                    ToolchainManagerUi.this.naclSdkRootChangeTimer.cancel();
                }
                ToolchainManagerUi.this.naclSdkRootChangeTimer = new Timer();
                ToolchainManagerUi.this.naclSdkRootChangeTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        UiUtils.callOnUiThread((boolean)false, (UiUtils.VarArgFunction)new UiUtils.VarArgFunction<Object, Object>(){

                            public Object function(Object ... params) {
                                try {
                                    ToolchainManagerUi.this.onNaclSdkRootReady();
                                }
                                catch (InterruptedException | OperationCanceledException e) {
                                    System.err.println("Cancelling background jobs failed");
                                    e.printStackTrace();
                                }
                                return null;
                            }
                        }, (Object[])new Object[]{""});
                    }
                }, 1000L);
            }
        });
        NaClToolchain.setOnStatusChange(new Runnable(){

            @Override
            public void run() {
                NaClToolchainsManager mgr = NaclPreferenceActivator.getDefault().getNaClToolchainsManager();
                mgr.putToolchainsIntoTable(ToolchainManagerUi.this.table);
                IToolchain selectedToolchain = mgr.getSelectedToolchain();
                if (selectedToolchain != null) {
                    ToolchainManagerUi.this.updateButtons(selectedToolchain);
                    ToolchainManagerUi.this.checkEnableToolchain();
                }
                if (mgr.shouldEnableTargetPathChange()) {
                    ToolchainManagerUi.this.buttonSetEnable((StringButtonFieldEditor)ToolchainManagerUi.this.naclSdkDir, true);
                } else {
                    ToolchainManagerUi.this.buttonSetEnable((StringButtonFieldEditor)ToolchainManagerUi.this.naclSdkDir, false);
                }
            }
        });
        return naclGroup;
    }

    private void requestListUrl() {
        try {
            this.errorStack.pushError(ErrorMessages.WAITING_SERVER_DATA.error);
            ShsHandler.requestGetShsFileUrl(NACL_TOOLCHAINS_LIST_FILE_NAME, new Consumer<URL>(){

                @Override
                public void accept(URL url) {
                    System.out.println("Got URL from SHS: " + url);
                    NACL_TOOLCHAINS_LIST_URL = url;
                    UiUtils.callOnUiThread((boolean)false, (Consumer)new Consumer<Object>(){

                        @Override
                        public void accept(Object dummy) {
                            ToolchainManagerUi.this.errorStack.clearError(ErrorMessages.WAITING_SERVER_DATA.error);
                        }
                    }, null);
                    UiUtils.callOnUiThread((boolean)false, (Consumer)new Consumer<Table>(){

                        @Override
                        public void accept(Table table) {
                            try {
                                ToolchainManagerUi.this.refreshTable(table);
                                ToolchainManagerUi.this.checkEnableToolchain();
                            }
                            catch (NaClToolchain.UpdateFailure e) {
                                e.printStackTrace();
                            }
                        }
                    }, (Object)ToolchainManagerUi.this.table);
                }
            });
        }
        catch (IOException | InvalidKeyException | KeyManagementException | NoSuchAlgorithmException | NaClToolchainsManager.JsonNodeNotFound e) {
            System.err.println("Failed to retrieve the URL of the file NaClToolchains.json from the SHS");
            e.printStackTrace();
        }
    }

    private void reportListUpdateFailure(NaClToolchain.UpdateFailure ev) {
        this.table.setVisible(false);
        this.errorStack.pushError(ErrorMessages.OPERATION_ONGOING.error);
    }

    private void clearListUpdateFailure() {
        this.table.setVisible(true);
        this.errorStack.clearError(ErrorMessages.OPERATION_ONGOING.error);
    }

    private static void handleOperationError(NaClToolchain.OperationStatus status, final IToolchain toolchain) {
        switch (status.getOperationType()) {
            case DOWNLOAD: {
                String errorMessage = String.valueOf(status.getMessage()) + Messages.ToolchainManagerUi_DeletePartiallyDownloadedFile;
                if (!MessageDialog.openQuestion(null, (String)Messages.ToolchainManagerUi_DownloadingError, (String)errorMessage)) break;
                ToolchainMgrJob deleteJob = new ToolchainMgrJob(Messages.ToolchainManagerUi_DeletingPartiallyDownloaded){

                    protected IStatus run(IProgressMonitor monitor) {
                        return DownloadManager.remove(toolchain.getTargetFile(), monitor);
                    }
                };
                deleteJob.setUser(true);
                deleteJob.schedule();
                break;
            }
            case UNZIP: {
                ToolchainMgrJob deleteJob = new ToolchainMgrJob(Messages.ToolchainManagerUi_DeletingPartiallyDecompressed){

                    protected IStatus run(IProgressMonitor monitor) {
                        return DownloadManager.remove(toolchain.getPath(), monitor);
                    }
                };
                deleteJob.setUser(true);
                deleteJob.schedule();
                String errorMessage = String.valueOf(status.getMessage()) + Messages.ToolchainManagerUi_PackageBroken;
                if (!MessageDialog.openQuestion(null, (String)Messages.ToolchainManagerUi_DecompressionError, (String)errorMessage)) break;
                ToolchainMgrJob job = new ToolchainMgrJob(Messages.ToolchainManagerUi_DownloadNaClToolchain){

                    protected IStatus run(IProgressMonitor monitor) {
                        return ToolchainManagerUi.handleDownload(monitor, true, false);
                    }
                };
                job.setUser(true);
                job.schedule();
                break;
            }
            default: {
                MessageDialog.openError(null, (String)((Object)((Object)status.getOperationType()) + Messages.ToolchainManagerUi_OperationError), (String)status.getMessage());
            }
        }
    }

    private static boolean userConfirmedRemoval(IToolchain toolchain) {
        String message = null;
        switch (toolchain.getStatus()) {
            case MODIFIED: 
            case MODIFIED_UPDATE_AVAILABLE: {
                message = Messages.ToolchainManagerUi_RemoveModifiedToolchain;
                break;
            }
            default: {
                message = Messages.ToolchainManagerUi_RemoveToolchain;
            }
        }
        return (Boolean)UiUtils.callOnUiThread((boolean)true, (UiUtils.VarArgFunction)new UiUtils.VarArgFunction<String, Boolean>(){

            public Boolean function(String ... params) {
                MessageDialog md = new MessageDialog(null, params[0], null, params[1], 3, 0, new String[]{Messages.ToolchainManagerUi_No, Messages.ToolchainManagerUi_Yes});
                if (md.open() == 1) {
                    return true;
                }
                return false;
            }
        }, (Object[])new String[]{Messages.ToolchainManagerUi_Question, message});
    }

    private static IStatus handleDownload(IProgressMonitor monitor, boolean redownload, boolean reinstall) {
        final IToolchain toolchain = NaclPreferenceActivator.getDefault().getNaClToolchainsManager().getSelectedToolchain();
        if (toolchain != null) {
            if (toolchain.isInstalled() && !ToolchainManagerUi.userConfirmedRemoval(toolchain)) {
                System.out.println("The user cancelled the update of modified toolchain");
                return Status.CANCEL_STATUS;
            }
            final IStatus status = toolchain.install(monitor, redownload, reinstall);
            if (status.getSeverity() != 0) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (status instanceof NaClToolchain.OperationStatus) {
                            ToolchainManagerUi.handleOperationError((NaClToolchain.OperationStatus)status, toolchain);
                        } else {
                            System.out.println("Installation of the toolchain:\n" + toolchain + "\nwas cancelled by the user");
                        }
                    }
                });
            }
            return status;
        }
        return Status.CANCEL_STATUS;
    }

    private void buttonSetEnable(Button button, boolean enable) {
        if (button != null) {
            try {
                button.setEnabled(enable);
            }
            catch (SWTException sWTException) {
                return;
            }
        }
    }

    private void buttonSetEnable(StringButtonFieldEditor fieldEditor, boolean enable) {
        if (fieldEditor != null && this.naclSdkDirParent != null) {
            try {
                fieldEditor.setEnabled(enable, this.naclSdkDirParent);
            }
            catch (IllegalArgumentException | SWTException throwable) {
                return;
            }
        }
    }

    protected void updateButtons(IToolchain toolchain) {
        boolean cancel = false;
        boolean download = false;
        boolean remove = false;
        boolean update = false;
        switch (toolchain.getStatus()) {
            case INSTALLED: {
                remove = true;
                break;
            }
            case INSTALLING: 
            case VERYFING: {
                cancel = true;
                break;
            }
            case NOT_INSTALLED: {
                download = toolchain.getUrl() != null;
                break;
            }
            case UPDATE_AVAILABLE: 
            case MODIFIED_UPDATE_AVAILABLE: {
                remove = true;
                update = true;
                break;
            }
            case MODIFIED: {
                download = true;
                remove = true;
                break;
            }
        }
        this.buttonSetEnable(this.cancelDownloadButton, cancel);
        this.buttonSetEnable(this.downloadButton, download);
        this.buttonSetEnable(this.removeButton, remove);
        this.buttonSetEnable(this.updateButton, update);
    }

    private void cancelVerificationJob(String jobName) {
        Job[] verificationJobs;
        IJobManager jobManager = Job.getJobManager();
        Job[] jobArray = verificationJobs = jobManager.find((Object)ToolchainMgrVerificationJob.VERIFICATION_JOBS_FAMILY_ID);
        int n = verificationJobs.length;
        int n2 = 0;
        while (n2 < n) {
            Job job = jobArray[n2];
            if (job.getName().equals(jobName)) {
                job.cancel();
            }
            ++n2;
        }
    }

    private void requestToolchainsValidation() {
        NaClToolchainsManager mgr = NaclPreferenceActivator.getDefault().getNaClToolchainsManager();
        for (final IToolchain iToolchain : mgr.getToolchains().values()) {
            switch (iToolchain.getStatus()) {
                case INSTALLED: 
                case UPDATE_AVAILABLE: 
                case MODIFIED: 
                case MODIFIED_UPDATE_AVAILABLE: {
                    String jobName = String.valueOf(Messages.ToolchainManagerUi_ValidatingToolchain) + iToolchain.getName();
                    this.cancelVerificationJob(jobName);
                    ToolchainMgrVerificationJob job = new ToolchainMgrVerificationJob(jobName){

                        protected IStatus run(IProgressMonitor monitor) {
                            try {
                                return iToolchain.verify(monitor);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                                return new Status(4, "org.tizen.web.tv.sec.nacl.preferences", String.valueOf(Messages.ToolchainManagerUi_Toolchain) + iToolchain.getName() + Messages.ToolchainManagerUi_ValidationFailed, (Throwable)e);
                            }
                            catch (NoSuchAlgorithmException e) {
                                e.printStackTrace();
                                return Status.CANCEL_STATUS;
                            }
                        }
                    };
                    job.setUser(true);
                    job.schedule();
                    break;
                }
            }
        }
    }

    private void refreshTable(Table table) throws NaClToolchain.UpdateFailure {
        if (table == null || this.naclSdkDir == null) {
            return;
        }
        NaClToolchainsManager mgr = NaclPreferenceActivator.getDefault().getNaClToolchainsManager();
        try {
            mgr.initialize(NACL_TOOLCHAINS_LIST_URL, this.naclSdkDir.getStringValue());
            this.requestToolchainsValidation();
        }
        catch (IOException iOException) {
            System.err.println("Initialization of the NaCl toolchains' list from the server failed, falling back to initialization from resources");
            URL localListUrl = this.getClass().getClassLoader().getResource("/resources/NaClToolchains.json");
            try {
                mgr.initialize(localListUrl, this.naclSdkDir.getStringValue());
                this.requestToolchainsValidation();
            }
            catch (IOException e1) {
                System.err.println("Initialization of the NaCl toolchains' list from resources failed");
                e1.printStackTrace();
            }
        }
        mgr.putToolchainsIntoTable(table);
        IToolchain toolchain = mgr.getSelectedToolchain();
        if (toolchain != null) {
            this.updateButtons(toolchain);
        }
        if (!mgr.isInitializedFromUrl()) {
            this.errorStack.pushError(ErrorMessages.CANNOT_CONTACT_SERVER.error);
        } else {
            this.errorStack.clearError(ErrorMessages.CANNOT_CONTACT_SERVER.error);
        }
        this.clearListUpdateFailure();
    }

    private void executeJobOnCurrentToolchain(String jobName, final Function<IProgressMonitor, IStatus> operation) {
        IToolchain toolchain = NaclPreferenceActivator.getDefault().getNaClToolchainsManager().getSelectedToolchain();
        if (toolchain != null) {
            ToolchainMgrJob job = new ToolchainMgrJob(jobName){

                protected IStatus run(IProgressMonitor monitor) {
                    return (IStatus)operation.apply(monitor);
                }
            };
            job.setUser(true);
            job.schedule();
        }
    }

    private void onNaclSdkRootReady() throws OperationCanceledException, InterruptedException {
        try {
            this.refreshTable(this.table);
            this.checkEnableToolchain();
        }
        catch (NaClToolchain.UpdateFailure e) {
            this.reportListUpdateFailure(e);
        }
    }

    private void checkEnableToolchain() {
        boolean pageComplete = false;
        IToolchain toolchain = this.getSelectedToolchain();
        if (toolchain != null) {
            switch (toolchain.getStatus()) {
                case INSTALLED: 
                case UPDATE_AVAILABLE: 
                case VERYFING: 
                case MODIFIED: 
                case MODIFIED_UPDATE_AVAILABLE: {
                    pageComplete = true;
                    break;
                }
                default: {
                    pageComplete = false;
                }
            }
        }
        if (this.enableToolchainConfirmation != null) {
            this.enableToolchainConfirmation.accept(pageComplete);
        }
    }

    public void cancelVerification() throws OperationCanceledException, InterruptedException {
        IJobManager mgr = Job.getJobManager();
        mgr.cancel((Object)ToolchainMgrVerificationJob.VERIFICATION_JOBS_FAMILY_ID);
    }

    public void setSelectedToolchain(String name) {
        if (name == null || name.isEmpty()) {
            return;
        }
        NaClToolchainsManager mgr = NaclPreferenceActivator.getDefault().getNaClToolchainsManager();
        Map<String, NaClToolchain> toolchains = mgr.getToolchains();
        IToolchain toolchainToSelect = toolchains.get(name);
        if (toolchainToSelect != null) {
            mgr.setSelectedToolchain(toolchainToSelect);
        }
    }

    public IToolchain getSelectedToolchain() {
        return NaclPreferenceActivator.getDefault().getNaClToolchainsManager().getSelectedToolchain();
    }

    static enum ErrorMessages {
        WAITING_SERVER_DATA(new ErrorStack.Error(Messages.ToolchainManagerUi_WaitingForData)),
        CANNOT_CONTACT_SERVER(new ErrorStack.Error(Messages.ToolchainManagerUi_CannotContactServer)),
        OPERATION_ONGOING(new ErrorStack.Error(Messages.ToolchainManagerUi_OperationOngoing));

        private final ErrorStack.Error error;

        private ErrorMessages(ErrorStack.Error error) {
            this.error = error;
        }

        public String toString() {
            return this.error.toString();
        }
    }
}

