/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.common.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;

public class NaClModuleUtils {
    public static final String SCRIPT_DIRECTORY_NAME = "scripts";
    public static final String CURRENT_BIN_DIRECTORY_NAME = "CurrentBin";
    public static final String RESOURCES_DIRECTORY_NAME = "resources";
    public static final String INDEX_HTML_FILE_NAME = "index.html";
    public static final String NACL_MODULES_DIRECTORY = "nacl_modules";
    public static final String CONFIG_XML_NAME = "config.xml";
    public static final String SOURCE_DIRECTORY_NAME = "src";
    public static final String INCLUDE_DIRECTORY_NAME = "inc";

    public static String getNaClModuleBasePath(IProject naclProject) {
        return NaClModuleUtils.getProjectBasePath(naclProject);
    }

    public static String getNaClModuleConfigFilePath(IProject naclProject) {
        return String.valueOf(NaClModuleUtils.getNaClModuleBasePath(naclProject)) + File.separator + CONFIG_XML_NAME;
    }

    public static String getNaClModuleCurrentBinPath(IProject naclProject) {
        return String.valueOf(NaClModuleUtils.getNaClModuleBasePath(naclProject)) + File.separator + CURRENT_BIN_DIRECTORY_NAME;
    }

    public static String getNaClModuleIndexHtmlFilePath(IProject naclProject) {
        return String.valueOf(NaClModuleUtils.getNaClModuleBasePath(naclProject)) + File.separator + INDEX_HTML_FILE_NAME;
    }

    public static String getNaClModuleName(IProject naclProject) {
        return naclProject.getName();
    }

    public static String getNaClModuleResourcesPath(IProject naclProject) {
        return String.valueOf(NaClModuleUtils.getNaClModuleBasePath(naclProject)) + File.separator + RESOURCES_DIRECTORY_NAME;
    }

    public static IProject[] getNaClModules(IProject project) {
        HashSet<IProject> naclModules = new HashSet<IProject>();
        try {
            IProject[] iProjectArray = project.getReferencedProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject referencedProject = iProjectArray[n2];
                if (ProjectUtils.isNaClProject(referencedProject) && NaClModuleUtils.isNaClModuleInsideProject(referencedProject, project)) {
                    naclModules.add(referencedProject);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            naclModules.clear();
        }
        return naclModules.toArray(new IProject[0]);
    }

    public static String getNaClModuleScriptsPath(IProject naclProject) {
        return String.valueOf(NaClModuleUtils.getNaClModuleBasePath(naclProject)) + File.separator + SCRIPT_DIRECTORY_NAME;
    }

    public static String getProjectBasePath(IProject project) {
        return project.getLocation().toOSString();
    }

    public static IProject getTizenProject(IProject naclProject) {
        IProject[] referencingProjects;
        if (naclProject == null || !naclProject.isOpen() || !ProjectUtils.isNaClProject(naclProject)) {
            return null;
        }
        IProject[] iProjectArray = referencingProjects = naclProject.getReferencingProjects();
        int n = referencingProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject referencingProject = iProjectArray[n2];
            if (ProjectUtils.isWebTvTizenProject(referencingProject) && NaClModuleUtils.isNaClModuleInsideProject(naclProject, referencingProject)) {
                return referencingProject;
            }
            ++n2;
        }
        return null;
    }

    public static String getTizenProjectBasePath(IProject tizenProject) {
        return NaClModuleUtils.getProjectBasePath(tizenProject);
    }

    public static String getTizenProjectConfigFilePath(IProject tizenProject) {
        return String.valueOf(NaClModuleUtils.getTizenProjectBasePath(tizenProject)) + File.separator + CONFIG_XML_NAME;
    }

    public static String getTizenProjectIndexHtmlFilePath(IProject tizenProject) {
        return String.valueOf(NaClModuleUtils.getTizenProjectBasePath(tizenProject)) + File.separator + INDEX_HTML_FILE_NAME;
    }

    public static String getTizenProjectNaClModulesScriptsPath(IProject tizenProject) {
        return String.valueOf(NaClModuleUtils.getTizenProjectBasePath(tizenProject)) + File.separator + NACL_MODULES_DIRECTORY + File.separator + SCRIPT_DIRECTORY_NAME;
    }

    public static String getTizenProjectResourcesPath(IProject tizenProject) {
        return String.valueOf(NaClModuleUtils.getTizenProjectBasePath(tizenProject)) + File.separator + RESOURCES_DIRECTORY_NAME;
    }

    private static boolean isNaClModuleInsideProject(IProject naclProject, IProject project) {
        String naclProjectPath = NaClModuleUtils.getNaClModuleBasePath(naclProject);
        String projectFullPath = NaClModuleUtils.getProjectBasePath(project);
        return naclProjectPath.contains(projectFullPath);
    }

    public static Document parseFile(File file) {
        Document moduleDoc = null;
        try {
            moduleDoc = Jsoup.parse((File)file, (String)"UTF-8");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return moduleDoc;
    }

    public static void saveContentToFile(String filePath, String content) {
        Path path = Paths.get(filePath, new String[0]);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                writer.write(content);
                writer.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

