/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.web.tv.sec.nacl.mtwizard;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.tizen.web.tv.sec.nacl.common.LoggerInitializer;
import org.tizen.web.tv.sec.nacl.common.plugin.ProjectUtils;
import org.tizen.web.tv.sec.nacl.mtgenerator.CompositeMessageData;
import org.tizen.web.tv.sec.nacl.mtgenerator.IMessageDataVisitor;
import org.tizen.web.tv.sec.nacl.mtgenerator.JsMessage;
import org.tizen.web.tv.sec.nacl.mtgenerator.Message;
import org.tizen.web.tv.sec.nacl.mtgenerator.MessageData;
import org.tizen.web.tv.sec.nacl.mtgenerator.NaClMessage;
import org.tizen.web.tv.sec.nacl.mtgenerator.SimpleMessageData;
import org.tizen.web.tv.sec.nacl.mtwizard.MessageDialog;
import org.tizen.web.tv.sec.nacl.mtwizard.Messages;
import org.tizen.web.tv.sec.nacl.mtwizard.SourceGeneratorRunner;

class Helpers {
    private static Logger logger;
    public static final int DefaultMaxLineLength = 72;

    static {
        try {
            LoggerInitializer.initialize((String)("%t/mtwizard_" + System.getProperty("user.name") + "_%g.log"), (Level)Level.WARNING);
        }
        catch (SecurityException ex) {
            System.err.println("Could not initialize the logger");
            ex.printStackTrace();
        }
        catch (IOException ex) {
            System.err.println("Could not initialize the logger");
            ex.printStackTrace();
        }
        logger = Logger.getLogger("org.tizen.web.tv.sec.nacl.mtwizard");
    }

    Helpers() {
    }

    public static boolean equals(TableItem tableItem, int startCompareAtColumn, String ... columns) {
        if (columns.length <= startCompareAtColumn) {
            throw new IndexOutOfBoundsException("startCompareAtColumn is equal or greater than the number of columns");
        }
        int columnIndex = startCompareAtColumn;
        while (columnIndex < columns.length) {
            if (!columns[columnIndex].equals(tableItem.getText(columnIndex))) {
                return false;
            }
            ++columnIndex;
        }
        return true;
    }

    public static boolean equals(TreeItem treeItem, int startCompareAtColumn, String ... columns) {
        if (columns.length <= startCompareAtColumn) {
            throw new IndexOutOfBoundsException("startCompareAtColumn is equal or greater than the number of columns");
        }
        int columnIndex = startCompareAtColumn;
        while (columnIndex < columns.length) {
            if (!columns[columnIndex].equals(treeItem.getText(columnIndex))) {
                return false;
            }
            ++columnIndex;
        }
        return true;
    }

    public static boolean equals(TableItem tableItem, String ... columns) {
        return Helpers.equals(tableItem, 0, columns);
    }

    static void addTableItem(Table table, Color textColor, String ... columns) {
        String tableItem;
        StringBuilder sb = new StringBuilder("");
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            sb.append(String.valueOf(column) + ", ");
            ++n2;
        }
        logger.finest("Adding the Message: (" + sb.toString() + ")");
        if (table == null || columns.length < 1) {
            logger.finest("table == null or zero columns passed");
            return;
        }
        stringArray = table.getItems();
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            tableItem = stringArray[n2];
            if (tableItem.getText(0).equals(columns[0])) {
                if (Helpers.equals((TableItem)tableItem, 1, columns)) {
                    return;
                }
                int columnIndex = 1;
                while (columnIndex < columns.length) {
                    tableItem.setText(columnIndex, columns[columnIndex]);
                    tableItem.setForeground(textColor);
                    ++columnIndex;
                }
                return;
            }
            ++n2;
        }
        tableItem = new TableItem(table, 0);
        int columnIndex = 0;
        String[] stringArray2 = columns;
        int n3 = columns.length;
        int n4 = 0;
        while (n4 < n3) {
            String column = stringArray2[n4];
            tableItem.setText(columnIndex++, column);
            tableItem.setForeground(textColor);
            ++n4;
        }
        TableItem[] selection = new TableItem[]{tableItem};
        table.setSelection(selection);
    }

    static TreeItem addTreeItem(Tree tree, Color textColor, String ... columns) {
        StringBuilder sb = new StringBuilder("");
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            sb.append(String.valueOf(column) + ", ");
            ++n2;
        }
        logger.finest("Adding the Message: (" + sb.toString() + ")");
        if (tree == null || columns.length < 1) {
            logger.finest("table == null or zero columns passed");
            return null;
        }
        if (Helpers.updateTreeItem(tree.getItems(), textColor, columns)) {
            return null;
        }
        TreeItem treeItem = new TreeItem(tree, 0);
        Helpers.fillTreeItemData(treeItem, textColor, columns);
        TreeItem[] selection = new TreeItem[]{treeItem};
        tree.setSelection(selection);
        return treeItem;
    }

    static TreeItem addTreeItem(TreeItem parent, Color textColor, String ... columns) {
        logger.finest("Adding the Message: (" + Helpers.varargsToString(columns) + ")");
        if (parent == null || columns.length < 1) {
            logger.finest("parent == null or zero columns passed");
            return null;
        }
        if (Helpers.updateTreeItem(parent.getItems(), textColor, columns)) {
            return null;
        }
        int childCount = parent.getItemCount();
        int insertPosition = Math.max(childCount - 1, 0);
        TreeItem newItem = new TreeItem(parent, 0, insertPosition);
        Helpers.fillTreeItemData(newItem, textColor, columns);
        return newItem;
    }

    static boolean updateTreeItem(TreeItem[] items, Color textColor, String ... columns) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            if (treeItem.getText(0).equals(columns[0])) {
                if (Helpers.equals(treeItem, 1, columns)) {
                    return true;
                }
                int columnIndex = 1;
                while (columnIndex < columns.length) {
                    treeItem.setText(columnIndex, columns[columnIndex]);
                    treeItem.setForeground(textColor);
                    ++columnIndex;
                }
                return true;
            }
            ++n2;
        }
        return false;
    }

    static void fillTreeItemData(TreeItem item, Color textColor, String ... columns) {
        int columnIndex = 0;
        String[] stringArray = columns;
        int n = columns.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            item.setText(columnIndex++, column);
            item.setForeground(textColor);
            ++n2;
        }
        TreeItem current = item;
        while (current.getParentItem() != null) {
            current = current.getParentItem();
        }
        Tree root = current.getParent();
        root.setSelection(item);
    }

    static String varargsToString(String ... args) {
        StringBuilder sb = new StringBuilder();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            sb.append(arg).append(", ");
            ++n2;
        }
        sb.delete(sb.length() - 2, sb.length() - 1);
        return sb.toString();
    }

    static boolean isItemContainedIn(TreeItem[] items, String name) {
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem ti = treeItemArray[n2];
            if (ti.getText(0).equals(name)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void fillTreeWithMessageData(Tree tree, Message msg) {
        logger.finest("The message " + msg.getName() + " contains " + msg.getData().size() + " parameters");
        for (MessageData messageData : msg.getData()) {
            messageData.accept((IMessageDataVisitor)new FillTreeMessageDataVisitor(tree));
        }
    }

    public static void fillTableWithMessages(Table table, SourceGeneratorRunner sgr) {
        logger.finest("We have " + sgr.getMessages().size() + " messages to fill into the table.");
        String messageType = "Unknown";
        String synchronous = "Unknown";
        for (Message msg : sgr.getMessages().values()) {
            messageType = msg.getType().toString();
            if (msg instanceof NaClMessage) {
                synchronous = "";
            } else if (msg instanceof JsMessage) {
                synchronous = "" + ((JsMessage)msg).isSynchronous();
            }
            StringBuilder dataString = new StringBuilder();
            Iterator mdIt = msg.getData().iterator();
            String separator = new String("");
            while (mdIt.hasNext()) {
                dataString.append(String.valueOf(separator) + mdIt.next());
                if (separator.length() != 0) continue;
                separator = ", ";
            }
            Helpers.addTableItem(table, null, msg.getName(), messageType, dataString.toString(), synchronous);
        }
    }

    private static int message(Shell parent, String message, MessageBoxType type) {
        MessageBox mb = new MessageBox(parent, type != MessageBoxType.Confirmation ? 32 : 192);
        switch (type) {
            case Error: {
                mb.setText(Messages.CommonStringsError);
                break;
            }
            case Success: {
                mb.setText(Messages.CommonStringsSuccess);
                break;
            }
            case Information: {
                mb.setText(Messages.CommonStringsInformation);
                break;
            }
            case Confirmation: {
                mb.setText(Messages.CommonStringsConfirmation);
                break;
            }
            default: {
                mb.setText("");
            }
        }
        mb.setMessage(message);
        return mb.open();
    }

    public static int errorMessage(Shell parent, String message) {
        return Helpers.message(parent, message, MessageBoxType.Error);
    }

    public static int successMessage(Shell parent, String message) {
        return Helpers.message(parent, message, MessageBoxType.Success);
    }

    public static int informationMessage(Shell parent, String message) {
        return Helpers.message(parent, message, MessageBoxType.Information);
    }

    public static int confirmationMessage(Shell parent, String message) {
        return Helpers.message(parent, message, MessageBoxType.Confirmation);
    }

    public static void centerShellRelativeToParent(Shell parent, Shell currentShell) {
        Point center = new Point(parent.getBounds().x + (int)Math.round((double)parent.getBounds().width / 2.0), parent.getBounds().y + (int)Math.round((double)parent.getBounds().height / 2.0));
        currentShell.setLocation(center.x - (int)Math.round((double)currentShell.getSize().x / 2.0), center.y - (int)Math.round((double)currentShell.getSize().y / 2.0));
    }

    public static String getCurrentProjectPath() {
        IPath urlProjectPath = null;
        IProject project = ProjectUtils.getCurrentProject();
        if (project == null) {
            logger.warning("Could not determine the path of the selected project");
            return null;
        }
        urlProjectPath = project.getLocation();
        logger.finest("Project path: " + urlProjectPath);
        if (urlProjectPath != null) {
            return urlProjectPath.toString().replaceAll("/", Matcher.quoteReplacement(File.separator));
        }
        return null;
    }

    public static String breakMessageIntoLines(String message, int maxLineLength) {
        StringBuilder processedMsg = new StringBuilder();
        while (message.length() > maxLineLength) {
            int index = -1;
            index = message.substring(0, maxLineLength).lastIndexOf(10);
            if (index > -1) {
                processedMsg.append(message.substring(0, index));
                message = message.substring(index + 1);
                continue;
            }
            index = message.substring(0, maxLineLength - 1).lastIndexOf(32);
            if (index < 0) {
                index = maxLineLength - 1;
            }
            processedMsg.append(String.valueOf(message.substring(0, ++index)) + "\n");
            message = message.substring(index);
        }
        processedMsg.append(message);
        return processedMsg.toString();
    }

    private static class FillTreeMessageDataVisitor
    implements IMessageDataVisitor {
        private final Tree root;
        private TreeItem subtree;

        public FillTreeMessageDataVisitor(Tree root) {
            this.root = root;
        }

        public void visit(SimpleMessageData md) {
            String name = md.getName();
            String description = md.getDescription();
            if (this.subtree == null) {
                Helpers.addTreeItem(this.root, null, name, md.getType().toString(), description);
            } else {
                Helpers.addTreeItem(this.subtree, null, name, md.getType().toString(), description);
            }
        }

        public void preVisit(CompositeMessageData md) {
            String name = md.getName();
            String description = md.getDescription();
            this.subtree = this.subtree == null ? Helpers.addTreeItem(this.root, null, name, "Dictionary", description) : Helpers.addTreeItem(this.subtree, null, name, "Dictionary", description);
            Helpers.addTreeItem(this.subtree, null, "---", "---", MessageDialog.dictDefaultChildDesc);
        }

        public void postVisit(CompositeMessageData md) {
            this.subtree = this.subtree.getParentItem();
        }
    }

    private static enum MessageBoxType {
        Success,
        Error,
        Information,
        Confirmation;

    }
}

